/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.dao.dnq.api.security;

import jetbrains.jetpass.dao.dnq.api.security.JetPassChildSecurity;
import jetbrains.jetpass.dao.dnq.api.security.JetPassProjectSecurity;
import jetbrains.jetpass.dao.dnq.api.security.JetPassResourceSecurity$filter$resourcesOfReadableProjects$1;
import jetbrains.jetpass.dao.dnq.api.security.JetPassServiceSecurity;
import jetbrains.jetpass.dao.dnq.api.security.Security;
import jetbrains.jetpass.dao.dnq.api.security.SecurityUtilKt;
import jetbrains.jetpass.userManagement.persistence.dnq.XdAuthorityHolder;
import jetbrains.jetpass.userManagement.persistence.dnq.XdBaseUser;
import jetbrains.jetpass.userManagement.persistence.dnq.XdProject;
import jetbrains.jetpass.userManagement.persistence.dnq.XdResource;
import jetbrains.jetpass.userManagement.persistence.dnq.XdService;
import jetbrains.jetpass.userManagement.persistence.dnq.XdUUIDObject;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty1;
import kotlin.sequences.Sequence;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import kotlinx.dnq.util.ReflectionUtilKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0011\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0017\u001a\u00020\u0015H\u0016J\u0012\u0010\u0018\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0002H\u0016J\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007H\u0016J\u0014\u0010\u001b\u001a\u0004\u0018\u00010\u00032\b\u0010\u001c\u001a\u0004\u0018\u00010\u0002H\u0014R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001d"}, d2={"Ljetbrains/jetpass/dao/dnq/api/security/JetPassResourceSecurity;", "Ljetbrains/jetpass/dao/dnq/api/security/JetPassChildSecurity;", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdResource;", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdService;", "xdFixedService", "(Ljetbrains/jetpass/userManagement/persistence/dnq/XdService;)V", "allSecured", "Lkotlinx/dnq/query/XdQuery;", "getAllSecured", "()Lkotlinx/dnq/query/XdQuery;", "parentSecurity", "Ljetbrains/jetpass/dao/dnq/api/security/JetPassServiceSecurity;", "getParentSecurity", "()Ljetbrains/jetpass/dao/dnq/api/security/JetPassServiceSecurity;", "projectSecurity", "Ljetbrains/jetpass/dao/dnq/api/security/JetPassProjectSecurity;", "getProjectSecurity", "()Ljetbrains/jetpass/dao/dnq/api/security/JetPassProjectSecurity;", "getXdFixedService", "()Ljetbrains/jetpass/userManagement/persistence/dnq/XdService;", "canRead", "", "xd", "full", "canUpdate", "filter", "unsecured", "getParentItem", "xdChild", "jetbrains.jetpass.dao.dnq"})
public final class JetPassResourceSecurity
extends JetPassChildSecurity<XdResource, XdService> {
    @NotNull
    private final JetPassProjectSecurity projectSecurity;
    @NotNull
    private final JetPassServiceSecurity parentSecurity;
    @Nullable
    private final XdService xdFixedService;

    @NotNull
    public final JetPassProjectSecurity getProjectSecurity() {
        return this.projectSecurity;
    }

    @NotNull
    public JetPassServiceSecurity getParentSecurity() {
        return this.parentSecurity;
    }

    @Override
    @NotNull
    public XdQuery<XdResource> getAllSecured() {
        throw (Throwable)new UnsupportedOperationException();
    }

    @Override
    public boolean canRead(@Nullable XdResource xd, boolean full) {
        boolean bl;
        XdService service = this.getParentItem(xd);
        if (this.getParentSecurity().canReadByPermission(service)) {
            bl = true;
        } else if (this.getParentSecurity().canReadByGroupVisibility(service)) {
            XdResource xdResource2 = xd;
            bl = Security.DefaultImpls.canRead$default(this.projectSecurity, (XdEntity)(xdResource2 != null ? xdResource2.getProject() : null), false, 2, null);
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canUpdate(@Nullable XdResource xd) {
        if (this.getParentSecurity().canUpdate(this.getParentItem(xd))) return true;
        if (!Security.DefaultImpls.canRead$default(this, (XdEntity)xd, false, 2, null)) return false;
        XdResource xdResource2 = xd;
        if (!this.projectSecurity.canUpdate((XdUUIDObject)(xdResource2 != null ? xdResource2.getProject() : null))) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public XdQuery<XdResource> filter(@NotNull XdQuery<XdResource> unsecured) {
        XdQuery xdQuery;
        Intrinsics.checkParameterIsNotNull(unsecured, (String)"unsecured");
        if (SecurityUtilKt.hasPermission$default("jetbrains.jetpass.service-read", null, 2, null)) {
            return unsecured;
        }
        XdAuthorityHolder xdPrincipal = SecurityUtilKt.getXdPrincipal(this.getHubPrincipalManager());
        XdAuthorityHolder xdAuthorityHolder = xdPrincipal;
        if (xdAuthorityHolder instanceof XdService) {
            xdQuery = XdQueryKt.intersect((XdQuery)((XdQuery)((XdService)xdPrincipal).getResources()), unsecured);
        } else if (xdAuthorityHolder instanceof XdBaseUser) {
            void $receiver$iv;
            XdQuery readableProjects;
            void $receiver$iv2;
            XdQuery initial$iv;
            Sequence sequence = XdQueryKt.asSequence((XdQuery)XdService.Companion.getServicesVisibleByUser((XdBaseUser)xdPrincipal));
            XdQuery accumulator$iv = initial$iv = XdQueryKt.emptyQuery((XdEntityType)((XdEntityType)XdResource.Companion));
            for (Object element$iv : $receiver$iv2) {
                void it;
                XdService xdService = (XdService)element$iv;
                XdQuery cur = accumulator$iv;
                accumulator$iv = XdQueryKt.union(cur, (XdQuery)((XdQuery)it.getResources()));
            }
            XdQuery resourcesOfReadableServices = accumulator$iv;
            accumulator$iv = readableProjects = this.projectSecurity.filter((XdQuery<? extends XdProject>)XdProject.Companion.all());
            KProperty1 field$iv = JetPassResourceSecurity$filter$resourcesOfReadableProjects$1.INSTANCE;
            XdQuery resourcesOfReadableProjects2 = XdQueryKt.flatMapDistinct((XdQuery)$receiver$iv, (String)ReflectionUtilKt.getDBName((KProperty1)field$iv, (XdEntityType)$receiver$iv.getEntityType()), (XdEntityType)ReflectionUtilKt.getEntityType((KClass)Reflection.getOrCreateKotlinClass(XdResource.class)));
            xdQuery = XdQueryKt.intersect((XdQuery)XdQueryKt.intersect(unsecured, (XdQuery)resourcesOfReadableServices), (XdQuery)resourcesOfReadableProjects2);
        } else {
            xdQuery = XdQueryKt.emptyQuery((XdEntityType)((XdEntityType)XdResource.Companion));
        }
        return xdQuery;
    }

    @Override
    @Nullable
    protected XdService getParentItem(@Nullable XdResource xdChild) {
        Object object = this.xdFixedService;
        if (object == null) {
            XdResource xdResource2 = xdChild;
            object = xdResource2 != null ? xdResource2.getService() : null;
        }
        return object;
    }

    @Nullable
    public final XdService getXdFixedService() {
        return this.xdFixedService;
    }

    public JetPassResourceSecurity(@Nullable XdService xdFixedService) {
        this.xdFixedService = xdFixedService;
        this.projectSecurity = new JetPassProjectSecurity();
        this.parentSecurity = new JetPassServiceSecurity();
    }

    public /* synthetic */ JetPassResourceSecurity(XdService xdService, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            xdService = null;
        }
        this(xdService);
    }

    public JetPassResourceSecurity() {
        this(null, 1, null);
    }
}

