/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.dao.dnq.api.security;

import jetbrains.jetpass.api.authority.AuthorityHolder;
import jetbrains.jetpass.api.authority.User;
import jetbrains.jetpass.core.lang.CollectionsExtKt;
import jetbrains.jetpass.dao.dnq.api.security.JetPassSecurity;
import jetbrains.jetpass.dao.dnq.api.security.SecurityUtilKt;
import jetbrains.jetpass.service.api.JetPassMainApp;
import jetbrains.jetpass.spring.SpringUtils;
import jetbrains.jetpass.userManagement.persistence.dnq.XdAuthorityHolder;
import jetbrains.jetpass.userManagement.persistence.dnq.XdBaseUser;
import jetbrains.jetpass.userManagement.persistence.dnq.XdRoots;
import jetbrains.jetpass.userManagement.persistence.dnq.XdService;
import jetbrains.jetpass.userManagement.persistence.dnq.XdUUIDObject;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0006\u0010\u0014\u001a\u00020\u0015J\u001a\u0010\u0016\u001a\u00020\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u00052\b\u0010\u0018\u001a\u0004\u0018\u00010\u0005J\u0012\u0010\u0019\u001a\u00020\u00152\b\u0010\u001a\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010\u001b\u001a\u00020\u00152\b\u0010\u001a\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001c\u001a\u00020\u0015H\u0016J\u0010\u0010\u001d\u001a\u00020\u00152\b\u0010\u001a\u001a\u0004\u0018\u00010\u0002J\u0010\u0010\u001e\u001a\u00020\u00152\b\u0010\u001a\u001a\u0004\u0018\u00010\u0002J\u0012\u0010\u001f\u001a\u00020\u00152\b\u0010\u001a\u001a\u0004\u0018\u00010\u0002H\u0016J\u001c\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020!H\u0016J\u0010\u0010#\u001a\u00020\u00152\b\u0010\u001a\u001a\u0004\u0018\u00010\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u001b\u0010\n\u001a\u00020\u000b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0010\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007R\u0014\u0010\u0012\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0007\u00a8\u0006$"}, d2={"Ljetbrains/jetpass/dao/dnq/api/security/JetPassServiceSecurity;", "Ljetbrains/jetpass/dao/dnq/api/security/JetPassSecurity;", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdService;", "()V", "createPermissionKey", "", "getCreatePermissionKey", "()Ljava/lang/String;", "deletePermissionKey", "getDeletePermissionKey", "jetPass", "Ljetbrains/jetpass/service/api/JetPassMainApp;", "getJetPass", "()Ljetbrains/jetpass/service/api/JetPassMainApp;", "jetPass$delegate", "Lkotlin/properties/ReadOnlyProperty;", "readPermissionKey", "getReadPermissionKey", "updatePermissionKey", "getUpdatePermissionKey", "byRoot", "", "canCreate", "serviceId", "serviceKey", "canDelete", "xd", "canRead", "full", "canReadByGroupVisibility", "canReadByPermission", "canUpdate", "filter", "Lkotlinx/dnq/query/XdQuery;", "unsecured", "isSelf", "jetbrains.jetpass.dao.dnq"})
public final class JetPassServiceSecurity
extends JetPassSecurity<XdService> {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private final ReadOnlyProperty jetPass$delegate;
    @NotNull
    private final String createPermissionKey = "jetbrains.jetpass.service-create";
    @NotNull
    private final String readPermissionKey = "jetbrains.jetpass.service-read";
    @NotNull
    private final String updatePermissionKey = "jetbrains.jetpass.service-update";
    @NotNull
    private final String deletePermissionKey = "jetbrains.jetpass.service-delete";

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(JetPassServiceSecurity.class), "jetPass", "getJetPass()Ljetbrains/jetpass/service/api/JetPassMainApp;"))};
    }

    @NotNull
    public final JetPassMainApp getJetPass() {
        return (JetPassMainApp)this.jetPass$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Override
    @NotNull
    public String getCreatePermissionKey() {
        return this.createPermissionKey;
    }

    @Override
    @NotNull
    public String getReadPermissionKey() {
        return this.readPermissionKey;
    }

    @Override
    @NotNull
    public String getUpdatePermissionKey() {
        return this.updatePermissionKey;
    }

    @Override
    @NotNull
    public String getDeletePermissionKey() {
        return this.deletePermissionKey;
    }

    public final boolean canCreate(@Nullable String serviceId, @Nullable String serviceKey) {
        AuthorityHolder principal = this.getHubPrincipalManager().getCurrentPrincipal();
        if (principal instanceof User) {
            if (CollectionsExtKt.contains((Iterable)this.getJetPass().getAprioryVerifiedServiceIds(), (Object)serviceId) || CollectionsExtKt.contains((Iterable)this.getJetPass().getAprioryVerifiedServiceIds(), (Object)serviceKey)) {
                return true;
            }
            Boolean bl = ((User)principal).isBanned();
            Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"principal.isBanned");
            if (bl.booleanValue()) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean canRead(@Nullable XdService xd, boolean full) {
        return this.canReadByPermission(xd) || !full && this.canReadByGroupVisibility(xd);
    }

    public final boolean canReadByPermission(@Nullable XdService xd) {
        return this.isSelf(xd) || SecurityUtilKt.hasPermission$default(this.getReadPermissionKey(), null, 2, null);
    }

    public final boolean canReadByGroupVisibility(@Nullable XdService xd) {
        if (xd == null) {
            return false;
        }
        return SecurityUtilKt.checkPermission((Function1<? super XdBaseUser, Boolean>)((Function1)new Function1<XdBaseUser, Boolean>(xd){
            final /* synthetic */ XdService $xd;

            public final boolean invoke(@NotNull XdBaseUser xdPrincipal) {
                Intrinsics.checkParameterIsNotNull((Object)xdPrincipal, (String)"xdPrincipal");
                return this.$xd.isVisibleForUser(xdPrincipal);
            }
            {
                this.$xd = xdService;
                super(1);
            }
        }));
    }

    @Override
    public boolean canUpdate(@Nullable XdService xd) {
        return this.isSelf(xd) || super.canUpdate((XdUUIDObject)xd);
    }

    @Override
    public boolean canDelete(@Nullable XdService xd) {
        return this.isSelf(xd) || super.canDelete((XdUUIDObject)xd);
    }

    @Override
    @NotNull
    public XdQuery<XdService> filter(@NotNull XdQuery<? extends XdService> unsecured) {
        XdAuthorityHolder xdPrincipal;
        XdAuthorityHolder xdAuthorityHolder;
        Intrinsics.checkParameterIsNotNull(unsecured, (String)"unsecured");
        XdQuery xdQuery = SecurityUtilKt.hasPermission$default(this.getReadPermissionKey(), null, 2, null) ? unsecured : ((xdAuthorityHolder = (xdPrincipal = SecurityUtilKt.getXdPrincipal(this.getHubPrincipalManager()))) instanceof XdService ? XdQueryKt.queryOf((XdEntityType)((XdEntityType)XdService.Companion), (XdEntity[])new XdService[]{(XdService)xdPrincipal}) : (xdAuthorityHolder instanceof XdBaseUser ? (!((XdBaseUser)xdPrincipal).getBanned() ? XdQueryKt.intersect((XdQuery)XdService.Companion.getServicesVisibleByUser((XdBaseUser)xdPrincipal), (XdQuery)unsecured) : XdQueryKt.emptyQuery((XdEntityType)((XdEntityType)XdService.Companion))) : XdQueryKt.emptyQuery((XdEntityType)((XdEntityType)XdService.Companion))));
        return xdQuery;
    }

    public final boolean isSelf(@Nullable XdService xd) {
        return xd != null && Intrinsics.areEqual((Object)xd, (Object)SecurityUtilKt.getXdPrincipal(this.getHubPrincipalManager()));
    }

    public final boolean byRoot() {
        return Intrinsics.areEqual((Object)SecurityUtilKt.getXdPrincipal(this.getHubPrincipalManager()), (Object)XdRoots.INSTANCE.getRootService());
    }

    public JetPassServiceSecurity() {
        ReadOnlyProperty readOnlyProperty;
        JetPassServiceSecurity jetPassServiceSecurity = this;
        String name$iv = null;
        jetPassServiceSecurity.jetPass$delegate = readOnlyProperty = SpringUtils.bean((String)name$iv, (boolean)false);
        this.createPermissionKey = "jetbrains.jetpass.service-create";
        this.readPermissionKey = "jetbrains.jetpass.service-read";
        this.updatePermissionKey = "jetbrains.jetpass.service-update";
        this.deletePermissionKey = "jetbrains.jetpass.service-delete";
    }
}

