/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.dao.dnq.api.security;

import java.util.List;
import java.util.Set;
import jetbrains.exodus.entitystore.EntityIterable;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.query.QueryEngine;
import jetbrains.jetpass.core.lang.CollectionsExtKt;
import jetbrains.jetpass.dao.api.permissionCache.PermissionQuery;
import jetbrains.jetpass.dao.dnq.api.security.JetPassSecurity;
import jetbrains.jetpass.dao.dnq.api.security.JetPassUserGroupSecurity;
import jetbrains.jetpass.dao.dnq.api.security.SecurityUtilKt;
import jetbrains.jetpass.userManagement.persistence.dnq.XdBaseUser;
import jetbrains.jetpass.userManagement.persistence.dnq.XdBaseUserGroup;
import jetbrains.jetpass.userManagement.persistence.dnq.XdProject;
import jetbrains.jetpass.userManagement.persistence.dnq.XdResource;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u001a\u0010\u0012\u001a\u00020\u000f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0014\u001a\u00020\u000fH\u0016J\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u0016H\u0016J\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u0002H\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0014\u0010\f\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007\u00a8\u0006\u0019"}, d2={"Ljetbrains/jetpass/dao/dnq/api/security/JetPassUserGroupSecurity;", "Ljetbrains/jetpass/dao/dnq/api/security/JetPassSecurity;", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdBaseUserGroup;", "()V", "createPermissionKey", "", "getCreatePermissionKey", "()Ljava/lang/String;", "deletePermissionKey", "getDeletePermissionKey", "readPermissionKey", "getReadPermissionKey", "updatePermissionKey", "getUpdatePermissionKey", "canCreate", "", "inProject", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdProject;", "canRead", "xd", "full", "filter", "Lkotlinx/dnq/query/XdQuery;", "unsecured", "getProjectFor", "jetbrains.jetpass.dao.dnq"})
public final class JetPassUserGroupSecurity
extends JetPassSecurity<XdBaseUserGroup> {
    @NotNull
    private final String createPermissionKey = "jetbrains.jetpass.group-create";
    @NotNull
    private final String readPermissionKey = "jetbrains.jetpass.group-read";
    @NotNull
    private final String updatePermissionKey = "jetbrains.jetpass.group-update";
    @NotNull
    private final String deletePermissionKey = "jetbrains.jetpass.group-delete";

    @Override
    @NotNull
    public String getCreatePermissionKey() {
        return this.createPermissionKey;
    }

    @Override
    @NotNull
    public String getReadPermissionKey() {
        return this.readPermissionKey;
    }

    @Override
    @NotNull
    public String getUpdatePermissionKey() {
        return this.updatePermissionKey;
    }

    @Override
    @NotNull
    public String getDeletePermissionKey() {
        return this.deletePermissionKey;
    }

    @Override
    public boolean canRead(@Nullable XdBaseUserGroup xd, boolean full) {
        return xd == null ? false : SecurityUtilKt.hasPermission(this.getReadPermissionKey(), xd.getProject());
    }

    public final boolean canCreate(@Nullable XdProject inProject) {
        return SecurityUtilKt.hasPermission(this.getCreatePermissionKey(), inProject);
    }

    @Override
    @NotNull
    public XdQuery<XdBaseUserGroup> filter(@NotNull XdQuery<? extends XdBaseUserGroup> unsecured) {
        Intrinsics.checkParameterIsNotNull(unsecured, (String)"unsecured");
        return SecurityUtilKt.checkPermission(unsecured, (Function1)new Function1<XdBaseUser, XdQuery<? extends XdBaseUserGroup>>(this, unsecured){
            final /* synthetic */ JetPassUserGroupSecurity this$0;
            final /* synthetic */ XdQuery $unsecured;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final XdQuery<XdBaseUserGroup> invoke(@NotNull XdBaseUser xdPrincipal) {
                XdQuery xdQuery;
                Intrinsics.checkParameterIsNotNull((Object)xdPrincipal, (String)"xdPrincipal");
                PermissionQuery permissionQuery = this.this$0.getDaoContainer().getJetPassUserDAO().getPermissionQuery(xdPrincipal.getUuid());
                String string = SecurityUtilKt.resolvePermission(this.this$0.getReadPermissionKey()).getId();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"resolvePermission(readPermissionKey).id");
                PermissionQuery fullPQ = permissionQuery.withPermission(string);
                if (fullPQ.canAccessGlobal()) {
                    xdQuery = this.$unsecured;
                } else {
                    Iterable groupsIterable;
                    Set accessibleProjects = fullPQ.getAccessibleProjectsUnordered();
                    QueryEngine queryEngine = XdBaseUserGroup.Companion.getEntityStore().getQueryEngine();
                    if (queryEngine.isPersistentIterable(groupsIterable = queryEngine.toEntityIterable(this.$unsecured.getEntityIterable()))) {
                        void $receiver$iv;
                        XdQuery initial$iv;
                        Sequence sequence = CollectionsExtKt.chunked((Sequence)SequencesKt.filter((Sequence)XdQueryKt.asSequence((XdQuery)XdProject.Companion.all()), (Function1)((Function1)new Function1<XdProject, Boolean>(accessibleProjects){
                            final /* synthetic */ Set $accessibleProjects;

                            public final boolean invoke(@NotNull XdProject it) {
                                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                                return this.$accessibleProjects.contains(it.getUuid());
                            }
                            {
                                this.$accessibleProjects = set;
                                super(1);
                            }
                        })), (int)100);
                        XdQuery accumulator$iv = initial$iv = XdQueryKt.emptyQuery((XdEntityType)((XdEntityType)XdResource.Companion));
                        for (E element$iv : $receiver$iv) {
                            void $receiver$iv2;
                            void initial$iv2;
                            void projectsChunk;
                            List list = (List)element$iv;
                            XdQuery resources = accumulator$iv;
                            Iterable iterable = (Iterable)projectsChunk;
                            XdQuery xdQuery2 = XdQueryKt.emptyQuery((XdEntityType)((XdEntityType)XdResource.Companion));
                            XdQuery xdQuery3 = resources;
                            XdQuery accumulator$iv2 = initial$iv2;
                            for (T element$iv2 : $receiver$iv2) {
                                void p;
                                XdProject xdProject = (XdProject)element$iv2;
                                void sum = accumulator$iv2;
                                accumulator$iv2 = XdQueryKt.union((XdQuery)sum, (XdQuery)((XdQuery)p.getResources()));
                            }
                            void var22_21 = accumulator$iv2;
                            accumulator$iv = XdQueryKt.union((XdQuery)xdQuery3, (XdQuery)var22_21);
                        }
                        XdQuery accessibleResources2 = accumulator$iv;
                        Iterable iterable = queryEngine.toEntityIterable(accessibleResources2.getEntityIterable());
                        if (iterable == null) {
                            throw new TypeCastException("null cannot be cast to non-null type jetbrains.exodus.entitystore.iterate.EntityIterableBase");
                        }
                        EntityIterableBase resourceIterable = ((EntityIterableBase)iterable).getSource();
                        Iterable iterable2 = groupsIterable;
                        if (iterable2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type jetbrains.exodus.entitystore.iterate.EntityIterableBase");
                        }
                        EntityIterable groupsWithResourcesIterable = ((EntityIterableBase)iterable2).getSource().findLinks((EntityIterable)resourceIterable, "resource");
                        xdQuery = XdQueryKt.asQuery((Iterable)queryEngine.adjustEntityIterable((Iterable)groupsWithResourcesIterable), (XdEntityType)((XdEntityType)XdBaseUserGroup.Companion));
                    } else {
                        JetPassSecurity.Companion.getLogger().warn((Throwable)new Exception(), (Function0)filter.1.INSTANCE);
                        xdQuery = XdQueryKt.asQuery((Iterable)SequencesKt.asIterable((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)XdQueryKt.asSequence((XdQuery)this.$unsecured), (Function1)((Function1)new Function1<XdBaseUserGroup, Boolean>(accessibleProjects){
                            final /* synthetic */ Set $accessibleProjects;

                            public final boolean invoke(@NotNull XdBaseUserGroup it) {
                                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                                return this.$accessibleProjects.contains(it.getProject().getUuid());
                            }
                            {
                                this.$accessibleProjects = set;
                                super(1);
                            }
                        })), (Function1)filter.3.INSTANCE)), (XdEntityType)((XdEntityType)XdBaseUserGroup.Companion));
                    }
                }
                return xdQuery;
            }
            {
                this.this$0 = jetPassUserGroupSecurity;
                this.$unsecured = xdQuery;
                super(1);
            }
        });
    }

    @Override
    @Nullable
    protected XdProject getProjectFor(@Nullable XdBaseUserGroup xd) {
        XdBaseUserGroup xdBaseUserGroup = xd;
        return xdBaseUserGroup != null ? xdBaseUserGroup.getProject() : null;
    }
}

