/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.dao.dnq.api.security;

import jetbrains.jetpass.api.authority.AuthorityHolder;
import jetbrains.jetpass.api.security.Permission;
import jetbrains.jetpass.api.security.Project;
import jetbrains.jetpass.dao.api.permissionCache.PermissionQuery;
import jetbrains.jetpass.dao.dnq.api.JetPassDAOContainer;
import jetbrains.jetpass.dao.dnq.api.JetPassReadonlyDAOUtilKt;
import jetbrains.jetpass.dao.dnq.api.security.JetPassSecurity;
import jetbrains.jetpass.dao.dnq.api.security.SecurityUtilKt;
import jetbrains.jetpass.service.api.HubPrincipalManager;
import jetbrains.jetpass.spring.SpringUtils;
import jetbrains.jetpass.userManagement.persistence.dnq.XdAuthorityHolder;
import jetbrains.jetpass.userManagement.persistence.dnq.XdBaseUser;
import jetbrains.jetpass.userManagement.persistence.dnq.XdProject;
import jetbrains.jetpass.userManagement.persistence.dnq.XdService;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u0000R\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a)\u0010\u000f\u001a\u00020\u00102!\u0010\u0011\u001a\u001d\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\u00100\u0012\u001aD\u0010\u000f\u001a\u0002H\u0016\"\u0004\b\u0000\u0010\u00162\u0006\u0010\u0017\u001a\u0002H\u00162\u0006\u0010\u0018\u001a\u0002H\u00162!\u0010\u0011\u001a\u001d\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u0002H\u00160\u0012\u00a2\u0006\u0002\u0010\u0019\u001aM\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001a\"\b\b\u0000\u0010\u001b*\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001a2'\u0010\u0011\u001a#\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001b0\u001a0\u0012\u001a\u001a\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 2\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\"\u001a\u000e\u0010#\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 \u001a\u000e\u0010$\u001a\u00020%2\u0006\u0010\u001f\u001a\u00020 \"\u001b\u0010\u0000\u001a\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0002\u0010\u0003\"\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u0005\u001a\u0004\b\b\u0010\t\"\u0017\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006&"}, d2={"daoContainer", "Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;", "getDaoContainer", "()Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;", "daoContainer$delegate", "Lkotlin/properties/ReadOnlyProperty;", "hubPrincipalManager", "Ljetbrains/jetpass/service/api/HubPrincipalManager;", "getHubPrincipalManager", "()Ljetbrains/jetpass/service/api/HubPrincipalManager;", "hubPrincipalManager$delegate", "xdPrincipal", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdAuthorityHolder;", "getXdPrincipal", "(Ljetbrains/jetpass/service/api/HubPrincipalManager;)Ljetbrains/jetpass/userManagement/persistence/dnq/XdAuthorityHolder;", "checkPermission", "", "body", "Lkotlin/Function1;", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdBaseUser;", "Lkotlin/ParameterName;", "name", "T", "falseValue", "trueValue", "(Ljava/lang/Object;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Lkotlinx/dnq/query/XdQuery;", "XD", "Lkotlinx/dnq/XdEntity;", "unsecured", "hasPermission", "permissionKey", "", "xdProject", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdProject;", "hasPermissionInSomeProject", "resolvePermission", "Ljetbrains/jetpass/api/security/Permission;", "jetbrains.jetpass.dao.dnq"})
public final class SecurityUtilKt {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private static final ReadOnlyProperty daoContainer$delegate;
    private static final ReadOnlyProperty hubPrincipalManager$delegate;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property0((PropertyReference0)new PropertyReference0Impl(Reflection.getOrCreateKotlinPackage(SecurityUtilKt.class, (String)"jetbrains.jetpass.dao.dnq"), "daoContainer", "getDaoContainer()Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;")), (KProperty)Reflection.property0((PropertyReference0)new PropertyReference0Impl(Reflection.getOrCreateKotlinPackage(SecurityUtilKt.class, (String)"jetbrains.jetpass.dao.dnq"), "hubPrincipalManager", "getHubPrincipalManager()Ljetbrains/jetpass/service/api/HubPrincipalManager;"))};
        String name$iv = null;
        daoContainer$delegate = SpringUtils.bean((String)name$iv, (boolean)false);
        name$iv = null;
        hubPrincipalManager$delegate = SpringUtils.bean((String)name$iv, (boolean)false);
    }

    private static final JetPassDAOContainer getDaoContainer() {
        return (JetPassDAOContainer)daoContainer$delegate.getValue(null, $$delegatedProperties[0]);
    }

    private static final HubPrincipalManager getHubPrincipalManager() {
        return (HubPrincipalManager)hubPrincipalManager$delegate.getValue(null, $$delegatedProperties[1]);
    }

    @Nullable
    public static final XdAuthorityHolder getXdPrincipal(@NotNull HubPrincipalManager $receiver) {
        XdAuthorityHolder xdAuthorityHolder;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        AuthorityHolder authorityHolder = $receiver.getCurrentPrincipal();
        if (authorityHolder != null) {
            AuthorityHolder authorityHolder2;
            AuthorityHolder it = authorityHolder2 = authorityHolder;
            xdAuthorityHolder = SecurityUtilKt.getDaoContainer().authHolderFromAPI(it);
        } else {
            xdAuthorityHolder = null;
        }
        return xdAuthorityHolder;
    }

    @NotNull
    public static final Permission resolvePermission(@NotNull String permissionKey2) {
        Intrinsics.checkParameterIsNotNull((Object)permissionKey2, (String)"permissionKey");
        return SecurityUtilKt.getDaoContainer().getJetPassPermissionDAO().resolveHubPermission(permissionKey2);
    }

    public static final <T> T checkPermission(T falseValue, T trueValue, @NotNull Function1<? super XdBaseUser, ? extends T> body) {
        Intrinsics.checkParameterIsNotNull(body, (String)"body");
        XdAuthorityHolder xdPrincipal = SecurityUtilKt.getXdPrincipal(SecurityUtilKt.getHubPrincipalManager());
        if (xdPrincipal == null) {
            JetPassSecurity.Companion.getLogger().error((Throwable)new Exception(), (Function0)checkPermission.1.INSTANCE);
            return falseValue;
        }
        if (xdPrincipal instanceof XdService) {
            return ((XdService)xdPrincipal).getTrusted() ? trueValue : falseValue;
        }
        if (!(xdPrincipal instanceof XdBaseUser)) {
            return falseValue;
        }
        if (((XdBaseUser)xdPrincipal).getBanned()) {
            return falseValue;
        }
        return (T)body.invoke((Object)xdPrincipal);
    }

    public static final boolean checkPermission(@NotNull Function1<? super XdBaseUser, Boolean> body) {
        Intrinsics.checkParameterIsNotNull(body, (String)"body");
        return SecurityUtilKt.checkPermission(false, true, body);
    }

    @NotNull
    public static final <XD extends XdEntity> XdQuery<XD> checkPermission(@NotNull XdQuery<? extends XD> unsecured, @NotNull Function1<? super XdBaseUser, ? extends XdQuery<? extends XD>> body) {
        Intrinsics.checkParameterIsNotNull(unsecured, (String)"unsecured");
        Intrinsics.checkParameterIsNotNull(body, (String)"body");
        return SecurityUtilKt.checkPermission(XdQueryKt.emptyQuery((XdEntityType)unsecured.getEntityType()), unsecured, body);
    }

    public static final boolean hasPermission(@NotNull String permissionKey2, @Nullable XdProject xdProject) {
        Intrinsics.checkParameterIsNotNull((Object)permissionKey2, (String)"permissionKey");
        return SecurityUtilKt.checkPermission((Function1<? super XdBaseUser, Boolean>)((Function1)new Function1<XdBaseUser, Boolean>(permissionKey2, xdProject){
            final /* synthetic */ String $permissionKey;
            final /* synthetic */ XdProject $xdProject;

            public final boolean invoke(@NotNull XdBaseUser xdPrincipal) {
                Intrinsics.checkParameterIsNotNull((Object)xdPrincipal, (String)"xdPrincipal");
                XdProject xdProject = this.$xdProject;
                return SecurityUtilKt.access$getDaoContainer$p().getJetPassUserDAO().hasPermission(xdPrincipal.getUuid(), SecurityUtilKt.resolvePermission(this.$permissionKey), xdProject != null ? (Project)JetPassReadonlyDAOUtilKt.wrap((XdEntity)xdProject, SecurityUtilKt.access$getDaoContainer$p().getJetPassProjectDAO()) : null);
            }
            {
                this.$permissionKey = string;
                this.$xdProject = xdProject;
                super(1);
            }
        }));
    }

    public static /* bridge */ /* synthetic */ boolean hasPermission$default(String string, XdProject xdProject, int n, Object object) {
        if ((n & 2) != 0) {
            xdProject = null;
        }
        return SecurityUtilKt.hasPermission(string, xdProject);
    }

    public static final boolean hasPermissionInSomeProject(@NotNull String permissionKey2) {
        Intrinsics.checkParameterIsNotNull((Object)permissionKey2, (String)"permissionKey");
        return SecurityUtilKt.checkPermission((Function1<? super XdBaseUser, Boolean>)((Function1)new Function1<XdBaseUser, Boolean>(permissionKey2){
            final /* synthetic */ String $permissionKey;

            public final boolean invoke(@NotNull XdBaseUser xdPrincipal) {
                Intrinsics.checkParameterIsNotNull((Object)xdPrincipal, (String)"xdPrincipal");
                PermissionQuery permissionQuery = SecurityUtilKt.access$getDaoContainer$p().getJetPassUserDAO().getPermissionQuery(xdPrincipal.getUuid());
                String string = SecurityUtilKt.resolvePermission(this.$permissionKey).getId();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"resolvePermission(permissionKey).id");
                return permissionQuery.withPermission(string).canAccess();
            }
            {
                this.$permissionKey = string;
                super(1);
            }
        }));
    }

    @NotNull
    public static final /* synthetic */ JetPassDAOContainer access$getDaoContainer$p() {
        return SecurityUtilKt.getDaoContainer();
    }
}

