/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.dao.dnq.api.widget;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import jetbrains.jetpass.dao.dnq.api.widget.TempWidgetArchiveVault;
import jetbrains.jetpass.dao.dnq.api.widget.WidgetArchive;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000E\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ;\u0010\u0007\u001a\u0002H\u000e\"\u0004\b\u0000\u0010\u000e2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0018\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u0002H\u000e0\u0013\u00a2\u0006\u0002\u0010\u0014J\f\u0010\u0015\u001a\u00020\u0016*\u00020\u0017H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\u0018"}, d2={"Ljetbrains/jetpass/dao/dnq/api/widget/TempWidgetArchiveVault;", "Lmu/KLogging;", "()V", "MAX_TEMP_ARCHIVE_FILES", "", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "store", "jetbrains/jetpass/dao/dnq/api/widget/TempWidgetArchiveVault$store$1", "Ljetbrains/jetpass/dao/dnq/api/widget/TempWidgetArchiveVault$store$1;", "loadArchive", "Ljetbrains/jetpass/dao/dnq/api/widget/WidgetArchive;", "archiveId", "", "T", "prefix", "archive", "Ljava/io/InputStream;", "beforeStore", "Lkotlin/Function2;", "(Ljava/lang/String;Ljava/io/InputStream;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "deleteSafe", "", "Ljava/io/File;", "jetbrains.jetpass.dao.dnq"})
public final class TempWidgetArchiveVault
extends KLogging {
    private static final int MAX_TEMP_ARCHIVE_FILES = 32;
    private static final ReentrantReadWriteLock lock;
    private static final store.1 store;
    public static final TempWidgetArchiveVault INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T store(@NotNull String prefix, @NotNull InputStream archive, @NotNull Function2<? super String, ? super WidgetArchive, ? extends T> beforeStore) {
        int n;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        Intrinsics.checkParameterIsNotNull((Object)archive, (String)"archive");
        Intrinsics.checkParameterIsNotNull(beforeStore, (String)"beforeStore");
        String archiveId = UUID.randomUUID().toString();
        File file = new File(System.getProperty("java.io.tmpdir"), prefix + '-' + archiveId + ".zip");
        try {
            file.deleteOnExit();
            WidgetArchive widgetArchive2 = WidgetArchive.Companion.save(file, archive);
            widgetArchive2.validate();
            String string = archiveId;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"archiveId");
            object = beforeStore.invoke((Object)string, (Object)widgetArchive2);
        }
        catch (Throwable e) {
            this.deleteSafe(file);
            throw e;
        }
        Object result = object;
        object = lock;
        ReentrantReadWriteLock.ReadLock readLock = ((ReentrantReadWriteLock)object).readLock();
        int n2 = ((ReentrantReadWriteLock)object).getWriteHoldCount() == 0 ? ((ReentrantReadWriteLock)object).getReadHoldCount() : 0;
        int n3 = 0;
        int n4 = n2;
        while (n3 < n4) {
            n = n3++;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = ((ReentrantReadWriteLock)object).writeLock();
        writeLock.lock();
        try {
            Map map = store;
            String string = archiveId;
            File file2 = file;
            map.put(string, file2);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            n = 0;
            int n5 = n2;
            while (n < n5) {
                int n6 = n++;
                readLock.lock();
            }
            writeLock.unlock();
        }
        return (T)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final WidgetArchive loadArchive(@NotNull String archiveId) {
        Intrinsics.checkParameterIsNotNull((Object)archiveId, (String)"archiveId");
        loadArchive.1 throwFileIsUnresolved$ = loadArchive.1.INSTANCE;
        ReentrantReadWriteLock reentrantReadWriteLock = lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            WidgetArchive widgetArchive2;
            File file = (File)store.get((Object)archiveId);
            if (file == null) {
                Object object = loadArchive.1.INSTANCE.invoke();
                throw null;
            }
            File file2 = file;
            try {
                widgetArchive2 = new WidgetArchive((Function0<? extends InputStream>)((Function0)new Function0<BufferedInputStream>(file2){
                    final /* synthetic */ File $file;

                    @NotNull
                    public final BufferedInputStream invoke() {
                        File file = this.$file;
                        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"file");
                        Object object = file;
                        object = new FileInputStream((File)object);
                        int n = 8192;
                        return object instanceof BufferedInputStream ? (BufferedInputStream)object : new BufferedInputStream((InputStream)object, n);
                    }
                    {
                        this.$file = file;
                        super(0);
                    }
                }));
            }
            catch (FileNotFoundException e) {
                Object object = loadArchive.1.INSTANCE.invoke();
                throw null;
            }
            WidgetArchive widgetArchive3 = widgetArchive2;
            return widgetArchive3;
        }
        finally {
            readLock.unlock();
        }
    }

    private final Object deleteSafe(@NotNull File $receiver) {
        Boolean bl;
        try {
            bl = $receiver.delete();
        }
        catch (Throwable ex) {
            this.getLogger().warn((Function0)new Function0<String>($receiver){
                final /* synthetic */ File receiver$0;

                @NotNull
                public final String invoke() {
                    return "Can't delete temp widget file " + this.receiver$0.getAbsolutePath() + ". The next try is done on VM exit.";
                }
                {
                    this.receiver$0 = file;
                    super(0);
                }
            });
            bl = Unit.INSTANCE;
        }
        return bl;
    }

    private TempWidgetArchiveVault() {
    }

    static {
        TempWidgetArchiveVault tempWidgetArchiveVault;
        INSTANCE = tempWidgetArchiveVault = new TempWidgetArchiveVault();
        lock = new ReentrantReadWriteLock();
        store = new LinkedHashMap<String, File>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected boolean removeEldestEntry(@NotNull Map.Entry<String, File> eldest) {
                boolean bl;
                Intrinsics.checkParameterIsNotNull(eldest, (String)"eldest");
                if (this.size() > 32) {
                    int n;
                    ReentrantReadWriteLock reentrantReadWriteLock = TempWidgetArchiveVault.access$getLock$p(TempWidgetArchiveVault.INSTANCE);
                    ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
                    int n2 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
                    int n3 = 0;
                    int n4 = n2;
                    while (n3 < n4) {
                        n = n3++;
                        readLock.unlock();
                    }
                    ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
                    writeLock.lock();
                    try {
                        Object object = TempWidgetArchiveVault.access$deleteSafe(TempWidgetArchiveVault.INSTANCE, eldest.getValue());
                    }
                    finally {
                        n = 0;
                        int n5 = n2;
                        while (n < n5) {
                            int n6 = n++;
                            readLock.lock();
                        }
                        writeLock.unlock();
                    }
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }
        };
    }

    @NotNull
    public static final /* synthetic */ ReentrantReadWriteLock access$getLock$p(TempWidgetArchiveVault $this) {
        TempWidgetArchiveVault tempWidgetArchiveVault = $this;
        return lock;
    }

    @NotNull
    public static final /* synthetic */ Object access$deleteSafe(TempWidgetArchiveVault $this, @NotNull File $receiver) {
        return $this.deleteSafe($receiver);
    }
}

