/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.dao.dnq.api.widget;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import jetbrains.jetpass.core.io.SizeLimitingInputStreamKt;
import jetbrains.jetpass.core.io.SizeLimitingReaderKt;
import jetbrains.jetpass.dao.api.widget.WidgetException;
import jetbrains.jetpass.dao.dnq.api.widget.WidgetArchive;
import jetbrains.jetpass.dao.dnq.api.widget.WidgetManifest;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\rJ\u0006\u0010\u0014\u001a\u00020\u0011J\u0014\u0010\u0015\u001a\u00020\t*\u00020\t2\u0006\u0010\u0016\u001a\u00020\rH\u0002J\u000e\u0010\u0017\u001a\u0004\u0018\u00010\r*\u00020\rH\u0002R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Ljetbrains/jetpass/dao/dnq/api/widget/WidgetArchive;", "", "getArchive", "Lkotlin/Function0;", "Ljava/io/InputStream;", "(Lkotlin/jvm/functions/Function0;)V", "getGetArchive", "()Lkotlin/jvm/functions/Function0;", "manifest", "Ljetbrains/jetpass/dao/dnq/api/widget/WidgetManifest;", "getManifest", "()Ljetbrains/jetpass/dao/dnq/api/widget/WidgetManifest;", "rootDirectory", "", "getRootDirectory", "()Ljava/lang/String;", "assertHasIndexHtml", "", "getFile", "pathInArchive", "validate", "checkFields", "fileName", "normalizePath", "Companion", "jetbrains.jetpass.dao.dnq"})
public final class WidgetArchive {
    @NotNull
    private final Function0<InputStream> getArchive;
    private static long MAX_ARCHIVE_FILE_SIZE;
    private static int MAX_ARCHIVE_FILE_NUMBER;
    private static long MAX_UNCOMPRESSED_FILE_SIZE;
    private static final String MANIFEST_FILENAME = "manifest.json";
    private static final String INDEX_HTML_FILENAME = "index.html";
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final WidgetManifest getManifest() {
        Object object;
        try {
            object = this.getFile(MANIFEST_FILENAME);
            Throwable throwable = null;
            try {
                Object it = (InputStream)object;
                InputStream inputStream = it;
                Charset charset = Charsets.UTF_8;
                it = TextStreamsKt.readText((Reader)new InputStreamReader(inputStream, charset));
            }
            catch (Throwable it) {
                throwable = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = it;
        }
        catch (WidgetException e) {
            WidgetException widgetException;
            try {
                WidgetException widgetException2;
                String rootDirectory2 = this.getRootDirectory();
                this.getFile(rootDirectory2 + MANIFEST_FILENAME).close();
                WidgetException $receiver = widgetException2 = WidgetException.manifestNotAtRoot((String)rootDirectory2);
                $receiver.addSuppressed((Throwable)e);
                WidgetException widgetException3 = widgetException2;
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)widgetException3), (String)"WidgetException.manifest\u2026pply { addSuppressed(e) }");
                widgetException = widgetException3;
            }
            catch (Throwable e2) {
                WidgetException widgetException4;
                WidgetException $receiver = widgetException4 = e;
                $receiver.addSuppressed(e2);
                widgetException = widgetException4;
            }
            throw (Throwable)widgetException;
        }
        Object manifest = object;
        return this.checkFields(WidgetManifest.Companion.parse((String)manifest), MANIFEST_FILENAME);
    }

    public final void assertHasIndexHtml() {
        this.getFile(INDEX_HTML_FILENAME).close();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final InputStream getFile(@NotNull String pathInArchive) {
        Intrinsics.checkParameterIsNotNull((Object)pathInArchive, (String)"pathInArchive");
        String string = this.normalizePath(pathInArchive);
        if (string == null) {
            WidgetException widgetException = WidgetException.fileNotFound((String)pathInArchive);
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)widgetException), (String)"WidgetException.fileNotFound(pathInArchive)");
            throw (Throwable)widgetException;
        }
        String normalizedFilePath = string;
        ZipInputStream zip = new ZipInputStream((InputStream)this.getArchive.invoke());
        try {
            Object v3;
            block7: {
                void $receiver$iv;
                Sequence sequence = SequencesKt.filterNot((Sequence)SequencesKt.generateSequence((Function0)((Function0)new Function0<ZipEntry>(zip){
                    final /* synthetic */ ZipInputStream $zip;

                    public final ZipEntry invoke() {
                        return this.$zip.getNextEntry();
                    }
                    {
                        this.$zip = zipInputStream;
                        super(0);
                    }
                })), (Function1)getFile.entry.2.INSTANCE);
                for (Object element$iv : $receiver$iv) {
                    ZipEntry it = (ZipEntry)element$iv;
                    String string2 = it.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it.name");
                    if (!Intrinsics.areEqual((Object)this.normalizePath(string2), (Object)normalizedFilePath)) continue;
                    v3 = element$iv;
                    break block7;
                }
                v3 = null;
            }
            ZipEntry zipEntry = v3;
            if (zipEntry == null) {
                WidgetException widgetException = WidgetException.fileNotFound((String)pathInArchive);
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)widgetException), (String)"WidgetException.fileNotFound(pathInArchive)");
                throw (Throwable)widgetException;
            }
            ZipEntry entry2 = zipEntry;
            if (entry2.getSize() > MAX_UNCOMPRESSED_FILE_SIZE) {
                WidgetException widgetException = WidgetException.archiveContentSizeExceeded((String)pathInArchive, (Long)MAX_UNCOMPRESSED_FILE_SIZE);
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)widgetException), (String)"WidgetException.archiveC\u2026X_UNCOMPRESSED_FILE_SIZE)");
                throw (Throwable)widgetException;
            }
            return zip;
        }
        catch (WidgetException e) {
            zip.close();
            throw (Throwable)e;
        }
        catch (Throwable e) {
            zip.closeEntry();
            WidgetException widgetException = WidgetException.archiveIsMalformed((Throwable)e);
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)widgetException), (String)"WidgetException.archiveIsMalformed(e)");
            throw (Throwable)widgetException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void validate() {
        Closeable closeable = (Closeable)this.getArchive.invoke();
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            Closeable closeable2 = new ZipInputStream(WidgetArchive.Companion.withSizeLimit(it, WidgetArchive.MAX_ARCHIVE_FILE_SIZE));
            Throwable throwable2 = null;
            try {
                ZipInputStream zip = (ZipInputStream)closeable2;
                Sequence $receiver$iv = SequencesKt.generateSequence((Function0)((Function0)new Function0<ZipEntry>(zip){
                    final /* synthetic */ ZipInputStream $zip;

                    public final ZipEntry invoke() {
                        return this.$zip.getNextEntry();
                    }
                    {
                        this.$zip = zipInputStream;
                        super(0);
                    }
                }));
                int index$iv = 0;
                for (Object item$iv : $receiver$iv) {
                    void entry2;
                    int n;
                    if ((n = index$iv++) < 0) {
                        throw (Throwable)new ArithmeticException("Index overflow has happened.");
                    }
                    int n2 = n;
                    ZipEntry zipEntry = (ZipEntry)item$iv;
                    int fileIndex = n2;
                    if (fileIndex >= MAX_ARCHIVE_FILE_NUMBER) {
                        WidgetException widgetException = WidgetException.archiveFileNumberExceeded((Integer)MAX_ARCHIVE_FILE_NUMBER);
                        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)widgetException), (String)"WidgetException.archiveF\u2026(MAX_ARCHIVE_FILE_NUMBER)");
                        throw (Throwable)widgetException;
                    }
                    if (entry2.isDirectory()) continue;
                    String fileName = entry2.getName();
                    InputStream inputStream = zip;
                    Companion companion = Companion;
                    Charset charset = Charsets.UTF_8;
                    InputStreamReader inputStreamReader = new InputStreamReader(inputStream, charset);
                    Reader reader = inputStreamReader;
                    String string = fileName;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fileName");
                    TextStreamsKt.readText((Reader)companion.withSizeLimit(reader, string, WidgetArchive.MAX_UNCOMPRESSED_FILE_SIZE));
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final WidgetManifest checkFields(@NotNull WidgetManifest $receiver, String fileName) {
        boolean bl;
        block11: {
            if ($receiver.getKey() == null) {
                WidgetException widgetException = WidgetException.emptyMetadataFieldException((String)fileName, (String)"key");
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)widgetException), (String)"WidgetException.emptyMet\u2026WidgetManifest::key.name)");
                throw (Throwable)widgetException;
            }
            if ($receiver.getVersion() == null) {
                WidgetException widgetException = WidgetException.emptyMetadataFieldException((String)fileName, (String)"version");
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)widgetException), (String)"WidgetException.emptyMet\u2026etManifest::version.name)");
                throw (Throwable)widgetException;
            }
            if ($receiver.getName() == null) {
                WidgetException widgetException = WidgetException.emptyMetadataFieldException((String)fileName, (String)"name");
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)widgetException), (String)"WidgetException.emptyMet\u2026idgetManifest::name.name)");
                throw (Throwable)widgetException;
            }
            if ($receiver.getDescription() == null) {
                WidgetException widgetException = WidgetException.emptyMetadataFieldException((String)fileName, (String)"description");
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)widgetException), (String)"WidgetException.emptyMet\u2026nifest::description.name)");
                throw (Throwable)widgetException;
            }
            if ($receiver.getAuthor() == null) {
                WidgetException widgetException = WidgetException.emptyMetadataFieldException((String)fileName, (String)"author");
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)widgetException), (String)"WidgetException.emptyMet\u2026getManifest::author.name)");
                throw (Throwable)widgetException;
            }
            Map map = $receiver.getCapabilities();
            Map map2 = map;
            if (map2 == null) {
                map2 = MapsKt.emptyMap();
            }
            Map $receiver$iv = map2;
            if ($receiver$iv.isEmpty()) {
                bl = false;
            } else {
                Map map3 = $receiver$iv;
                for (Map.Entry element$iv : map3.entrySet()) {
                    Map.Entry $$_$_enabled = element$iv;
                    Map.Entry entry2 = $$_$_enabled;
                    Object enabled = entry2.getValue();
                    if (!(!(enabled instanceof Boolean))) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
        }
        if (bl) {
            WidgetException widgetException = WidgetException.capabilitiesWrongFormat();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)widgetException), (String)"WidgetException.capabilitiesWrongFormat()");
            throw (Throwable)widgetException;
        }
        if ($receiver.getProducts() == null || $receiver.getProducts().isEmpty()) {
            WidgetException widgetException = WidgetException.emptyMetadataFieldException((String)fileName, (String)"products");
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)widgetException), (String)"WidgetException.emptyMet\u2026tManifest::products.name)");
            throw (Throwable)widgetException;
        }
        return $receiver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final String getRootDirectory() {
        Object object;
        String string;
        Closeable closeable;
        block15: {
            String commonDirectory2;
            String string2;
            closeable = new ZipInputStream((InputStream)this.getArchive.invoke());
            Throwable throwable = null;
            try {
                String $receiver$iv;
                ZipInputStream zip = (ZipInputStream)closeable;
                try {
                    String initial$iv;
                    Sequence sequence = SequencesKt.filterNot((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.generateSequence((Function0)((Function0)new Function0<ZipEntry>(zip){
                        final /* synthetic */ ZipInputStream $zip;

                        public final ZipEntry invoke() {
                            return this.$zip.getNextEntry();
                        }
                        {
                            this.$zip = zipInputStream;
                            super(0);
                        }
                    })), (Function1)rootDirectory.commonDirectory.1.2.INSTANCE), (Function1)((Function1)new Function1<ZipEntry, String>(this){
                        final /* synthetic */ WidgetArchive this$0;
                        {
                            this.this$0 = widgetArchive2;
                            super(1);
                        }

                        @Nullable
                        public final String invoke(@NotNull ZipEntry it) {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            String string = it.getName();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.name");
                            return WidgetArchive.access$normalizePath(this.this$0, string);
                        }
                    })), (Function1)rootDirectory.commonDirectory.1.4.INSTANCE);
                    String accumulator$iv = initial$iv = (String)null;
                    Iterator iterator2 = $receiver$iv.iterator();
                    while (iterator2.hasNext()) {
                        void name;
                        Object element$iv = iterator2.next();
                        String string3 = (String)element$iv;
                        String prefix = accumulator$iv;
                        String string4 = prefix;
                        if (string4 == null || (string4 = StringsKt.commonPrefixWith$default((CharSequence)string4, (CharSequence)((CharSequence)name), (boolean)false, (int)2, null)) == null) {
                            string4 = name;
                        }
                        accumulator$iv = string4;
                    }
                    $receiver$iv = accumulator$iv;
                }
                catch (Throwable e) {
                    WidgetException widgetException = WidgetException.archiveIsMalformed((Throwable)e);
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)widgetException), (String)"WidgetException.archiveIsMalformed(e)");
                    throw (Throwable)widgetException;
                }
                string2 = $receiver$iv;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            String string5 = commonDirectory2 = string2;
            if (string5 != null) {
                String $receiver$iv = string5;
                int n = StringsKt.getLastIndex((CharSequence)$receiver$iv);
                boolean bl = false;
                while (n >= 0) {
                    void index$iv;
                    char it = $receiver$iv.charAt((int)index$iv);
                    if (!(it != '/')) {
                        String string6 = $receiver$iv;
                        int n2 = 0;
                        void var7_15 = index$iv + true;
                        String string7 = string6.substring(n2, (int)var7_15);
                        string = string7;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        break block15;
                    }
                    --index$iv;
                }
                string = "";
            } else {
                string = null;
            }
        }
        if ((object = (closeable = string)) == null) {
            object = "";
        }
        return object;
    }

    private final String normalizePath(@NotNull String $receiver) {
        String string;
        try {
            String string2 = new URI(null, null, $receiver, null).normalize().toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"URI(null, null, this, nu\u2026              .toString()");
            string = StringsKt.removePrefix((String)string2, (CharSequence)"/");
        }
        catch (URISyntaxException e) {
            string = null;
        }
        return string;
    }

    @NotNull
    public final Function0<InputStream> getGetArchive() {
        return this.getArchive;
    }

    public WidgetArchive(@NotNull Function0<? extends InputStream> getArchive2) {
        Intrinsics.checkParameterIsNotNull(getArchive2, (String)"getArchive");
        this.getArchive = getArchive2;
    }

    static {
        Companion = new Companion(null);
        MAX_ARCHIVE_FILE_SIZE = 0xA00000L;
        MAX_ARCHIVE_FILE_NUMBER = 1000;
        MAX_UNCOMPRESSED_FILE_SIZE = 0x1E00000L;
    }

    @Nullable
    public static final /* synthetic */ String access$normalizePath(WidgetArchive $this, @NotNull String $receiver) {
        return $this.normalizePath($receiver);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\f\u0010\u001b\u001a\u00020\r*\u00020\rH\u0002J\u0014\u0010\u001c\u001a\u00020\u001a*\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\rH\u0002J\u001c\u0010\u001c\u001a\u00020\u001e*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000f\"\u0004\b\u0014\u0010\u0011\u00a8\u0006 "}, d2={"Ljetbrains/jetpass/dao/dnq/api/widget/WidgetArchive$Companion;", "", "()V", "INDEX_HTML_FILENAME", "", "MANIFEST_FILENAME", "MAX_ARCHIVE_FILE_NUMBER", "", "getMAX_ARCHIVE_FILE_NUMBER", "()I", "setMAX_ARCHIVE_FILE_NUMBER", "(I)V", "MAX_ARCHIVE_FILE_SIZE", "", "getMAX_ARCHIVE_FILE_SIZE", "()J", "setMAX_ARCHIVE_FILE_SIZE", "(J)V", "MAX_UNCOMPRESSED_FILE_SIZE", "getMAX_UNCOMPRESSED_FILE_SIZE", "setMAX_UNCOMPRESSED_FILE_SIZE", "save", "Ljetbrains/jetpass/dao/dnq/api/widget/WidgetArchive;", "file", "Ljava/io/File;", "sourceWidgetArchive", "Ljava/io/InputStream;", "bytesToMb", "withSizeLimit", "maxSize", "Ljava/io/Reader;", "fileName", "jetbrains.jetpass.dao.dnq"})
    public static final class Companion {
        public final long getMAX_ARCHIVE_FILE_SIZE() {
            return MAX_ARCHIVE_FILE_SIZE;
        }

        public final void setMAX_ARCHIVE_FILE_SIZE(long l) {
            MAX_ARCHIVE_FILE_SIZE = l;
        }

        public final int getMAX_ARCHIVE_FILE_NUMBER() {
            return MAX_ARCHIVE_FILE_NUMBER;
        }

        public final void setMAX_ARCHIVE_FILE_NUMBER(int n) {
            MAX_ARCHIVE_FILE_NUMBER = n;
        }

        public final long getMAX_UNCOMPRESSED_FILE_SIZE() {
            return MAX_UNCOMPRESSED_FILE_SIZE;
        }

        public final void setMAX_UNCOMPRESSED_FILE_SIZE(long l) {
            MAX_UNCOMPRESSED_FILE_SIZE = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final WidgetArchive save(@NotNull File file, @NotNull InputStream sourceWidgetArchive) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)sourceWidgetArchive, (String)"sourceWidgetArchive");
            Object object = file;
            object = new FileOutputStream((File)object);
            Throwable throwable = null;
            try {
                FileOutputStream out = (FileOutputStream)object;
                long l = ByteStreamsKt.copyTo$default((InputStream)Companion.withSizeLimit(sourceWidgetArchive, Companion.getMAX_ARCHIVE_FILE_SIZE()), (OutputStream)out, (int)0, (int)2, null);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            return new WidgetArchive((Function0<? extends InputStream>)((Function0)new Function0<BufferedInputStream>(file){
                final /* synthetic */ File $file;

                @NotNull
                public final BufferedInputStream invoke() {
                    Object object = this.$file;
                    object = new FileInputStream((File)object);
                    int n = 8192;
                    return object instanceof BufferedInputStream ? (BufferedInputStream)object : new BufferedInputStream((InputStream)object, n);
                }
                {
                    this.$file = file;
                    super(0);
                }
            }));
        }

        private final Reader withSizeLimit(@NotNull Reader $receiver, String fileName, long maxSize) {
            return (Reader)SizeLimitingReaderKt.limitSize((Reader)$receiver, (long)maxSize, (Function0)((Function0)new Function0<WidgetException>(fileName, maxSize){
                final /* synthetic */ String $fileName;
                final /* synthetic */ long $maxSize;

                @NotNull
                public final WidgetException invoke() {
                    WidgetException widgetException = WidgetException.archiveContentSizeExceeded((String)this.$fileName, (Long)jetbrains.jetpass.dao.dnq.api.widget.WidgetArchive$Companion.access$bytesToMb(WidgetArchive.Companion, this.$maxSize));
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)widgetException), (String)"WidgetException.archiveC\u2026ame, maxSize.bytesToMb())");
                    return widgetException;
                }
                {
                    this.$fileName = string;
                    this.$maxSize = l;
                    super(0);
                }
            }));
        }

        private final InputStream withSizeLimit(@NotNull InputStream $receiver, long maxSize) {
            return (InputStream)SizeLimitingInputStreamKt.limitSize((InputStream)$receiver, (long)maxSize, (Function0)((Function0)new Function0<WidgetException>(maxSize){
                final /* synthetic */ long $maxSize;

                @NotNull
                public final WidgetException invoke() {
                    WidgetException widgetException = WidgetException.archiveSizeExceeded((Long)jetbrains.jetpass.dao.dnq.api.widget.WidgetArchive$Companion.access$bytesToMb(WidgetArchive.Companion, this.$maxSize));
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)widgetException), (String)"WidgetException.archiveS\u2026eded(maxSize.bytesToMb())");
                    return widgetException;
                }
                {
                    this.$maxSize = l;
                    super(0);
                }
            }));
        }

        private final long bytesToMb(long $receiver) {
            return $receiver / (long)1024 / (long)1024;
        }

        private Companion() {
        }

        public static final /* synthetic */ long access$bytesToMb(Companion $this, long $receiver) {
            return $this.bytesToMb($receiver);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

