/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.dao.dnq.throttling;

import jetbrains.jetpass.auth.module.dnq.authentication.AuthenticationException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.Duration;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \t2\u00020\u0001:\u0001\tBA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012*\u0010\u0005\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00070\u0006\"\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\n"}, d2={"Ljetbrains/jetpass/dao/dnq/throttling/ThrottlingException;", "Ljetbrains/jetpass/auth/module/dnq/authentication/AuthenticationException;", "code", "", "message", "params", "", "Lkotlin/Pair;", "(Ljava/lang/String;Ljava/lang/String;[Lkotlin/Pair;)V", "Companion", "jetbrains.jetpass.dao.dnq"})
public final class ThrottlingException
extends AuthenticationException {
    @NotNull
    public static final String RATE_EXCEEDED = "hub-throttling-rate-exceeded";
    @NotNull
    public static final String RATE_EXCEEDED_WITH_CAPTCHA = "hub-throttling-rate-exceeded-captcha";
    @NotNull
    public static final String IP_IS_BLACK_LISTED = "hub-throttling-black-listed-ip";
    @NotNull
    public static final String TOO_MANY_REQUESTS = "hub-throttling-too-many-requests";
    @NotNull
    public static final String TOO_MANY_REQUESTS_WITH_CAPTCHA = "hub-throttling-too-many-requests-captcha";
    @NotNull
    public static final String CANNOT_DECREASE_MAP_SIZE = "hub-throttling-map-size-decrease-failed";
    public static final Companion Companion = new Companion(null);

    public ThrottlingException(@NotNull String code, @NotNull String message, Pair<String, String> ... params) {
        Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull(params, (String)"params");
        super(code, message, MapsKt.toMap(params));
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\u001a\u0010\u000f\u001a\u00020\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\u0004J\u0018\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\u0004J1\u0010\u0014\u001a\u00020\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0015\u001a\u00020\r2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0011\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0018J\u0018\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u00172\b\u0010\u0011\u001a\u0004\u0018\u00010\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Ljetbrains/jetpass/dao/dnq/throttling/ThrottlingException$Companion;", "", "()V", "CANNOT_DECREASE_MAP_SIZE", "", "IP_IS_BLACK_LISTED", "RATE_EXCEEDED", "RATE_EXCEEDED_WITH_CAPTCHA", "TOO_MANY_REQUESTS", "TOO_MANY_REQUESTS_WITH_CAPTCHA", "cannotDecreaseMapSize", "Ljetbrains/jetpass/dao/dnq/throttling/ThrottlingException;", "proposedSize", "", "currentSize", "failedWithCaptcha", "key", "captchaPublicKey", "ipAddressIsBlackListed", "address", "rateExceeded", "maxValuePerKey", "cooldownDelay", "", "(Ljava/lang/String;ILjava/lang/Long;Ljava/lang/String;)Ljetbrains/jetpass/dao/dnq/throttling/ThrottlingException;", "tooManyRequests", "delayMillis", "jetbrains.jetpass.dao.dnq"})
    public static final class Companion {
        @NotNull
        public final ThrottlingException rateExceeded(@Nullable String key2, int maxValuePerKey, @Nullable Long cooldownDelay, @Nullable String captchaPublicKey) {
            CharSequence charSequence;
            long l;
            String string = key2;
            if (string == null) {
                string = "empty";
            }
            String username = string;
            Long l2 = cooldownDelay;
            long it = l = l2 != null ? l2 : 0L;
            long delay = new Duration(it).getStandardMinutes() + 1L;
            return captchaPublicKey != null && (charSequence = (CharSequence)captchaPublicKey).length() > 0 ? new ThrottlingException(ThrottlingException.RATE_EXCEEDED_WITH_CAPTCHA, "You or somebody else entered the wrong password for [" + username + "] too many times in a row [max=" + maxValuePerKey + "]. " + "To try another password, prove you are not a robot or try again later in [" + delay + "] minutes.", TuplesKt.to((Object)"username", (Object)username), TuplesKt.to((Object)"maxAttempts", (Object)String.valueOf(maxValuePerKey)), TuplesKt.to((Object)"delay", (Object)String.valueOf(delay)), TuplesKt.to((Object)"captcha", (Object)captchaPublicKey)) : new ThrottlingException(ThrottlingException.RATE_EXCEEDED, "Maximum number [" + maxValuePerKey + "] of consecutive failed logins " + "for [" + username + "] has been exceeded. Please try again later in [" + delay + "] minutes.", TuplesKt.to((Object)"username", (Object)username), TuplesKt.to((Object)"maxAttempts", (Object)String.valueOf(maxValuePerKey)), TuplesKt.to((Object)"delay", (Object)String.valueOf(delay)));
        }

        @NotNull
        public final ThrottlingException failedWithCaptcha(@Nullable String key2, @Nullable String captchaPublicKey) {
            ThrottlingException throttlingException;
            String string = key2;
            if (string == null) {
                string = "empty";
            }
            String username = string;
            Pair[] pairArray = new Pair[2];
            pairArray[0] = TuplesKt.to((Object)"username", (Object)username);
            String string2 = captchaPublicKey;
            String string3 = "captcha";
            int n = 1;
            Pair[] pairArray2 = pairArray;
            Pair[] pairArray3 = pairArray;
            String string4 = "Maximum number of consecutive failed logins for [" + username + "] has been exceeded";
            String string5 = ThrottlingException.RATE_EXCEEDED_WITH_CAPTCHA;
            ThrottlingException throttlingException2 = throttlingException;
            ThrottlingException throttlingException3 = throttlingException;
            String string6 = string2;
            if (string6 == null) {
                string6 = "";
            }
            String string7 = string6;
            pairArray2[n] = TuplesKt.to((Object)string3, (Object)string7);
            throttlingException2(string5, string4, pairArray3);
            return throttlingException3;
        }

        @NotNull
        public final ThrottlingException ipAddressIsBlackListed(@NotNull String address, @Nullable String captchaPublicKey) {
            ThrottlingException throttlingException;
            Intrinsics.checkParameterIsNotNull((Object)address, (String)"address");
            Pair[] pairArray = new Pair[2];
            pairArray[0] = TuplesKt.to((Object)"ip", (Object)address);
            String string = captchaPublicKey;
            String string2 = "captcha";
            int n = 1;
            Pair[] pairArray2 = pairArray;
            Pair[] pairArray3 = pairArray;
            String string3 = "Login from your IP address requires verification that you are not a robot";
            String string4 = ThrottlingException.IP_IS_BLACK_LISTED;
            ThrottlingException throttlingException2 = throttlingException;
            ThrottlingException throttlingException3 = throttlingException;
            String string5 = string;
            if (string5 == null) {
                string5 = "";
            }
            String string6 = string5;
            pairArray2[n] = TuplesKt.to((Object)string2, (Object)string6);
            throttlingException2(string4, string3, pairArray3);
            return throttlingException3;
        }

        @NotNull
        public final ThrottlingException tooManyRequests(long delayMillis, @Nullable String captchaPublicKey) {
            CharSequence charSequence;
            long delayMin = new Duration(delayMillis).getStandardMinutes() + 1L;
            return captchaPublicKey != null && !StringsKt.isBlank((CharSequence)(charSequence = (CharSequence)captchaPublicKey)) ? new ThrottlingException(ThrottlingException.TOO_MANY_REQUESTS_WITH_CAPTCHA, "The application is tracking failed requests from the maximum number of logins. Please prove you are not a robot or try again in [" + delayMin + "] minutes.", TuplesKt.to((Object)"delay", (Object)String.valueOf(delayMillis)), TuplesKt.to((Object)"captcha", (Object)captchaPublicKey)) : new ThrottlingException(ThrottlingException.TOO_MANY_REQUESTS, "The application is tracking failed requests from the maximum number of logins. Please try again in [" + delayMin + "] minutes.", TuplesKt.to((Object)"delay", (Object)String.valueOf(delayMillis)));
        }

        @NotNull
        public final ThrottlingException cannotDecreaseMapSize(int proposedSize, int currentSize) {
            return new ThrottlingException(ThrottlingException.CANNOT_DECREASE_MAP_SIZE, "The application is currently tracking failed requests from [" + currentSize + "] logins. To set the maximum below, wait until the next cooldown.", TuplesKt.to((Object)"proposedSize", (Object)String.valueOf(proposedSize)), TuplesKt.to((Object)"currentSize", (Object)String.valueOf(currentSize)));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

