/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.dao.dnq.throttling;

import jetbrains.jetpass.core.throttling.MaxSizeExceededException;
import jetbrains.jetpass.core.throttling.RateExceededException;
import jetbrains.jetpass.core.throttling.RateLimiter;
import jetbrains.jetpass.core.webr.async.RequestContext;
import jetbrains.jetpass.dao.dnq.throttling.ThrottlingException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u0000\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001aI\u0010\u0000\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0004\u001a\u00020\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u0002H\u00010\t\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"throttled", "T", "Ljetbrains/jetpass/core/throttling/RateLimiter;", "", "username", "captchaPublicKey", "isCaptchaVerified", "", "action", "Lkotlin/Function1;", "Ljetbrains/jetpass/core/throttling/RateLimiter$LimiterSession;", "(Ljetbrains/jetpass/core/throttling/RateLimiter;Ljava/lang/String;Ljava/lang/String;ZLkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "jetbrains.jetpass.dao.dnq"})
public final class ThrottlingUtilsKt {
    public static final <T> T throttled(@NotNull RateLimiter<String> $receiver, @NotNull String username, @Nullable String captchaPublicKey, boolean isCaptchaVerified, @NotNull Function1<? super RateLimiter.LimiterSession, ? extends T> action) {
        Object object;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)username, (String)"username");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        String remoteAddress = RequestContext.INSTANCE.getRemoteAddr();
        if (remoteAddress != null && $receiver.getBlackListedIPs().contains(remoteAddress) && !isCaptchaVerified) {
            throw (Throwable)((Object)ThrottlingException.Companion.ipAddressIsBlackListed(remoteAddress, captchaPublicKey));
        }
        try {
            object = $receiver.execute((Object)username, isCaptchaVerified, action);
        }
        catch (RateExceededException ex) {
            throw (Throwable)((Object)ThrottlingException.Companion.rateExceeded(username, $receiver.getFailedKeys().getBucketSize(), $receiver.getFailedKeys().getCooldownDelay(), captchaPublicKey));
        }
        catch (MaxSizeExceededException ex) {
            throw (Throwable)((Object)ThrottlingException.Companion.tooManyRequests($receiver.getFailedKeys().getCooldownDelay(), captchaPublicKey));
        }
        return (T)object;
    }
}

