/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.MultiUserChatException;
import org.jivesoftware.smackx.xdata.Form;
import org.jivesoftware.smackx.xdata.FormField;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.util.JidUtil;

public class MucConfigFormManager {
    public static final String MUC_ROOMCONFIG_ROOMOWNERS = "muc#roomconfig_roomowners";
    public static final String MUC_ROOMCONFIG_MEMBERSONLY = "muc#roomconfig_membersonly";
    public static final String MUC_ROOMCONFIG_PASSWORDPROTECTEDROOM = "muc#roomconfig_passwordprotectedroom";
    public static final String MUC_ROOMCONFIG_ROOMSECRET = "muc#roomconfig_roomsecret";
    private final MultiUserChat multiUserChat;
    private final Form answerForm;
    private final List<Jid> owners;

    MucConfigFormManager(MultiUserChat multiUserChat) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        this.multiUserChat = multiUserChat;
        Form configForm = multiUserChat.getConfigurationForm();
        this.answerForm = configForm.createAnswerForm();
        for (FormField field : configForm.getFields()) {
            if (field.getType() == FormField.Type.hidden || StringUtils.isNullOrEmpty((CharSequence)field.getVariable())) continue;
            this.answerForm.setDefaultAnswer(field.getVariable());
        }
        if (this.answerForm.hasField(MUC_ROOMCONFIG_ROOMOWNERS)) {
            List<CharSequence> ownerStrings = this.answerForm.getField(MUC_ROOMCONFIG_ROOMOWNERS).getValues();
            this.owners = new ArrayList<Jid>(ownerStrings.size());
            JidUtil.jidsFrom(ownerStrings, this.owners, null);
        } else {
            this.owners = null;
        }
    }

    public boolean supportsRoomOwners() {
        return this.owners != null;
    }

    public MucConfigFormManager setRoomOwners(Collection<? extends Jid> newOwners) throws MultiUserChatException.MucConfigurationNotSupportedException {
        if (!this.supportsRoomOwners()) {
            throw new MultiUserChatException.MucConfigurationNotSupportedException(MUC_ROOMCONFIG_ROOMOWNERS);
        }
        this.owners.clear();
        this.owners.addAll(newOwners);
        return this;
    }

    public boolean supportsMembersOnly() {
        return this.answerForm.hasField(MUC_ROOMCONFIG_MEMBERSONLY);
    }

    public MucConfigFormManager makeMembersOnly() throws MultiUserChatException.MucConfigurationNotSupportedException {
        return this.setMembersOnly(true);
    }

    public MucConfigFormManager setMembersOnly(boolean isMembersOnly) throws MultiUserChatException.MucConfigurationNotSupportedException {
        if (!this.supportsMembersOnly()) {
            throw new MultiUserChatException.MucConfigurationNotSupportedException(MUC_ROOMCONFIG_MEMBERSONLY);
        }
        this.answerForm.setAnswer(MUC_ROOMCONFIG_MEMBERSONLY, isMembersOnly);
        return this;
    }

    public boolean supportsPasswordProtected() {
        return this.answerForm.hasField(MUC_ROOMCONFIG_PASSWORDPROTECTEDROOM);
    }

    public MucConfigFormManager setAndEnablePassword(String password) throws MultiUserChatException.MucConfigurationNotSupportedException {
        return this.setIsPasswordProtected(true).setRoomSecret(password);
    }

    public MucConfigFormManager makePasswordProtected() throws MultiUserChatException.MucConfigurationNotSupportedException {
        return this.setIsPasswordProtected(true);
    }

    public MucConfigFormManager setIsPasswordProtected(boolean isPasswordProtected) throws MultiUserChatException.MucConfigurationNotSupportedException {
        if (!this.supportsMembersOnly()) {
            throw new MultiUserChatException.MucConfigurationNotSupportedException(MUC_ROOMCONFIG_PASSWORDPROTECTEDROOM);
        }
        this.answerForm.setAnswer(MUC_ROOMCONFIG_PASSWORDPROTECTEDROOM, isPasswordProtected);
        return this;
    }

    public MucConfigFormManager setRoomSecret(String secret) throws MultiUserChatException.MucConfigurationNotSupportedException {
        if (!this.answerForm.hasField(MUC_ROOMCONFIG_ROOMSECRET)) {
            throw new MultiUserChatException.MucConfigurationNotSupportedException(MUC_ROOMCONFIG_ROOMSECRET);
        }
        this.answerForm.setAnswer(MUC_ROOMCONFIG_ROOMSECRET, secret);
        return this;
    }

    public void submitConfigurationForm() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        if (this.owners != null) {
            this.answerForm.setAnswer(MUC_ROOMCONFIG_ROOMOWNERS, JidUtil.toStringList(this.owners));
        }
        this.multiUserChat.sendConfigurationForm(this.answerForm);
    }
}

