/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.privacy.packet;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.privacy.packet.PrivacyItem;

public class Privacy
extends IQ {
    public static final String ELEMENT = "query";
    public static final String NAMESPACE = "jabber:iq:privacy";
    private boolean declineActiveList = false;
    private String activeName;
    private boolean declineDefaultList = false;
    private String defaultName;
    private final Map<String, List<PrivacyItem>> itemLists = new HashMap<String, List<PrivacyItem>>();

    public Privacy() {
        super(ELEMENT, NAMESPACE);
    }

    public List<PrivacyItem> setPrivacyList(String listName, List<PrivacyItem> listItem) {
        this.getItemLists().put(listName, listItem);
        return listItem;
    }

    public List<PrivacyItem> setActivePrivacyList() {
        this.setActiveName(this.getDefaultName());
        return this.getItemLists().get(this.getActiveName());
    }

    public void deletePrivacyList(String listName) {
        this.getItemLists().remove(listName);
        if (this.getDefaultName() != null && listName.equals(this.getDefaultName())) {
            this.setDefaultName(null);
        }
    }

    public List<PrivacyItem> getActivePrivacyList() {
        if (this.getActiveName() == null) {
            return null;
        }
        return this.getItemLists().get(this.getActiveName());
    }

    public List<PrivacyItem> getDefaultPrivacyList() {
        if (this.getDefaultName() == null) {
            return null;
        }
        return this.getItemLists().get(this.getDefaultName());
    }

    public List<PrivacyItem> getPrivacyList(String listName) {
        return this.getItemLists().get(listName);
    }

    public PrivacyItem getItem(String listName, int order) {
        Iterator<PrivacyItem> values = this.getPrivacyList(listName).iterator();
        PrivacyItem itemFound = null;
        while (itemFound == null && values.hasNext()) {
            PrivacyItem element = values.next();
            if (element.getOrder() != (long)order) continue;
            itemFound = element;
        }
        return itemFound;
    }

    public boolean changeDefaultList(String newDefault) {
        if (this.getItemLists().containsKey(newDefault)) {
            this.setDefaultName(newDefault);
            return true;
        }
        return false;
    }

    public void deleteList(String listName) {
        this.getItemLists().remove(listName);
    }

    public String getActiveName() {
        return this.activeName;
    }

    public void setActiveName(String activeName) {
        this.activeName = activeName;
    }

    public String getDefaultName() {
        return this.defaultName;
    }

    public void setDefaultName(String defaultName) {
        this.defaultName = defaultName;
    }

    public Map<String, List<PrivacyItem>> getItemLists() {
        return this.itemLists;
    }

    public boolean isDeclineActiveList() {
        return this.declineActiveList;
    }

    public void setDeclineActiveList(boolean declineActiveList) {
        this.declineActiveList = declineActiveList;
    }

    public boolean isDeclineDefaultList() {
        return this.declineDefaultList;
    }

    public void setDeclineDefaultList(boolean declineDefaultList) {
        this.declineDefaultList = declineDefaultList;
    }

    public Set<String> getPrivacyListNames() {
        return this.itemLists.keySet();
    }

    protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder buf) {
        buf.rightAngleBracket();
        if (this.isDeclineActiveList()) {
            buf.append((CharSequence)"<active/>");
        } else if (this.getActiveName() != null) {
            buf.append((CharSequence)"<active name=\"").escape(this.getActiveName()).append((CharSequence)"\"/>");
        }
        if (this.isDeclineDefaultList()) {
            buf.append((CharSequence)"<default/>");
        } else if (this.getDefaultName() != null) {
            buf.append((CharSequence)"<default name=\"").escape(this.getDefaultName()).append((CharSequence)"\"/>");
        }
        for (Map.Entry<String, List<PrivacyItem>> entry : this.getItemLists().entrySet()) {
            String listName = entry.getKey();
            List<PrivacyItem> items = entry.getValue();
            if (items.isEmpty()) {
                buf.append((CharSequence)"<list name=\"").escape(listName).append((CharSequence)"\"/>");
            } else {
                buf.append((CharSequence)"<list name=\"").escape(listName).append((CharSequence)"\">");
            }
            for (PrivacyItem item : items) {
                buf.append((CharSequence)item.toXML());
            }
            if (items.isEmpty()) continue;
            buf.append((CharSequence)"</list>");
        }
        return buf;
    }
}

