/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher;

import com.jetbrains.launcher.AppConfigFilesEx;
import com.jetbrains.launcher.AppConfigFilesImpl;
import com.jetbrains.launcher.AppFilesEx;
import com.jetbrains.launcher.util.StringUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppFilesImpl
extends AppConfigFilesImpl
implements AppFilesEx {
    @NotNull
    private final AppConfigFilesImpl.PathHolder myBaseFolder;
    @NotNull
    private final AppConfigFilesImpl.PathHolder myAppLibFolder;
    @NotNull
    private final AppConfigFilesImpl.PathHolder myAppLogsFolder;
    @NotNull
    private final AppConfigFilesImpl.PathHolder myLauncherLogsFolder;

    @Nullable
    public static AppFilesEx detectFiles() {
        AppConfigFilesEx appConfigFiles = AppFilesImpl.detectConfigFiles();
        return appConfigFiles == null ? null : new AppFilesImpl(appConfigFiles, System.getProperty("launcher.base.dir"), System.getProperty("launcher.app.lib.dir"), System.getProperty("launcher.app.logs.dir"), System.getProperty("launcher.logs.dir"));
    }

    public AppFilesImpl(@NotNull AppConfigFilesEx appConfigFiles, @Nullable String baseDirPath, @Nullable String appLibDirPath, @Nullable String appLogsDirPath, @Nullable String launcherLogsDirPath) {
        if (appConfigFiles == null) {
            AppFilesImpl.$$$reportNull$$$0(0);
        }
        this(appConfigFiles.getAppHome(), baseDirPath, appConfigFiles.getAppConfigRawPath(), appLibDirPath, appLogsDirPath, launcherLogsDirPath);
    }

    private AppFilesImpl(@NotNull File appHome, @Nullable String baseDirPath, @Nullable String appConfDirPath, @Nullable String appLibDirPath, @Nullable String appLogsDirPath, @Nullable String launcherLogsDirPath) {
        if (appHome == null) {
            AppFilesImpl.$$$reportNull$$$0(1);
        }
        super(appHome, appConfDirPath);
        this.myBaseFolder = new AppConfigFilesImpl.PathHolder(baseDirPath){

            @Override
            @NotNull
            protected File resolve() {
                File file = AppFilesImpl.this.resolvePath(this.getRawPath(), ".");
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                return file;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/launcher/AppFilesImpl$1", "resolve"));
            }
        };
        this.myAppLibFolder = new AppConfigFilesImpl.PathHolder(appLibDirPath){

            @Override
            @NotNull
            protected File resolve() {
                File file = AppFilesImpl.this.resolvePath(this.getRawPath(), "lib");
                if (file == null) {
                    2.$$$reportNull$$$0(0);
                }
                return file;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/launcher/AppFilesImpl$2", "resolve"));
            }
        };
        this.myAppLogsFolder = new AppConfigFilesImpl.PathHolder(appLogsDirPath){

            @Override
            @NotNull
            protected File resolve() {
                File file = AppFilesImpl.this.resolveAppLogsFolder(this.getRawPath());
                if (file == null) {
                    3.$$$reportNull$$$0(0);
                }
                return file;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/launcher/AppFilesImpl$3", "resolve"));
            }
        };
        this.myLauncherLogsFolder = new AppConfigFilesImpl.PathHolder(launcherLogsDirPath){

            @Override
            @NotNull
            protected File resolve() {
                File file = AppFilesImpl.this.resolveLauncherLogsFolder(this.getRawPath());
                if (file == null) {
                    4.$$$reportNull$$$0(0);
                }
                return file;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/launcher/AppFilesImpl$4", "resolve"));
            }
        };
    }

    @NotNull
    private File resolveAppLogsFolder(@Nullable String appLogsDirPath) {
        File file = this.resolvePath(StringUtil.notNullize((String)appLogsDirPath, (String)"logs"));
        if (file == null) {
            AppFilesImpl.$$$reportNull$$$0(2);
        }
        return file;
    }

    @NotNull
    private File resolveLauncherLogsFolder(@Nullable String launcherLogsDirPath) {
        File file = this.resolvePath(this.myAppLogsFolder.get(), StringUtil.notNullize((String)launcherLogsDirPath, (String)"."));
        if (file == null) {
            AppFilesImpl.$$$reportNull$$$0(3);
        }
        return file;
    }

    @NotNull
    public File getBaseFolder() {
        File file = this.myBaseFolder.get();
        if (file == null) {
            AppFilesImpl.$$$reportNull$$$0(4);
        }
        return file;
    }

    @NotNull
    public File getAppLibFolder() {
        File file = this.myAppLibFolder.get();
        if (file == null) {
            AppFilesImpl.$$$reportNull$$$0(5);
        }
        return file;
    }

    @NotNull
    public File getAppLogsFolder() {
        File file = this.myAppLogsFolder.get();
        if (file == null) {
            AppFilesImpl.$$$reportNull$$$0(6);
        }
        return file;
    }

    @NotNull
    public File getLauncherLogsFolder() {
        File file = this.myLauncherLogsFolder.get();
        if (file == null) {
            AppFilesImpl.$$$reportNull$$$0(7);
        }
        return file;
    }

    @NotNull
    public AppFilesImpl getBaseFiles() {
        AppFilesImpl appFilesImpl = this.createNewAppFiles(this.getBaseFolder());
        if (appFilesImpl == null) {
            AppFilesImpl.$$$reportNull$$$0(8);
        }
        return appFilesImpl;
    }

    @NotNull
    private AppFilesImpl createNewAppFiles(@NotNull File appHome) {
        if (appHome == null) {
            AppFilesImpl.$$$reportNull$$$0(9);
        }
        AppFilesImpl appFilesImpl = new AppFilesImpl(appHome, this.myBaseFolder.getRawPath(), this.getAppConfigRawPath(), this.myAppLibFolder.getRawPath(), this.myAppLogsFolder.getRawPath(), this.myLauncherLogsFolder.getRawPath());
        if (appFilesImpl == null) {
            AppFilesImpl.$$$reportNull$$$0(10);
        }
        return appFilesImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appConfigFiles";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appHome";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/AppFilesImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/AppFilesImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveAppLogsFolder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveLauncherLogsFolder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseFolder";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppLibFolder";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppLogsFolder";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLauncherLogsFolder";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseFiles";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewAppFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createNewAppFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

