/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.log;

import com.jetbrains.launcher.InitException;
import com.jetbrains.launcher.log.ConsoleLogger;
import com.jetbrains.launcher.log.LoggersEx;
import com.jetbrains.launcher.util.StringUtil;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SafeLogger {
    @NotNull
    private final Logger myLog;

    public SafeLogger(@NotNull Logger log) {
        if (log == null) {
            SafeLogger.$$$reportNull$$$0(0);
        }
        this.myLog = log;
    }

    public void safeError(@Nullable String message) {
        if (StringUtil.isEmpty((String)message)) {
            return;
        }
        if (LoggersEx.isInitialized()) {
            this.myLog.error((Object)message);
        } else {
            ConsoleLogger.error(message);
        }
    }

    public void safeDebug(@Nullable String message) {
        if (StringUtil.isEmpty((String)message)) {
            return;
        }
        if (LoggersEx.isInitialized()) {
            this.myLog.debug((Object)message);
        } else {
            ConsoleLogger.debug(message);
        }
    }

    public void safeInitError(@NotNull InitException e) {
        if (e == null) {
            SafeLogger.$$$reportNull$$$0(1);
        }
        String message = e.getMessage();
        Throwable cause = e.getCause();
        if (LoggersEx.isInitialized()) {
            this.myLog.error((Object)message);
            if (cause != null) {
                this.myLog.error((Object)message, cause);
            }
        } else {
            ConsoleLogger.error(message);
            if (cause != null) {
                ConsoleLogger.error(cause);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "log";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/launcher/log/SafeLogger";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "safeInitError";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

