/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.util;

import com.jetbrains.launcher.AppFiles;
import com.jetbrains.launcher.AppFixedFiles;
import com.jetbrains.launcher.AppName;
import com.jetbrains.launcher.InitException;
import com.jetbrains.launcher.UserMessageTransformer;
import com.jetbrains.launcher.transport.ConnectionData;
import com.jetbrains.launcher.util.DateUtil;
import com.jetbrains.launcher.util.FileUtil;
import com.jetbrains.launcher.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class RuntimeUtil {
    @NotNull
    private static final String LAUNCHER_LOCK_FILE_NAME = "launcher.lock";
    @NotNull
    private static final String LAUNCHER_CONTROL_LOCK_FILE_NAME = "launcher.control.lock";
    @NotNull
    private static final String LAUNCHER_HOME_FILE_NAME = "launcher.home";
    @NotNull
    private static final String LAUNCHER_PID_FILE_NAME = "launcher.pid";
    @NotNull
    private static final String APP_START_FLAG_FILE_NAME_SUFFIX = ".start.flag";
    @NotNull
    private static final String APP_EXIT_FLAG_FILE_NAME_SUFFIX = ".exit.flag";
    @NotNull
    private static final String APP_PORT_FILE_NAME_SUFFIX = ".port";
    @NotNull
    private static final String APP_PID_FILE_NAME_SUFFIX = ".pid";

    @NotNull
    public static List<File> getAllAppRuntimeFiles(@NotNull AppFiles appFiles) {
        if (appFiles == null) {
            RuntimeUtil.$$$reportNull$$$0(0);
        }
        List<File> list = RuntimeUtil.getAppRuntimeFiles(appFiles, true);
        if (list == null) {
            RuntimeUtil.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public static List<File> getAppRuntimeFiles(final @NotNull AppFiles appFiles, final boolean includeStartFlag) {
        if (appFiles == null) {
            RuntimeUtil.$$$reportNull$$$0(2);
        }
        List<File> list = Collections.unmodifiableList(new ArrayList<File>(){
            {
                this.add(RuntimeUtil.getAppPidFile(appFiles));
                this.add(RuntimeUtil.getAppPortFile(appFiles));
                this.add(RuntimeUtil.getAppExitFlagFile(appFiles));
                if (includeStartFlag) {
                    this.add(RuntimeUtil.getAppStartFlagFile(appFiles));
                }
            }
        });
        if (list == null) {
            RuntimeUtil.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public static List<File> getRuntimeFilesToMonitor(final @NotNull AppFiles appFiles) {
        if (appFiles == null) {
            RuntimeUtil.$$$reportNull$$$0(4);
        }
        List<File> list = Collections.unmodifiableList(new ArrayList<File>(){
            {
                this.add(RuntimeUtil.getLauncherLockFile(appFiles));
                this.add(RuntimeUtil.getLauncherHomeFile(appFiles));
                this.add(RuntimeUtil.getLauncherPidFile(appFiles));
                this.add(RuntimeUtil.getAppPortFile(appFiles));
                this.add(RuntimeUtil.getAppPidFile(appFiles));
            }
        });
        if (list == null) {
            RuntimeUtil.$$$reportNull$$$0(5);
        }
        return list;
    }

    public static int loadAppPid(@NotNull AppFiles appFiles) throws IOException {
        if (appFiles == null) {
            RuntimeUtil.$$$reportNull$$$0(6);
        }
        return RuntimeUtil.toInt(FileUtil.loadText((File)RuntimeUtil.getAppPidFile(appFiles)).trim());
    }

    @NotNull
    public static ConnectionData loadConnectionData(@NotNull AppFiles appFiles) throws IOException {
        String value;
        int sepPos;
        if (appFiles == null) {
            RuntimeUtil.$$$reportNull$$$0(7);
        }
        if ((sepPos = (value = FileUtil.loadText((File)RuntimeUtil.getAppPortFile(appFiles)).trim()).indexOf(58)) == -1) {
            throw new IOException("Invalid format of connection data: " + value);
        }
        ConnectionData connectionData = new ConnectionData(RuntimeUtil.toInt(value.substring(0, sepPos).trim()), value.substring(sepPos + 1).trim());
        if (connectionData == null) {
            RuntimeUtil.$$$reportNull$$$0(8);
        }
        return connectionData;
    }

    private static int toInt(@NotNull String value) throws IOException {
        if (value == null) {
            RuntimeUtil.$$$reportNull$$$0(9);
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new IOException("Failed to parse integer value: " + value);
        }
    }

    public static void saveAppPid(@NotNull AppFiles appFiles, int pid) throws IOException {
        if (appFiles == null) {
            RuntimeUtil.$$$reportNull$$$0(10);
        }
        FileUtil.saveText((File)RuntimeUtil.getAppPidFile(appFiles), (String)String.valueOf(pid));
    }

    public static void saveConnectionData(@NotNull AppFiles appFiles, @NotNull ConnectionData data) throws IOException {
        if (appFiles == null) {
            RuntimeUtil.$$$reportNull$$$0(11);
        }
        if (data == null) {
            RuntimeUtil.$$$reportNull$$$0(12);
        }
        FileUtil.saveText((File)RuntimeUtil.getAppPortFile(appFiles), (String)(String.valueOf(data.getPort()) + ":" + data.getAuthToken()));
    }

    public static boolean hasConnectionData(@NotNull AppFiles appFiles) {
        if (appFiles == null) {
            RuntimeUtil.$$$reportNull$$$0(13);
        }
        return RuntimeUtil.getAppPortFile(appFiles).isFile();
    }

    public static void saveLauncherHome(@NotNull File launcherLogsFolder, @NotNull AppFixedFiles appFixedFiles) throws IOException {
        if (launcherLogsFolder == null) {
            RuntimeUtil.$$$reportNull$$$0(14);
        }
        if (appFixedFiles == null) {
            RuntimeUtil.$$$reportNull$$$0(15);
        }
        FileUtil.saveText((File)RuntimeUtil.getLauncherHomeFile(launcherLogsFolder), (String)appFixedFiles.getAppHome().getAbsolutePath());
    }

    @NotNull
    public static File loadLauncherHome(@NotNull File launcherLogsFolder) throws IOException {
        if (launcherLogsFolder == null) {
            RuntimeUtil.$$$reportNull$$$0(16);
        }
        File file = new File(FileUtil.loadText((File)RuntimeUtil.getLauncherHomeFile(launcherLogsFolder)));
        if (file == null) {
            RuntimeUtil.$$$reportNull$$$0(17);
        }
        return file;
    }

    public static void saveLauncherPid(@NotNull File launcherLogsFolder, int pid) throws IOException {
        if (launcherLogsFolder == null) {
            RuntimeUtil.$$$reportNull$$$0(18);
        }
        FileUtil.saveText((File)RuntimeUtil.getLauncherPidFile(launcherLogsFolder), (String)String.valueOf(pid));
    }

    public static int loadLauncherPid(@NotNull File launcherLogsFolder) throws IOException {
        if (launcherLogsFolder == null) {
            RuntimeUtil.$$$reportNull$$$0(19);
        }
        return RuntimeUtil.toInt(FileUtil.loadText((File)RuntimeUtil.getLauncherPidFile(launcherLogsFolder)).trim());
    }

    public static void setStartFlag(@NotNull File launcherLogsFolder, @NotNull AppFixedFiles appFixedFiles) throws IOException {
        if (launcherLogsFolder == null) {
            RuntimeUtil.$$$reportNull$$$0(20);
        }
        if (appFixedFiles == null) {
            RuntimeUtil.$$$reportNull$$$0(21);
        }
        FileUtil.setFileFlag((File)RuntimeUtil.getAppStartFlagFile(launcherLogsFolder, appFixedFiles));
    }

    public static boolean isStartFlagSet(@NotNull AppFiles appFiles) {
        if (appFiles == null) {
            RuntimeUtil.$$$reportNull$$$0(22);
        }
        return RuntimeUtil.getAppStartFlagFile(appFiles).isFile();
    }

    public static void removeStartFlag(@NotNull AppFiles appFiles) {
        if (appFiles == null) {
            RuntimeUtil.$$$reportNull$$$0(23);
        }
        FileUtil.delete((File)RuntimeUtil.getAppStartFlagFile(appFiles));
    }

    public static void setExitFlag(@NotNull AppFiles appFiles) throws IOException {
        if (appFiles == null) {
            RuntimeUtil.$$$reportNull$$$0(24);
        }
        FileUtil.setFileFlag((File)RuntimeUtil.getAppExitFlagFile(appFiles));
    }

    public static boolean isExitFlagSet(@NotNull AppFiles appFiles) {
        if (appFiles == null) {
            RuntimeUtil.$$$reportNull$$$0(25);
        }
        return RuntimeUtil.getAppExitFlagFile(appFiles).isFile();
    }

    @NotNull
    private static File getLauncherLockFile(@NotNull AppFiles appFiles) {
        if (appFiles == null) {
            RuntimeUtil.$$$reportNull$$$0(26);
        }
        File file = RuntimeUtil.getLauncherLockFile(appFiles.getLauncherLogsFolder());
        if (file == null) {
            RuntimeUtil.$$$reportNull$$$0(27);
        }
        return file;
    }

    @NotNull
    public static File getLauncherLockFile(@NotNull File launcherLogsFolder) {
        if (launcherLogsFolder == null) {
            RuntimeUtil.$$$reportNull$$$0(28);
        }
        File file = new File(launcherLogsFolder, LAUNCHER_LOCK_FILE_NAME);
        if (file == null) {
            RuntimeUtil.$$$reportNull$$$0(29);
        }
        return file;
    }

    @NotNull
    public static File getLauncherControlLockFile(@NotNull File launcherLogsFolder) {
        if (launcherLogsFolder == null) {
            RuntimeUtil.$$$reportNull$$$0(30);
        }
        File file = new File(launcherLogsFolder, LAUNCHER_CONTROL_LOCK_FILE_NAME);
        if (file == null) {
            RuntimeUtil.$$$reportNull$$$0(31);
        }
        return file;
    }

    @NotNull
    private static File getLauncherHomeFile(@NotNull AppFiles appFiles) {
        if (appFiles == null) {
            RuntimeUtil.$$$reportNull$$$0(32);
        }
        File file = RuntimeUtil.getLauncherHomeFile(appFiles.getLauncherLogsFolder());
        if (file == null) {
            RuntimeUtil.$$$reportNull$$$0(33);
        }
        return file;
    }

    @NotNull
    public static File getLauncherHomeFile(@NotNull File launcherLogsFolder) {
        if (launcherLogsFolder == null) {
            RuntimeUtil.$$$reportNull$$$0(34);
        }
        File file = new File(launcherLogsFolder, LAUNCHER_HOME_FILE_NAME);
        if (file == null) {
            RuntimeUtil.$$$reportNull$$$0(35);
        }
        return file;
    }

    @NotNull
    private static File getLauncherPidFile(@NotNull AppFiles appFiles) {
        if (appFiles == null) {
            RuntimeUtil.$$$reportNull$$$0(36);
        }
        File file = RuntimeUtil.getLauncherPidFile(appFiles.getLauncherLogsFolder());
        if (file == null) {
            RuntimeUtil.$$$reportNull$$$0(37);
        }
        return file;
    }

    @NotNull
    public static File getLauncherPidFile(@NotNull File launcherLogsFolder) {
        if (launcherLogsFolder == null) {
            RuntimeUtil.$$$reportNull$$$0(38);
        }
        File file = new File(launcherLogsFolder, LAUNCHER_PID_FILE_NAME);
        if (file == null) {
            RuntimeUtil.$$$reportNull$$$0(39);
        }
        return file;
    }

    @NotNull
    private static File getAppPidFile(@NotNull AppFiles appFiles) {
        if (appFiles == null) {
            RuntimeUtil.$$$reportNull$$$0(40);
        }
        File file = new File(appFiles.getLauncherLogsFolder(), appFiles.getAppFileName() + APP_PID_FILE_NAME_SUFFIX);
        if (file == null) {
            RuntimeUtil.$$$reportNull$$$0(41);
        }
        return file;
    }

    @NotNull
    private static File getAppPortFile(@NotNull AppFiles appFiles) {
        if (appFiles == null) {
            RuntimeUtil.$$$reportNull$$$0(42);
        }
        File file = new File(appFiles.getLauncherLogsFolder(), appFiles.getAppFileName() + APP_PORT_FILE_NAME_SUFFIX);
        if (file == null) {
            RuntimeUtil.$$$reportNull$$$0(43);
        }
        return file;
    }

    @NotNull
    public static File getAppExitFlagFile(@NotNull AppFiles appFiles) {
        if (appFiles == null) {
            RuntimeUtil.$$$reportNull$$$0(44);
        }
        File file = new File(appFiles.getLauncherLogsFolder(), appFiles.getAppFileName() + APP_EXIT_FLAG_FILE_NAME_SUFFIX);
        if (file == null) {
            RuntimeUtil.$$$reportNull$$$0(45);
        }
        return file;
    }

    @NotNull
    private static File getAppStartFlagFile(@NotNull AppFiles appFiles) {
        if (appFiles == null) {
            RuntimeUtil.$$$reportNull$$$0(46);
        }
        File file = RuntimeUtil.getAppStartFlagFile(appFiles.getLauncherLogsFolder(), (AppFixedFiles)appFiles);
        if (file == null) {
            RuntimeUtil.$$$reportNull$$$0(47);
        }
        return file;
    }

    @NotNull
    private static File getAppStartFlagFile(@NotNull File launcherLogsFolder, @NotNull AppFixedFiles appFixedFiles) {
        if (launcherLogsFolder == null) {
            RuntimeUtil.$$$reportNull$$$0(48);
        }
        if (appFixedFiles == null) {
            RuntimeUtil.$$$reportNull$$$0(49);
        }
        File file = new File(launcherLogsFolder, appFixedFiles.getAppFileName() + APP_START_FLAG_FILE_NAME_SUFFIX);
        if (file == null) {
            RuntimeUtil.$$$reportNull$$$0(50);
        }
        return file;
    }

    @NotNull
    public static File getAppThreadDumpFile(@NotNull AppFiles appFiles) {
        if (appFiles == null) {
            RuntimeUtil.$$$reportNull$$$0(51);
        }
        File file = new File(appFiles.getAppLogsFolder(), "threads-" + DateUtil.getSolidDateTimeString() + ".txt");
        if (file == null) {
            RuntimeUtil.$$$reportNull$$$0(52);
        }
        return file;
    }

    @NotNull
    public static File getLauncherThreadDumpFile(@NotNull AppFiles appFiles) {
        if (appFiles == null) {
            RuntimeUtil.$$$reportNull$$$0(53);
        }
        File file = new File(appFiles.getLauncherLogsFolder(), "launcher-threads-" + DateUtil.getSolidDateTimeString() + ".txt");
        if (file == null) {
            RuntimeUtil.$$$reportNull$$$0(54);
        }
        return file;
    }

    @NotNull
    public static File getAppHeapDumpFile(@NotNull AppFiles appFiles) {
        if (appFiles == null) {
            RuntimeUtil.$$$reportNull$$$0(55);
        }
        File file = new File(appFiles.getAppLogsFolder(), "heap-" + DateUtil.getSolidDateTimeString() + ".hprof");
        if (file == null) {
            RuntimeUtil.$$$reportNull$$$0(56);
        }
        return file;
    }

    @NotNull
    public static File getLauncherHeapDumpFile(@NotNull AppFiles appFiles) {
        if (appFiles == null) {
            RuntimeUtil.$$$reportNull$$$0(57);
        }
        File file = new File(appFiles.getLauncherLogsFolder(), "launcher-heap-" + DateUtil.getSolidDateTimeString() + ".hprof");
        if (file == null) {
            RuntimeUtil.$$$reportNull$$$0(58);
        }
        return file;
    }

    public static void createDirIfNeededAndCheckItIsWritable(@NotNull File dir, @NotNull String dirDescription) throws InitException {
        if (dir == null) {
            RuntimeUtil.$$$reportNull$$$0(59);
        }
        if (dirDescription == null) {
            RuntimeUtil.$$$reportNull$$$0(60);
        }
        if (!dir.exists() && !dir.mkdirs()) {
            throw new InitException("Failed to create " + dirDescription + ": " + dir.getAbsolutePath());
        }
        if (!dir.canWrite()) {
            throw new InitException(StringUtil.capitalize((String)dirDescription) + " is not writable: " + dir.getAbsolutePath());
        }
    }

    public static void addRuntimeReplacements(@NotNull AppFixedFiles appFiles, @NotNull AppName appName) {
        if (appFiles == null) {
            RuntimeUtil.$$$reportNull$$$0(61);
        }
        if (appName == null) {
            RuntimeUtil.$$$reportNull$$$0(62);
        }
        RuntimeUtil.addRuntimeReplacements(appFiles.getAppHome().getAbsolutePath(), appName);
    }

    static void addRuntimeReplacements(@NotNull String appHomePath, @NotNull AppName appName) {
        if (appHomePath == null) {
            RuntimeUtil.$$$reportNull$$$0(63);
        }
        if (appName == null) {
            RuntimeUtil.$$$reportNull$$$0(64);
        }
        String replacement = "<" + appName.getAllWordsCapitalizedName() + " Home>";
        UserMessageTransformer.addReplacement((String)(RuntimeUtil.getPathRegex(appHomePath) + "([\\\\/'`\"\\)\\]\\>\\}:;\\|]|$)"), (String)(replacement + "$1"));
    }

    @NotNull
    private static String getPathRegex(@NotNull String path) {
        if (path == null) {
            RuntimeUtil.$$$reportNull$$$0(65);
        }
        StringBuilder regex = new StringBuilder();
        for (String pathPart : path.split("[/\\\\]")) {
            StringUtil.append((StringBuilder)regex, (String)"[/\\\\]", (String)Pattern.quote(pathPart));
        }
        String string = regex.toString();
        if (string == null) {
            RuntimeUtil.$$$reportNull$$$0(66);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 17: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 47: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 58: 
            case 66: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 17: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 47: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 58: 
            case 66: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appFiles";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 17: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 47: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 58: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/util/RuntimeUtil";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 28: 
            case 30: 
            case 34: 
            case 38: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launcherLogsFolder";
                break;
            }
            case 15: 
            case 21: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appFixedFiles";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirDescription";
                break;
            }
            case 62: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appName";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appHomePath";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/util/RuntimeUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllAppRuntimeFiles";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppRuntimeFiles";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRuntimeFilesToMonitor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "loadConnectionData";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "loadLauncherHome";
                break;
            }
            case 27: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getLauncherLockFile";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getLauncherControlLockFile";
                break;
            }
            case 33: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getLauncherHomeFile";
                break;
            }
            case 37: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getLauncherPidFile";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppPidFile";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppPortFile";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppExitFlagFile";
                break;
            }
            case 47: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppStartFlagFile";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppThreadDumpFile";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getLauncherThreadDumpFile";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppHeapDumpFile";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getLauncherHeapDumpFile";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathRegex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAllAppRuntimeFiles";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 17: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 47: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 58: 
            case 66: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAppRuntimeFiles";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getRuntimeFilesToMonitor";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadAppPid";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadConnectionData";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "toInt";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "saveAppPid";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "saveConnectionData";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "hasConnectionData";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "saveLauncherHome";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "loadLauncherHome";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "saveLauncherPid";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "loadLauncherPid";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setStartFlag";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isStartFlagSet";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "removeStartFlag";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setExitFlag";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isExitFlagSet";
                break;
            }
            case 26: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getLauncherLockFile";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getLauncherControlLockFile";
                break;
            }
            case 32: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getLauncherHomeFile";
                break;
            }
            case 36: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getLauncherPidFile";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getAppPidFile";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getAppPortFile";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getAppExitFlagFile";
                break;
            }
            case 46: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getAppStartFlagFile";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getAppThreadDumpFile";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getLauncherThreadDumpFile";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getAppHeapDumpFile";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getLauncherHeapDumpFile";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "createDirIfNeededAndCheckItIsWritable";
                break;
            }
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "addRuntimeReplacements";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getPathRegex";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 17: 
            case 27: 
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 47: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 58: 
            case 66: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

