/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.jabber.bot;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jetbrains.charisma.main.CollectionUtilKt;
import jetbrains.charisma.persistent.IssueImpl;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.youtrack.api.l10n.BeansKt;
import jetbrains.youtrack.jabber.bot.IssuesAndCommand;
import jetbrains.youtrack.jabber.bot.JabberMessageListener;
import jetbrains.youtrack.jabber.bot.MessageSplitter;
import jetbrains.youtrack.jabber.bot.XdJabberBotState;
import jetbrains.youtrack.persistent.XdIssue;
import jetbrains.youtrack.persistent.security.IssueSecurityServiceImplKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\u0006J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Ljetbrains/youtrack/jabber/bot/StateLessMessageSplitter;", "Ljetbrains/youtrack/jabber/bot/MessageSplitter;", "()V", "splitIssuesIdsAndCommands", "Lkotlin/Pair;", "", "", "message", "splitMessage", "Ljetbrains/youtrack/jabber/bot/IssuesAndCommand;", "state", "Ljetbrains/youtrack/jabber/bot/XdJabberBotState;", "Companion", "youtrack-jabber-bot"})
public final class StateLessMessageSplitter
implements MessageSplitter {
    private static final String SEPARATOR = " ,";
    @NotNull
    private static String ISSUE_LIST_REGEXP;
    private static final Pattern ISSUE_LIST_PATTERN;
    private static final Pattern SINGLE_ISSUE_PATTERN;
    public static final Companion Companion;

    @Override
    @NotNull
    public IssuesAndCommand splitMessage(@NotNull String message, @NotNull XdJabberBotState state) {
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)((Object)state), (String)"state");
        Pair<Collection<String>, String> issuesAndCommand = this.splitIssuesIdsAndCommands(message);
        Iterable issueIds2 = (Iterable)issuesAndCommand.getFirst();
        String command = (String)issuesAndCommand.getSecond();
        HashSet<Entity> issues = new HashSet<Entity>();
        HashSet<String> unknownIssueIds = new HashSet<String>();
        HashSet<String> issuesWithoutPermissions = new HashSet<String>();
        if (CollectionUtilKt.isNotEmpty((Iterable)issueIds2)) {
            Iterable iterable = issueIds2;
            if (iterable == null) {
                Intrinsics.throwNpe();
            }
            $receiver$iv = iterable;
            for (Object element$iv : $receiver$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                Entity issue = IssueImpl.fromId((String)it);
                if (issue == null) {
                    unknownIssueIds.add(it);
                    continue;
                }
                if (!IssueSecurityServiceImplKt.getIssueSecurityService().isAccessible(issue)) {
                    issuesWithoutPermissions.add(it);
                    continue;
                }
                issues.add(issue);
            }
        }
        if (!($receiver$iv = (Collection)unknownIssueIds).isEmpty() || !($receiver$iv = (Collection)issuesWithoutPermissions).isEmpty()) {
            String errorMessage = BeansKt.getLocalizer().localizedMsg("StateLessMessageSplitter.Error", new Object[0]) + "<br/>";
            Object object = unknownIssueIds;
            if (!object.isEmpty()) {
                errorMessage = unknownIssueIds.size() == 1 ? errorMessage + BeansKt.getLocalizer().localizedMsg("StateLessMessageSplitter.Issue_{issue_id}_is_unknown", new Object[]{CollectionsKt.first((Iterable)unknownIssueIds)}) : errorMessage + BeansKt.getLocalizer().localizedMsg("StateLessMessageSplitter.Issues_{list_of_ids}_are_unknown", new Object[]{CollectionsKt.joinToString$default((Iterable)unknownIssueIds, null, null, null, (int)0, null, null, (int)63, null)});
                errorMessage = errorMessage + "<br/>";
            }
            if (!(object = (Collection)issuesWithoutPermissions).isEmpty()) {
                errorMessage = issuesWithoutPermissions.size() == 1 ? errorMessage + BeansKt.getLocalizer().localizedMsg("StateLessMessageSplitter.You_don_t_have_permissions_to_update_issue_{issue_id}", new Object[]{CollectionsKt.first((Iterable)issuesWithoutPermissions)}) : errorMessage + BeansKt.getLocalizer().localizedMsg("StateLessMessageSplitter.You_don_t_have_permissions_to_update_issues_{list_of_ids}", new Object[]{CollectionsKt.joinToString$default((Iterable)issuesWithoutPermissions, null, null, null, (int)0, null, null, (int)63, null)});
                errorMessage = errorMessage + "<br/>";
            }
            errorMessage = errorMessage + JabberMessageListener.Companion.getHelpMessage();
            return new IssuesAndCommand(errorMessage);
        }
        IssuesAndCommand result = new IssuesAndCommand((Sequence<? extends Entity>)CollectionsKt.asSequence((Iterable)issues), command);
        if (QueryOperations.count((Iterable)issues) == 1) {
            XdIssue xdIssue = new XdIssue((Entity)CollectionsKt.first((Iterable)issues));
            state.setLastNotificationIssue(xdIssue);
            state.setIssuesCameWithoutDelay(false);
            result.setAdditionalMessage(Companion.getIssueSavedToContextMessage(xdIssue.getIdReadable()));
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<Collection<String>, String> splitIssuesIdsAndCommands(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        String originalMessage = message;
        String messageWithSpaces = ' ' + message + ' ';
        Matcher matcher = ISSUE_LIST_PATTERN.matcher(messageWithSpaces);
        if (matcher.find()) {
            String string;
            void $receiver$iv;
            String commands;
            String issues = matcher.group();
            String string2 = messageWithSpaces;
            int n = issues.length();
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
            String string5 = string2 = string4;
            if (string5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            string2 = commands = ((Object)StringsKt.trim((CharSequence)string5)).toString();
            Pattern pattern = SINGLE_ISSUE_PATTERN;
            CharSequence $receiver$iv$iv = (CharSequence)$receiver$iv;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $receiver$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $receiver$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = it <= ' ';
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            if (pattern.matcher(string = ((Object)$receiver$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()).find()) {
                List list = CollectionsKt.emptyList();
                String string6 = originalMessage;
                List list2 = list;
                return new Pair((Object)list2, (Object)string6);
            }
            Object[] objectArray = StringUtils.split((String)issues, (String)SEPARATOR);
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"StringUtils.split(issues, SEPARATOR)");
            return new Pair((Object)ArraysKt.toList((Object[])objectArray), (Object)commands);
        }
        List list = CollectionsKt.emptyList();
        String string = originalMessage;
        List list3 = list;
        return new Pair((Object)list3, (Object)string);
    }

    static {
        Companion = new Companion(null);
        SEPARATOR = SEPARATOR;
        ISSUE_LIST_REGEXP = "^([" + SEPARATOR + "]+" + "[a-zA-Z0-9_]+\\-\\d+" + ")+[$" + SEPARATOR + "]+";
        ISSUE_LIST_PATTERN = Pattern.compile(ISSUE_LIST_REGEXP);
        SINGLE_ISSUE_PATTERN = Pattern.compile("^[a-zA-Z0-9_]+\\-\\d+");
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ljetbrains/youtrack/jabber/bot/StateLessMessageSplitter$Companion;", "", "()V", "ISSUE_LIST_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "ISSUE_LIST_REGEXP", "", "getISSUE_LIST_REGEXP", "()Ljava/lang/String;", "setISSUE_LIST_REGEXP", "(Ljava/lang/String;)V", "SEPARATOR", "SINGLE_ISSUE_PATTERN", "getIssueSavedToContextMessage", "issueId", "youtrack-jabber-bot"})
    public static final class Companion {
        @NotNull
        public final String getISSUE_LIST_REGEXP() {
            return ISSUE_LIST_REGEXP;
        }

        public final void setISSUE_LIST_REGEXP(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
            ISSUE_LIST_REGEXP = string;
        }

        @NotNull
        public final String getIssueSavedToContextMessage(@NotNull String issueId) {
            Intrinsics.checkParameterIsNotNull((Object)issueId, (String)"issueId");
            String string = BeansKt.getLocalizer().localizedMsg("StateLessMessageSplitter.You_can_omit_{issue_id}_in_the_following_commands", new Object[]{issueId});
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"localizer.localizedMsg(\"\u2026owing_commands\", issueId)");
            return string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

