/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hub.auth;

import com.intellij.hub.auth.oauth2.error.OAuthErrorCode;
import com.intellij.hub.core.Error;
import com.intellij.hub.core.URIHelper;
import java.net.URI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OAuthValidationException
extends Exception {
    @NotNull
    private final Error error;

    private OAuthValidationException(@NotNull Error error) {
        super(error.toString());
        this.error = error;
    }

    protected OAuthValidationException(@NotNull OAuthErrorCode code, @Nullable String description, @NotNull String docPrefix) {
        this(code.createError(description, URI.create(URIHelper.getHubDocsOAuthErrorURI(docPrefix, code.getASCIICode()))));
    }

    public final Error getError() {
        return this.error;
    }
}

