/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hub.auth.oauth2.error;

import com.intellij.hub.auth.oauth2.error.OAuthError;
import com.intellij.hub.auth.oauth2.error.OAuthErrorCode;
import com.intellij.hub.core.Error;
import java.net.URI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum OAuthAuthErrorCode implements OAuthErrorCode
{
    INVALID_REQUEST(400, "invalid_request"),
    UNAUTHORIZED_CLIENT(400, "unauthorized_client", "The client is not authorized to request an authorization entity using this method"),
    INVALID_REDIRECT_URI(400, "invalid_redirect_uri"),
    ACCESS_DENIED(403, "access_denied", "The resource owner or authorization server denied the request"),
    UNSUPPORTED_RESPONSE_TYPE(400, "unsupported_response_type", "The authorization server does not support obtaining an authorization entity using this method"),
    INVALID_SCOPE(400, "invalid_scope"),
    SERVER_ERROR(500, "server_error", "Internal server error"),
    TEMPORARILY_UNAVAILABLE(503, "temporarily_unavailable"),
    LOGIN_REQUIRED(403, "login_required", "The user is required to be logged in"),
    REQUEST_NOT_SUPPORTED(400, "request_not_supported", "The request parameter not supported"),
    REQUEST_URI_NOT_SUPPORTED(400, "request_uri_not_supported", "The request_uri parameter not supported");

    private String asciiCode;
    private String description;
    private int statusCode;

    private OAuthAuthErrorCode(int statusCode, String asciiCode) {
        this(statusCode, asciiCode, null);
    }

    private OAuthAuthErrorCode(int statusCode, String asciiCode, String description) {
        this.asciiCode = asciiCode;
        this.description = description;
        this.statusCode = statusCode;
    }

    @Override
    public String getASCIICode() {
        return this.asciiCode;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    @NotNull
    public Error createError() {
        return this.createError(null, null, null);
    }

    @Override
    @NotNull
    public Error createError(@Nullable String description) {
        return this.createError(description, null, null);
    }

    @Override
    @NotNull
    public Error createError(@Nullable String description, @Nullable URI errorUri) {
        return this.createError(description, null, errorUri);
    }

    @Override
    @NotNull
    public Error createError(@Nullable String description, @Nullable String devDescription, @Nullable URI errorUri) {
        return new OAuthError(this, description, devDescription, errorUri);
    }
}

