/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hub.auth.oauth2.error;

import com.intellij.hub.auth.oauth2.error.OAuthError;
import com.intellij.hub.auth.oauth2.error.OAuthErrorCode;
import com.intellij.hub.core.Error;
import java.net.URI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum OAuthTokenErrorCode implements OAuthErrorCode
{
    INVALID_REQUEST(400, "invalid_request"),
    INVALID_CLIENT(401, "invalid_client"),
    INVALID_GRANT(403, "invalid_grant", "Token is invalid, expired, revoked or was issued to another client"),
    UNAUTHORIZED_CLIENT(403, "unauthorized_client", "The authenticated client is not authorized to use this authorization grant type"),
    UNSUPPORTED_GRANT_TYPE(400, "unsupported_grant_type", "The authorization grant type is not supported by the authorization server"),
    INVALID_SCOPE(400, "invalid_scope"),
    BANNED_USER(403, "banned_user", "The owner of the refresh token is banned");

    private int statusCode;
    private String code;
    private String description;

    private OAuthTokenErrorCode(int statusCode, String code) {
        this.code = code;
        this.statusCode = statusCode;
    }

    private OAuthTokenErrorCode(int statusCode, String code, String description) {
        this(statusCode, code);
        this.description = description;
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public String getASCIICode() {
        return this.code;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public Error createError() {
        return this.createError(null, null, null);
    }

    @Override
    @NotNull
    public Error createError(@Nullable String description) {
        return this.createError(description, null, null);
    }

    @Override
    @NotNull
    public Error createError(@Nullable String description, @Nullable URI errorUri) {
        return this.createError(description, null, errorUri);
    }

    @Override
    @NotNull
    public Error createError(@Nullable String description, @Nullable String devDescription, @Nullable URI errorUri) {
        return new OAuthError(this, description, devDescription, errorUri);
    }
}

