/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hub.auth.oauth2.provider.source;

import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import javax.xml.bind.DatatypeConverter;
import org.jetbrains.annotations.NotNull;

public final class KeyAndVersion {
    private final DSAPublicKey key;
    private final int version;

    public KeyAndVersion(@NotNull DSAPublicKey key, int version) {
        this.key = key;
        this.version = version;
    }

    @NotNull
    public DSAPublicKey getKey() {
        return this.key;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyAndVersion that = (KeyAndVersion)o;
        return this.version == that.version && this.key.equals(that.key);
    }

    public int hashCode() {
        int result = this.key.hashCode();
        result = 31 * result + this.version;
        return result;
    }

    @NotNull
    public static KeyAndVersion parse(@NotNull String string) {
        int delimiter = string.indexOf(".");
        String version = string.substring(0, delimiter);
        String key = string.substring(delimiter + 1, string.length());
        try {
            KeyFactory kf = KeyFactory.getInstance("DSA");
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(DatatypeConverter.parseBase64Binary((String)key));
            return new KeyAndVersion((DSAPublicKey)kf.generatePublic(keySpec), Integer.valueOf(version));
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

