/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hub.auth.oauth2.token;

import com.intellij.hub.auth.AuthToken;
import com.intellij.hub.auth.InvalidTokenException;
import com.intellij.hub.auth.oauth2.token.AccessTokenData;
import java.util.Arrays;
import java.util.Date;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AccessToken
implements AuthToken {
    private static final String DATA_DELIMITER = ";";
    private static final String DELIMITER = ".";
    private final AccessTokenData data;
    private final int keyVersion;
    private final byte[] signature;

    public AccessToken(@NotNull AccessTokenData data, int keyVersion, @NotNull byte[] signature) {
        this.data = data;
        this.keyVersion = keyVersion;
        this.signature = signature;
    }

    @NotNull
    public Date getExpirationDate() {
        return this.data.getExpiration();
    }

    public int getTTLSeconds() {
        return this.data.getTTLSeconds();
    }

    @NotNull
    public String getClient() {
        return this.data.getClient();
    }

    @Deprecated
    @NotNull
    public String getTarget() {
        return this.getScope()[0];
    }

    @NotNull
    public String[] getScope() {
        return this.data.getScope();
    }

    @Nullable
    public String getUser() {
        return this.data.getUser();
    }

    @NotNull
    public AccessTokenData getData() {
        return this.data;
    }

    public int getKeyVersion() {
        return this.keyVersion;
    }

    @NotNull
    public byte[] getSignature() {
        return this.signature;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccessToken that = (AccessToken)o;
        return this.data.equals(that.data) && Arrays.equals(this.signature, that.signature);
    }

    public int hashCode() {
        int result = this.data.hashCode();
        result = 31 * result + Arrays.hashCode(this.signature);
        return result;
    }

    public String toString() {
        return String.format("%s{data=%s, signature=%s}", this.getClass().getSimpleName(), this.data, DatatypeConverter.printBase64Binary((byte[])this.signature));
    }

    @Override
    @NotNull
    public String encode() {
        return this.data.encode() + DATA_DELIMITER + this.encodeVersionAndSignature();
    }

    @NotNull
    private String encodeVersionAndSignature() {
        return this.keyVersion + DELIMITER + DatatypeConverter.printBase64Binary((byte[])this.signature);
    }

    @Override
    @NotNull
    public String getType() {
        return "Bearer";
    }

    @NotNull
    public static AccessToken decode(@NotNull String token) {
        byte[] signature;
        Integer version;
        String[] parts = token.split(Pattern.quote(DATA_DELIMITER));
        if (parts.length != 2) {
            throw InvalidTokenException.malformedOAuthToken();
        }
        String[] versionAndSignature = parts[1].split(Pattern.quote(DELIMITER));
        if (versionAndSignature.length != 2) {
            throw InvalidTokenException.malformedTokenSignature();
        }
        try {
            version = Integer.valueOf(versionAndSignature[0]);
        }
        catch (NumberFormatException e) {
            throw InvalidTokenException.malformedTokenVersion(e);
        }
        try {
            signature = DatatypeConverter.parseBase64Binary((String)versionAndSignature[1]);
        }
        catch (Exception e) {
            throw InvalidTokenException.malformedTokenSignature(e);
        }
        return new AccessToken(AccessTokenData.decode(parts[0]), version, signature);
    }

    @NotNull
    public static AccessToken decodeHeader(@NotNull String header) throws InvalidTokenException {
        if (!AccessToken.isBearer(header)) {
            throw InvalidTokenException.bearerAuthHeaderTypeExpected();
        }
        return AccessToken.decode(header.substring("Bearer ".length()));
    }

    @NotNull
    public static String encodeHeader(@NotNull AccessToken token) {
        return "Bearer " + token.encode();
    }

    public static boolean isBearer(@Nullable String header) {
        return header != null && header.startsWith("Bearer ");
    }
}

