/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hub.auth.oauth2.token;

import com.intellij.hub.auth.InvalidTokenException;
import com.intellij.hub.auth.oauth2.token.ScopeUtil;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Date;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AccessTokenData {
    private static final Charset DEFAULT_CHARSET = Charset.forName("utf-8");
    private static final String DELIMITER = ".";
    private final Date expiration;
    private final String client;
    private final String user;
    private final String idToken;
    private final String[] scope;
    private final int ttlSeconds;

    private AccessTokenData(@NotNull Date expiration, int timeToLiveSeconds, @NotNull String client, @Nullable String user, @Nullable String idToken, String ... scope2) {
        this.expiration = expiration;
        this.ttlSeconds = timeToLiveSeconds;
        this.client = client;
        this.user = user;
        this.idToken = idToken;
        this.scope = scope2;
    }

    public AccessTokenData(@NotNull Date expiration, @NotNull String client, @Nullable String user, @Nullable String idToken, @NotNull String[] target) {
        this(expiration, -1, client, user, idToken, target);
    }

    public AccessTokenData(int timeToLiveSeconds, @NotNull String client, @Nullable String user, @Nullable String idToken, @NotNull String[] target) {
        this(new Date(System.currentTimeMillis() + (long)(timeToLiveSeconds * 1000)), timeToLiveSeconds, client, user, idToken, target);
    }

    public AccessTokenData(@NotNull Date expiration, @NotNull String client, @Nullable String user, String ... target) {
        this(expiration, client, user, (String)null, target);
    }

    public AccessTokenData(int timeToLiveSeconds, @NotNull String client, @Nullable String user, String ... target) {
        this(timeToLiveSeconds, client, user, (String)null, target);
    }

    public int getTTLSeconds() {
        return this.ttlSeconds;
    }

    @NotNull
    public Date getExpiration() {
        return this.expiration;
    }

    @NotNull
    public String getClient() {
        return this.client;
    }

    @Nullable
    public String getUser() {
        return this.user;
    }

    @Nullable
    public String getIdToken() {
        return this.idToken;
    }

    @NotNull
    public String[] getScope() {
        return this.scope;
    }

    @NotNull
    public byte[] getBytes() {
        return this.encode().getBytes(DEFAULT_CHARSET);
    }

    @NotNull
    public String encode() {
        return this.expiration.getTime() + DELIMITER + this.client + DELIMITER + (this.user != null ? this.user : "") + DELIMITER + ScopeUtil.encodeScope(this.scope);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccessTokenData tokenData = (AccessTokenData)o;
        return this.client.equals(tokenData.client) && Arrays.equals(this.scope, tokenData.scope) && this.expiration.equals(tokenData.expiration);
    }

    public int hashCode() {
        int result = this.expiration.hashCode();
        result = 31 * result + this.client.hashCode();
        result = 31 * result + Arrays.hashCode(this.scope);
        return result;
    }

    public String toString() {
        return String.format("%s{expiration=%s, client=%s, user=%s, scope=%s}", this.getClass().getSimpleName(), this.expiration, this.client, this.user, Arrays.toString(this.scope));
    }

    @NotNull
    public static AccessTokenData decode(@NotNull String data) {
        long expiration;
        String[] parts = data.split(Pattern.quote(DELIMITER));
        if (parts.length != 4) {
            throw InvalidTokenException.malformedTokenData();
        }
        try {
            expiration = Long.parseLong(parts[0]);
        }
        catch (NumberFormatException e) {
            throw InvalidTokenException.malformedTokenExpiration(e);
        }
        return new AccessTokenData(new Date(expiration), parts[1], parts[2].isEmpty() ? null : parts[2], ScopeUtil.decodeScope(parts[3]));
    }
}

