/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hub.auth.request;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TokenFormParameter {
    public static final String GRANT_TYPE = "grant_type";
    public static final String SCOPE = "scope";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String CODE = "code";
    public static final String REDIRECT_URI = "redirect_uri";
    public static final String REFRESH_TOKEN = "refresh_token";
    public static final String CLIENT_ID = "client_id";
    public static final String CLIENT_SECRET = "client_secret";

    public static ParameterBuilder type(String grantType) {
        return new ParameterBuilder().append(GRANT_TYPE, grantType);
    }

    public static class ParameterBuilder {
        private Map<String, List<String>> params = new HashMap<String, List<String>>(2);

        private ParameterBuilder() {
        }

        private ParameterBuilder append(String key, String value) {
            this.params.put(key, Arrays.asList(value));
            return this;
        }

        public ParameterBuilder scope(String value) {
            List<String> scope2 = this.params.get(TokenFormParameter.SCOPE);
            if (scope2 != null) {
                scope2.add(value);
                return this;
            }
            return this.append(TokenFormParameter.SCOPE, value);
        }

        public Map<String, List<String>> build() {
            Map<String, List<String>> map = this.params;
            this.params = new HashMap<String, List<String>>(2);
            return map;
        }
    }
}

