/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.auth.module.oauth2.rest.client.json;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import jetbrains.jetpass.api.Alias;
import jetbrains.jetpass.api.authority.UserGroup;
import jetbrains.jetpass.auth.module.oauth2.rest.client.api.OAuth2AuthModule;
import jetbrains.jetpass.auth.module.rest.client.json.Externaloauth2moduleJSON;
import jetbrains.jetpass.rest.dto.AliasJSON;
import jetbrains.jetpass.rest.dto.UserGroupJSON;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="oauth2authmodule")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", defaultImpl=Oauth2authmoduleJSON.class)
public class Oauth2authmoduleJSON
extends Externaloauth2moduleJSON
implements OAuth2AuthModule {
    @XmlElement(name="scope")
    private String scope;
    @XmlElement(name="tokenUrl")
    private String tokenUrl;
    @XmlElement(name="formClientAuth")
    private Boolean formClientAuth;
    @XmlElement(name="userInfoUrl")
    private String userInfoUrl;
    @XmlElement(name="userIdPath")
    private String userIdPath;
    @XmlElement(name="userEmailUrl")
    private String userEmailUrl;
    @XmlElement(name="userEmailPath")
    private String userEmailPath;
    @XmlElement(name="userEmailVerifiedPath")
    private String userEmailVerifiedPath;
    @XmlElement(name="userNamePath")
    private String userNamePath;
    @XmlElement(name="userPictureIdPath")
    private String userPictureIdPath;
    @XmlElement(name="userPictureUrlPattern")
    private String userPictureUrlPattern;
    @XmlElement(name="emailVerifiedByDefault")
    private Boolean emailVerifiedByDefault;

    public Oauth2authmoduleJSON() {
    }

    public Oauth2authmoduleJSON(@NotNull OAuth2AuthModule that) {
        this.setId(that.getId());
        this.setAliasIds(that.getAliasIds());
        if (that.getAliases() != null) {
            ArrayList<AliasJSON> aggregated = new ArrayList<AliasJSON>();
            for (Alias alias : that.getAliases()) {
                aggregated.add(new AliasJSON(alias));
            }
            this.setAliases(aggregated);
        }
        this.setName(that.getName());
        this.setOrdinal(that.getOrdinal());
        this.setAccountsSize(that.getAccountsSize());
        this.setDisabled(that.isDisabled());
        if (that.getAutoJoinGroups() != null) {
            ArrayList<UserGroupJSON> references = new ArrayList<UserGroupJSON>();
            for (UserGroup userGroup : that.getAutoJoinGroups()) {
                UserGroupJSON ref = new UserGroupJSON();
                ref.setId(userGroup.getId());
                references.add(ref);
            }
            this.setAutoJoinGroups(references);
        }
        this.setServerUrl(that.getServerUrl());
        this.setConnectionTimeout(that.getConnectionTimeout());
        this.setReadTimeout(that.getReadTimeout());
        this.setAllowedCreateNewUsers(that.isAllowedCreateNewUsers());
        this.setClientId(that.getClientId());
        this.setClientSecret(that.getClientSecret());
        this.setRedirectUri(that.getRedirectUri());
        this.setIconUrl(that.getIconUrl());
        this.setScope(that.getScope());
        this.setTokenUrl(that.getTokenUrl());
        this.setFormClientAuth(that.isFormClientAuth());
        this.setUserInfoUrl(that.getUserInfoUrl());
        this.setUserIdPath(that.getUserIdPath());
        this.setUserEmailUrl(that.getUserEmailUrl());
        this.setUserEmailPath(that.getUserEmailPath());
        this.setUserEmailVerifiedPath(that.getUserEmailVerifiedPath());
        this.setUserNamePath(that.getUserNamePath());
        this.setUserPictureIdPath(that.getUserPictureIdPath());
        this.setUserPictureUrlPattern(that.getUserPictureUrlPattern());
        this.setEmailVerifiedByDefault(that.isEmailVerifiedByDefault());
    }

    @Override
    @Nullable
    public String getScope() {
        return this.scope;
    }

    @Override
    @Nullable
    public String getTokenUrl() {
        return this.tokenUrl;
    }

    @Override
    @Nullable
    public Boolean isFormClientAuth() {
        return this.formClientAuth;
    }

    @Override
    @Nullable
    public String getUserInfoUrl() {
        return this.userInfoUrl;
    }

    @Override
    @Nullable
    public String getUserIdPath() {
        return this.userIdPath;
    }

    @Override
    @Nullable
    public String getUserEmailUrl() {
        return this.userEmailUrl;
    }

    @Override
    @Nullable
    public String getUserEmailPath() {
        return this.userEmailPath;
    }

    @Override
    @Nullable
    public String getUserEmailVerifiedPath() {
        return this.userEmailVerifiedPath;
    }

    @Override
    @Nullable
    public String getUserNamePath() {
        return this.userNamePath;
    }

    @Override
    @Nullable
    public String getUserPictureIdPath() {
        return this.userPictureIdPath;
    }

    @Override
    @Nullable
    public String getUserPictureUrlPattern() {
        return this.userPictureUrlPattern;
    }

    @Override
    @Nullable
    public Boolean isEmailVerifiedByDefault() {
        return this.emailVerifiedByDefault;
    }

    @XmlTransient
    public void setScope(@Nullable String scope2) {
        this.scope = scope2;
    }

    @XmlTransient
    public void setTokenUrl(@Nullable String tokenUrl) {
        this.tokenUrl = tokenUrl;
    }

    @XmlTransient
    public void setFormClientAuth(@Nullable Boolean formClientAuth) {
        this.formClientAuth = formClientAuth;
    }

    @XmlTransient
    public void setUserInfoUrl(@Nullable String userInfoUrl) {
        this.userInfoUrl = userInfoUrl;
    }

    @XmlTransient
    public void setUserIdPath(@Nullable String userIdPath) {
        this.userIdPath = userIdPath;
    }

    @XmlTransient
    public void setUserEmailUrl(@Nullable String userEmailUrl) {
        this.userEmailUrl = userEmailUrl;
    }

    @XmlTransient
    public void setUserEmailPath(@Nullable String userEmailPath) {
        this.userEmailPath = userEmailPath;
    }

    @XmlTransient
    public void setUserEmailVerifiedPath(@Nullable String userEmailVerifiedPath) {
        this.userEmailVerifiedPath = userEmailVerifiedPath;
    }

    @XmlTransient
    public void setUserNamePath(@Nullable String userNamePath) {
        this.userNamePath = userNamePath;
    }

    @XmlTransient
    public void setUserPictureIdPath(@Nullable String userPictureIdPath) {
        this.userPictureIdPath = userPictureIdPath;
    }

    @XmlTransient
    public void setUserPictureUrlPattern(@Nullable String userPictureUrlPattern) {
        this.userPictureUrlPattern = userPictureUrlPattern;
    }

    @XmlTransient
    public void setEmailVerifiedByDefault(@Nullable Boolean emailVerifiedByDefault) {
        this.emailVerifiedByDefault = emailVerifiedByDefault;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OAuth2AuthModule)) {
            return false;
        }
        OAuth2AuthModule that = (OAuth2AuthModule)o;
        return this.getId() != null && this.getId().equals(that.getId());
    }

    @Override
    public int hashCode() {
        if (this.getId() == null) {
            return System.identityHashCode(this);
        }
        int result = 0;
        result = result * 31 + this.getId().hashCode();
        return result;
    }

    @NotNull
    public static Oauth2authmoduleJSON wrap(@NotNull OAuth2AuthModule that) {
        if (that instanceof Oauth2authmoduleJSON) {
            return (Oauth2authmoduleJSON)that;
        }
        return new Oauth2authmoduleJSON(that);
    }
}

