/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.auth.module.rest.client.json;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import jetbrains.jetpass.api.Alias;
import jetbrains.jetpass.api.authority.UserGroup;
import jetbrains.jetpass.auth.module.rest.client.api.ExternalAuthModule;
import jetbrains.jetpass.rest.dto.AliasJSON;
import jetbrains.jetpass.rest.dto.UserCreationAuthModuleJSON;
import jetbrains.jetpass.rest.dto.UserGroupJSON;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="externalauthmodule")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", defaultImpl=ExternalauthmoduleJSON.class)
public class ExternalauthmoduleJSON
extends UserCreationAuthModuleJSON
implements ExternalAuthModule {
    @XmlElement(name="serverUrl")
    private String serverUrl;
    @XmlElement(name="connectionTimeout")
    private Integer connectionTimeout;
    @XmlElement(name="readTimeout")
    private Integer readTimeout;

    public ExternalauthmoduleJSON() {
    }

    public ExternalauthmoduleJSON(@NotNull ExternalAuthModule that) {
        this.setId(that.getId());
        this.setAliasIds(that.getAliasIds());
        if (that.getAliases() != null) {
            ArrayList<AliasJSON> aggregated = new ArrayList<AliasJSON>();
            for (Alias alias : that.getAliases()) {
                aggregated.add(new AliasJSON(alias));
            }
            this.setAliases(aggregated);
        }
        this.setName(that.getName());
        this.setOrdinal(that.getOrdinal());
        this.setAccountsSize(that.getAccountsSize());
        this.setDisabled(that.isDisabled());
        if (that.getAutoJoinGroups() != null) {
            ArrayList<UserGroupJSON> references = new ArrayList<UserGroupJSON>();
            for (UserGroup userGroup : that.getAutoJoinGroups()) {
                UserGroupJSON ref = new UserGroupJSON();
                ref.setId(userGroup.getId());
                references.add(ref);
            }
            this.setAutoJoinGroups(references);
        }
        this.setServerUrl(that.getServerUrl());
        this.setConnectionTimeout(that.getConnectionTimeout());
        this.setReadTimeout(that.getReadTimeout());
        this.setAllowedCreateNewUsers(that.isAllowedCreateNewUsers());
    }

    @Override
    @Nullable
    public String getServerUrl() {
        return this.serverUrl;
    }

    @Override
    @Nullable
    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Override
    @Nullable
    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    @XmlTransient
    public void setServerUrl(@Nullable String serverUrl) {
        this.serverUrl = serverUrl;
    }

    @XmlTransient
    public void setConnectionTimeout(@Nullable Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    @XmlTransient
    public void setReadTimeout(@Nullable Integer readTimeout) {
        this.readTimeout = readTimeout;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExternalAuthModule)) {
            return false;
        }
        ExternalAuthModule that = (ExternalAuthModule)o;
        return this.getId() != null && this.getId().equals(that.getId());
    }

    @Override
    public int hashCode() {
        if (this.getId() == null) {
            return System.identityHashCode(this);
        }
        int result = 0;
        result = result * 31 + this.getId().hashCode();
        return result;
    }

    @NotNull
    public static ExternalauthmoduleJSON wrap(@NotNull ExternalAuthModule that) {
        if (that instanceof ExternalauthmoduleJSON) {
            return (ExternalauthmoduleJSON)that;
        }
        return new ExternalauthmoduleJSON(that);
    }
}

