/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.client;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class BaseField {
    public static final BaseField TOTAL = new BaseField("total");
    private String name;
    private List<BaseField> subFields;

    public BaseField(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    protected BaseField copy() {
        return new BaseField(this.getName());
    }

    public BaseField union(BaseField that) {
        if (this.subFields == null || this.subFields.isEmpty()) {
            return that;
        }
        if (that.subFields == null || that.subFields.isEmpty()) {
            return this;
        }
        BaseField newField = this.copy();
        LinkedHashMap<String, BaseField> thatSubFields = new LinkedHashMap<String, BaseField>();
        ArrayList<BaseField> newSubFields = new ArrayList<BaseField>();
        for (BaseField thatSubField : that.subFields) {
            thatSubFields.put(thatSubField.getName(), thatSubField);
        }
        for (BaseField thisSubField : this.subFields) {
            BaseField thatSubField = (BaseField)thatSubFields.remove(thisSubField.getName());
            if (thatSubField != null) {
                newSubFields.add(thisSubField.union(thatSubField));
                continue;
            }
            newSubFields.add(thisSubField);
        }
        for (BaseField thatSubField : thatSubFields.values()) {
            newSubFields.add(thatSubField);
        }
        return newField;
    }

    public void append(StringBuilder builder) {
        builder.append(this.name);
        if (this.subFields != null && !this.subFields.isEmpty()) {
            if (this.subFields.size() == 1) {
                builder.append('/');
                this.subFields.get(0).append(builder);
            } else {
                builder.append('(');
                for (int i = 0; i < this.subFields.size(); ++i) {
                    if (i > 0) {
                        builder.append(',');
                    }
                    this.subFields.get(i).append(builder);
                }
                builder.append(')');
            }
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.name.length());
        this.append(builder);
        return builder.toString();
    }

    protected <S extends BaseField> void setSubFields(S ... fields) {
        ArrayList<S> subFields = null;
        if (fields != null && fields.length > 0) {
            subFields = new ArrayList<S>(fields.length);
            for (S subField : fields) {
                subFields.add(subField);
            }
        }
        this.subFields = subFields;
    }
}

