/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.client.accounts;

import com.intellij.hub.auth.oauth2.consumer.TokenHolder;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import jetbrains.jetpass.client.BaseClient;
import jetbrains.jetpass.client.BaseFilter;
import jetbrains.jetpass.client.FieldPartial;
import jetbrains.jetpass.client.accounts.Partial;
import jetbrains.jetpass.rest.dto.CertificateJSON;
import jetbrains.jetpass.rest.dto.QueryAssistJSON;
import jetbrains.mps.webr.rpc.rest.json.common.runtime.BasePage;
import org.glassfish.jersey.uri.UriComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CertificateClient
extends BaseClient {
    public CertificateClient(@NotNull WebTarget rootResource) {
        this(rootResource, null);
    }

    public CertificateClient(@NotNull WebTarget rootResource, TokenHolder container) {
        super(rootResource.path("certificates"), container);
    }

    @NotNull
    public Page getCertificatePage(@Nullable BaseFilter filter2, @Nullable FieldPartial<Partial.Certificate> partial) {
        return (Page)this.prepare(this.apply(partial, filter2)).get(Page.class);
    }

    @NotNull
    public CertificateJSON createCertificate(@NotNull CertificateJSON entity, @Nullable FieldPartial<Partial.Certificate> partial) {
        return (CertificateJSON)this.prepare(this.apply(partial)).post(Entity.json((Object)entity), CertificateJSON.class);
    }

    @Nullable
    public CertificateJSON getCertificate(@NotNull String certificateId, @Nullable FieldPartial<Partial.Certificate> partial) {
        return this.get(null, certificateId, partial);
    }

    private CertificateJSON get(String byproperty, String key, @Nullable FieldPartial<Partial.Certificate> partial) {
        WebTarget resource = this.apply(partial);
        if (byproperty != null) {
            resource = resource.path(byproperty);
        }
        resource = resource.path(UriComponent.encode((String)key, (UriComponent.Type)UriComponent.Type.PATH_SEGMENT));
        try {
            return (CertificateJSON)this.prepare(resource).get(CertificateJSON.class);
        }
        catch (WebApplicationException ex) {
            if (ex.getResponse().getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
                return null;
            }
            throw ex;
        }
    }

    public void deleteCertificate(@NotNull String certificateId) {
        WebTarget path = this.path(certificateId);
        this.prepare(path).delete(String.class);
    }

    public void updateCertificate(@NotNull String certificateId, @NotNull CertificateJSON entity) {
        this.prepare(this.path(certificateId)).post(Entity.json((Object)entity), String.class);
    }

    public QueryAssistJSON queryAssist(@Nullable String query2, @Nullable Integer caret, @Nullable FieldPartial<Partial.QueryAssist> partial) {
        WebTarget resource;
        WebTarget r = resource = this.apply(partial);
        if (query2 != null) {
            r = r.queryParam("query", new Object[]{BaseClient.wrapObject(query2)});
        }
        if (caret != null) {
            r = r.queryParam("caret", new Object[]{BaseClient.wrapObject(caret)});
        }
        return (QueryAssistJSON)this.prepare(r.path("queryAssist")).method("GET", (GenericType)new GenericType<QueryAssistJSON>(){});
    }

    @NotNull
    public static Filter filter() {
        return new Filter();
    }

    public static class Filter
    extends BaseFilter<Filter> {
        private Filter() {
        }

        public Filter disabled(Boolean disabled) {
            this.add("disabled", disabled);
            return this;
        }
    }

    @XmlRootElement(name="page")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlSeeAlso(value={BasePage.class})
    public static class Page
    extends BasePage<CertificateJSON> {
        @XmlElement(name="certificates")
        private List<CertificateJSON> certificates;

        @NotNull
        public List<CertificateJSON> getCertificates() {
            return this.getItems();
        }

        @Override
        @NotNull
        public List<CertificateJSON> getItems() {
            return this.certificates != null ? this.certificates : new ArrayList(0);
        }
    }
}

