/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.client.accounts;

import com.intellij.hub.auth.oauth2.consumer.TokenHolder;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import jetbrains.jetpass.client.BaseClient;
import jetbrains.jetpass.client.BaseFilter;
import jetbrains.jetpass.client.FieldPartial;
import jetbrains.jetpass.client.accounts.Partial;
import jetbrains.jetpass.hub2hub.dto.ConflictJSON;
import jetbrains.jetpass.hub2hub.dto.CountersJSON;
import jetbrains.jetpass.hub2hub.dto.ImportJSON;
import jetbrains.jetpass.hub2hub.dto.ResolutionJSON;
import jetbrains.mps.webr.rpc.rest.json.common.runtime.BasePage;
import org.glassfish.jersey.uri.UriComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportClient
extends BaseClient {
    public ImportClient(@NotNull WebTarget rootResource) {
        this(rootResource, null);
    }

    public ImportClient(@NotNull WebTarget rootResource, TokenHolder container) {
        super(rootResource.path("imports"), container, true);
    }

    @NotNull
    public Page getImportPage(@Nullable BaseFilter filter2, @Nullable FieldPartial<Partial.Import> partial) {
        return (Page)this.prepare(this.apply(partial, filter2)).get(Page.class);
    }

    @Nullable
    public ImportJSON getImport(@NotNull String importId, @Nullable FieldPartial<Partial.Import> partial) {
        return this.get(null, importId, partial);
    }

    private ImportJSON get(String byproperty, String key, @Nullable FieldPartial<Partial.Import> partial) {
        WebTarget resource = this.apply(partial);
        if (byproperty != null) {
            resource = resource.path(byproperty);
        }
        resource = resource.path(UriComponent.encode((String)key, (UriComponent.Type)UriComponent.Type.PATH_SEGMENT));
        try {
            return (ImportJSON)this.prepare(resource).get(ImportJSON.class);
        }
        catch (WebApplicationException ex) {
            if (ex.getResponse().getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
                return null;
            }
            throw ex;
        }
    }

    public void deleteImport(@NotNull String importId) {
        WebTarget path = this.path(importId);
        this.prepare(path).delete(String.class);
    }

    public ImportJSON createImport(@Nullable String remoteUrl, @Nullable String adminConsoleUrl, @NotNull InputStream entity, @Nullable FieldPartial<Partial.Import> partial) {
        WebTarget resource;
        WebTarget r = resource = this.apply(partial);
        if (remoteUrl != null) {
            r = r.queryParam("remoteUrl", new Object[]{BaseClient.wrapObject(remoteUrl)});
        }
        if (adminConsoleUrl != null) {
            r = r.queryParam("adminConsoleUrl", new Object[]{BaseClient.wrapObject(adminConsoleUrl)});
        }
        return (ImportJSON)this.prepare(r.path("")).method("POST", Entity.json((Object)entity), (GenericType)new GenericType<ImportJSON>(){});
    }

    public CountersJSON counters(@NotNull String importId, @Nullable FieldPartial<Partial.Counters> partial) {
        WebTarget resource = this.apply(partial);
        WebTarget r = resource.path(importId);
        return (CountersJSON)this.prepare(r.path("counters")).method("GET", (GenericType)new GenericType<CountersJSON>(){});
    }

    public void merge(@NotNull String importId) {
        WebTarget resource = this.apply(null);
        WebTarget r = resource.path(importId);
        this.prepare(r.path("merge")).method("POST");
    }

    @NotNull
    public conflictClient getConflictsClient(@NotNull String importId) {
        return new conflictClient(this.path(importId), this.container);
    }

    @NotNull
    public static Filter filter() {
        return new Filter();
    }

    public static class conflictClient
    extends BaseClient {
        private conflictClient(WebTarget idResource, TokenHolder container) {
            super(idResource.path("conflicts"), container);
        }

        @NotNull
        public Page getconflictPage(@Nullable Filter filter2, @Nullable FieldPartial<Partial.Conflict> partial) {
            return (Page)this.prepare(this.apply(partial, filter2)).get(Page.class);
        }

        @NotNull
        public ConflictJSON getconflict(@NotNull String id, @Nullable FieldPartial<Partial.Conflict> partial) {
            return (ConflictJSON)this.prepare(this.apply(partial).path(id)).get(ConflictJSON.class);
        }

        public Response update(@NotNull String conflictId, @NotNull ResolutionJSON entity) {
            WebTarget resource = this.apply(null);
            WebTarget r = resource.path(conflictId);
            return (Response)this.prepare(r.path("update")).method("POST", Entity.json((Object)entity), (GenericType)new GenericType<Response>(){});
        }

        @NotNull
        public static Filter filter() {
            return new Filter();
        }

        public static class Filter
        extends BaseFilter<Filter> {
            private Filter() {
            }
        }

        @XmlRootElement(name="page")
        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlSeeAlso(value={BasePage.class})
        public static class Page
        extends BasePage<ConflictJSON> {
            @XmlElement(name="conflicts")
            private List<ConflictJSON> conflicts;

            @NotNull
            public List<ConflictJSON> getConflicts() {
                return this.getItems();
            }

            @Override
            @NotNull
            public List<ConflictJSON> getItems() {
                return this.conflicts != null ? this.conflicts : new ArrayList(0);
            }
        }
    }

    public static class Filter
    extends BaseFilter<Filter> {
        private Filter() {
        }
    }

    @XmlRootElement(name="page")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlSeeAlso(value={BasePage.class})
    public static class Page
    extends BasePage<ImportJSON> {
        @XmlElement(name="imports")
        private List<ImportJSON> imports;

        @NotNull
        public List<ImportJSON> getImports() {
            return this.getItems();
        }

        @Override
        @NotNull
        public List<ImportJSON> getItems() {
            return this.imports != null ? this.imports : new ArrayList(0);
        }
    }
}

