/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.client.accounts;

import com.intellij.hub.auth.oauth2.consumer.TokenHolder;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import jetbrains.jetpass.client.BaseClient;
import jetbrains.jetpass.client.BaseFilter;
import jetbrains.jetpass.client.FieldPartial;
import jetbrains.jetpass.client.accounts.Partial;
import jetbrains.jetpass.rest.dto.KeyStoreJSON;
import jetbrains.jetpass.rest.dto.QueryAssistJSON;
import jetbrains.mps.webr.rpc.rest.json.common.runtime.BasePage;
import org.glassfish.jersey.uri.UriComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeyStoreClient
extends BaseClient {
    public KeyStoreClient(@NotNull WebTarget rootResource) {
        this(rootResource, null);
    }

    public KeyStoreClient(@NotNull WebTarget rootResource, TokenHolder container) {
        super(rootResource.path("keystores"), container);
    }

    @NotNull
    public Page getKeyStorePage(@Nullable BaseFilter filter2, @Nullable FieldPartial<Partial.KeyStore> partial) {
        return (Page)this.prepare(this.apply(partial, filter2)).get(Page.class);
    }

    @NotNull
    public KeyStoreJSON createKeyStore(@NotNull KeyStoreJSON entity, @Nullable FieldPartial<Partial.KeyStore> partial) {
        return (KeyStoreJSON)this.prepare(this.apply(partial)).post(Entity.json((Object)entity), KeyStoreJSON.class);
    }

    @Nullable
    public KeyStoreJSON getKeyStore(@NotNull String keyStoreId, @Nullable FieldPartial<Partial.KeyStore> partial) {
        return this.get(null, keyStoreId, partial);
    }

    private KeyStoreJSON get(String byproperty, String key, @Nullable FieldPartial<Partial.KeyStore> partial) {
        WebTarget resource = this.apply(partial);
        if (byproperty != null) {
            resource = resource.path(byproperty);
        }
        resource = resource.path(UriComponent.encode((String)key, (UriComponent.Type)UriComponent.Type.PATH_SEGMENT));
        try {
            return (KeyStoreJSON)this.prepare(resource).get(KeyStoreJSON.class);
        }
        catch (WebApplicationException ex) {
            if (ex.getResponse().getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
                return null;
            }
            throw ex;
        }
    }

    public void deleteKeyStore(@NotNull String keyStoreId) {
        WebTarget path = this.path(keyStoreId);
        this.prepare(path).delete(String.class);
    }

    public void updateKeyStore(@NotNull String keyStoreId, @NotNull KeyStoreJSON entity) {
        this.prepare(this.path(keyStoreId)).post(Entity.json((Object)entity), String.class);
    }

    public QueryAssistJSON queryAssist(@Nullable String query2, @Nullable Integer caret, @Nullable FieldPartial<Partial.QueryAssist> partial) {
        WebTarget resource;
        WebTarget r = resource = this.apply(partial);
        if (query2 != null) {
            r = r.queryParam("query", new Object[]{BaseClient.wrapObject(query2)});
        }
        if (caret != null) {
            r = r.queryParam("caret", new Object[]{BaseClient.wrapObject(caret)});
        }
        return (QueryAssistJSON)this.prepare(r.path("queryAssist")).method("GET", (GenericType)new GenericType<QueryAssistJSON>(){});
    }

    @NotNull
    public static Filter filter() {
        return new Filter();
    }

    public static class Filter
    extends BaseFilter<Filter> {
        private Filter() {
        }
    }

    @XmlRootElement(name="page")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlSeeAlso(value={BasePage.class})
    public static class Page
    extends BasePage<KeyStoreJSON> {
        @XmlElement(name="keystores")
        private List<KeyStoreJSON> keystores;

        @NotNull
        public List<KeyStoreJSON> getKeystores() {
            return this.getItems();
        }

        @Override
        @NotNull
        public List<KeyStoreJSON> getItems() {
            return this.keystores != null ? this.keystores : new ArrayList(0);
        }
    }
}

