/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.client.accounts;

import com.intellij.hub.auth.oauth2.consumer.TokenHolder;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import jetbrains.jetpass.client.BaseClient;
import jetbrains.jetpass.client.BaseFilter;
import jetbrains.jetpass.client.FieldPartial;
import jetbrains.jetpass.client.accounts.Partial;
import jetbrains.jetpass.rest.dto.ProjectJSON;
import jetbrains.jetpass.rest.dto.ProjectRoleJSON;
import jetbrains.jetpass.rest.dto.QueryAssistJSON;
import jetbrains.jetpass.rest.dto.ResourceJSON;
import jetbrains.jetpass.rest.dto.TeamJSON;
import jetbrains.mps.webr.rpc.rest.json.common.runtime.BasePage;
import org.glassfish.jersey.uri.UriComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectClient
extends BaseClient {
    public ProjectClient(@NotNull WebTarget rootResource) {
        this(rootResource, null);
    }

    public ProjectClient(@NotNull WebTarget rootResource, TokenHolder container) {
        super(rootResource.path("projects"), container);
    }

    @NotNull
    public Page getProjectPage(@Nullable BaseFilter filter2, @Nullable FieldPartial<Partial.Project> partial) {
        return (Page)this.prepare(this.apply(partial, filter2)).get(Page.class);
    }

    @NotNull
    public ProjectJSON createProject(@NotNull ProjectJSON entity, @Nullable FieldPartial<Partial.Project> partial) {
        return (ProjectJSON)this.prepare(this.apply(partial)).post(Entity.json((Object)entity), ProjectJSON.class);
    }

    @Nullable
    public ProjectJSON getProject(@NotNull String projectId, @Nullable FieldPartial<Partial.Project> partial) {
        return this.get(null, projectId, partial);
    }

    private ProjectJSON get(String byproperty, String key, @Nullable FieldPartial<Partial.Project> partial) {
        WebTarget resource = this.apply(partial);
        if (byproperty != null) {
            resource = resource.path(byproperty);
        }
        resource = resource.path(UriComponent.encode((String)key, (UriComponent.Type)UriComponent.Type.PATH_SEGMENT));
        try {
            return (ProjectJSON)this.prepare(resource).get(ProjectJSON.class);
        }
        catch (WebApplicationException ex) {
            if (ex.getResponse().getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
                return null;
            }
            throw ex;
        }
    }

    public void deleteProject(@NotNull String projectId, @Nullable String successor) {
        WebTarget path = this.path(projectId);
        if (successor != null) {
            path = path.queryParam("successor", new Object[]{BaseClient.wrapObject(successor)});
        }
        this.prepare(path).delete(String.class);
    }

    public void updateProject(@NotNull String projectId, @NotNull ProjectJSON entity) {
        this.prepare(this.path(projectId)).post(Entity.json((Object)entity), String.class);
    }

    public QueryAssistJSON queryAssist(@Nullable String query2, @Nullable Integer caret, @Nullable FieldPartial<Partial.QueryAssist> partial) {
        WebTarget resource;
        WebTarget r = resource = this.apply(partial);
        if (query2 != null) {
            r = r.queryParam("query", new Object[]{BaseClient.wrapObject(query2)});
        }
        if (caret != null) {
            r = r.queryParam("caret", new Object[]{BaseClient.wrapObject(caret)});
        }
        return (QueryAssistJSON)this.prepare(r.path("queryAssist")).method("GET", (GenericType)new GenericType<QueryAssistJSON>(){});
    }

    public ProjectJSON global(@Nullable FieldPartial<Partial.Project> partial) {
        WebTarget resource;
        WebTarget r = resource = this.apply(partial);
        return (ProjectJSON)this.prepare(r.path("global")).method("GET", (GenericType)new GenericType<ProjectJSON>(){});
    }

    public ProjectJSON merge(@Nullable String key, @Nullable String name, @Nullable String description, @Nullable Boolean archived, @NotNull ProjectJSON[] entity, @Nullable FieldPartial<Partial.Project> partial) {
        WebTarget resource;
        WebTarget r = resource = this.apply(partial);
        if (key != null) {
            r = r.queryParam("key", new Object[]{BaseClient.wrapObject(key)});
        }
        if (name != null) {
            r = r.queryParam("name", new Object[]{BaseClient.wrapObject(name)});
        }
        if (description != null) {
            r = r.queryParam("description", new Object[]{BaseClient.wrapObject(description)});
        }
        if (archived != null) {
            r = r.queryParam("archived", new Object[]{BaseClient.wrapObject(archived)});
        }
        return (ProjectJSON)this.prepare(r.path("merge")).method("POST", Entity.json((Object)entity), (GenericType)new GenericType<ProjectJSON>(){});
    }

    public ProjectJSON merge(@Nullable String key, @Nullable String name, @Nullable String description, @Nullable Boolean archived, @Nullable String ownerId, @NotNull ProjectJSON[] entity, @Nullable FieldPartial<Partial.Project> partial) {
        WebTarget resource;
        WebTarget r = resource = this.apply(partial);
        if (key != null) {
            r = r.queryParam("key", new Object[]{BaseClient.wrapObject(key)});
        }
        if (name != null) {
            r = r.queryParam("name", new Object[]{BaseClient.wrapObject(name)});
        }
        if (description != null) {
            r = r.queryParam("description", new Object[]{BaseClient.wrapObject(description)});
        }
        if (archived != null) {
            r = r.queryParam("archived", new Object[]{BaseClient.wrapObject(archived)});
        }
        if (ownerId != null) {
            r = r.queryParam("owner", new Object[]{BaseClient.wrapObject(ownerId)});
        }
        return (ProjectJSON)this.prepare(r.path("merge")).method("POST", Entity.json((Object)entity), (GenericType)new GenericType<ProjectJSON>(){});
    }

    public void removeMember(@NotNull String projectId, @Nullable String memberId) {
        WebTarget resource = this.apply(null);
        WebTarget r = resource.path(projectId);
        if (memberId != null) {
            r = r.queryParam("memberId", new Object[]{BaseClient.wrapObject(memberId)});
        }
        this.prepare(r.path("removeMember")).method("POST");
    }

    @NotNull
    public ResourceClient getResourcesClient(@NotNull String projectId) {
        return new ResourceClient(this.path(projectId), this.container);
    }

    @NotNull
    public TeamClient getTeamsClient(@NotNull String projectId) {
        return new TeamClient(this.path(projectId), this.container);
    }

    @NotNull
    public TransitiveProjectRoleClient getTransitiveprojectrolesClient(@NotNull String projectId) {
        return new TransitiveProjectRoleClient(this.path(projectId), this.container);
    }

    @NotNull
    public static Filter filter() {
        return new Filter();
    }

    public static class TransitiveProjectRoleClient
    extends BaseClient {
        private TransitiveProjectRoleClient(WebTarget idResource, TokenHolder container) {
            super(idResource.path("transitiveprojectroles"), container);
        }

        @NotNull
        public Page getTransitiveProjectRolePage(@Nullable Filter filter2, @Nullable FieldPartial<Partial.ProjectRole> partial) {
            return (Page)this.prepare(this.apply(partial, filter2)).get(Page.class);
        }

        @NotNull
        public ProjectRoleJSON getTransitiveProjectRole(@NotNull String id, @Nullable FieldPartial<Partial.ProjectRole> partial) {
            return (ProjectRoleJSON)this.prepare(this.apply(partial).path(id)).get(ProjectRoleJSON.class);
        }

        @NotNull
        public static Filter filter() {
            return new Filter();
        }

        public static class Filter
        extends BaseFilter<Filter> {
            private Filter() {
            }
        }

        @XmlRootElement(name="page")
        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlSeeAlso(value={BasePage.class})
        public static class Page
        extends BasePage<ProjectRoleJSON> {
            @XmlElement(name="transitiveprojectroles")
            private List<ProjectRoleJSON> transitiveprojectroles;

            @NotNull
            public List<ProjectRoleJSON> getTransitiveprojectroles() {
                return this.getItems();
            }

            @Override
            @NotNull
            public List<ProjectRoleJSON> getItems() {
                return this.transitiveprojectroles != null ? this.transitiveprojectroles : new ArrayList(0);
            }
        }
    }

    public static class TeamClient
    extends BaseClient {
        private TeamClient(WebTarget idResource, TokenHolder container) {
            super(idResource.path("teams"), container);
        }

        @NotNull
        public Page getTeamPage(@Nullable Filter filter2, @Nullable FieldPartial<Partial.Team> partial) {
            return (Page)this.prepare(this.apply(partial, filter2)).get(Page.class);
        }

        @NotNull
        public TeamJSON addTeam(@NotNull TeamJSON entity, @Nullable FieldPartial<Partial.Team> partial) {
            return (TeamJSON)this.prepare(this.apply(partial)).post(Entity.json((Object)entity), TeamJSON.class);
        }

        @NotNull
        public TeamJSON getTeam(@NotNull String id, @Nullable FieldPartial<Partial.Team> partial) {
            return (TeamJSON)this.prepare(this.apply(partial).path(id)).get(TeamJSON.class);
        }

        public void removeTeam(@NotNull String id) {
            this.prepare(this.path(id)).delete(TeamJSON.class);
        }

        public TeamJSON whole(@Nullable FieldPartial<Partial.Team> partial) {
            WebTarget resource;
            WebTarget r = resource = this.apply(partial);
            return (TeamJSON)this.prepare(r.path("whole")).method("GET", (GenericType)new GenericType<TeamJSON>(){});
        }

        @NotNull
        public static Filter filter() {
            return new Filter();
        }

        public static class Filter
        extends BaseFilter<Filter> {
            private Filter() {
            }
        }

        @XmlRootElement(name="page")
        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlSeeAlso(value={BasePage.class})
        public static class Page
        extends BasePage<TeamJSON> {
            @XmlElement(name="teams")
            private List<TeamJSON> teams;

            @NotNull
            public List<TeamJSON> getTeams() {
                return this.getItems();
            }

            @Override
            @NotNull
            public List<TeamJSON> getItems() {
                return this.teams != null ? this.teams : new ArrayList(0);
            }
        }
    }

    public static class ResourceClient
    extends BaseClient {
        private ResourceClient(WebTarget idResource, TokenHolder container) {
            super(idResource.path("resources"), container);
        }

        @NotNull
        public Page getResourcePage(@Nullable Filter filter2, @Nullable FieldPartial<Partial.Resource> partial) {
            return (Page)this.prepare(this.apply(partial, filter2)).get(Page.class);
        }

        @NotNull
        public ResourceJSON addResource(@NotNull ResourceJSON entity, @Nullable FieldPartial<Partial.Resource> partial) {
            return (ResourceJSON)this.prepare(this.apply(partial)).post(Entity.json((Object)entity), ResourceJSON.class);
        }

        @NotNull
        public ResourceJSON getResource(@NotNull String id, @Nullable FieldPartial<Partial.Resource> partial) {
            return (ResourceJSON)this.prepare(this.apply(partial).path(id)).get(ResourceJSON.class);
        }

        public void removeResource(@NotNull String id) {
            this.prepare(this.path(id)).delete(ResourceJSON.class);
        }

        @NotNull
        public static Filter filter() {
            return new Filter();
        }

        public static class Filter
        extends BaseFilter<Filter> {
            private Filter() {
            }
        }

        @XmlRootElement(name="page")
        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlSeeAlso(value={BasePage.class})
        public static class Page
        extends BasePage<ResourceJSON> {
            @XmlElement(name="resources")
            private List<ResourceJSON> resources;

            @NotNull
            public List<ResourceJSON> getResources() {
                return this.getItems();
            }

            @Override
            @NotNull
            public List<ResourceJSON> getItems() {
                return this.resources != null ? this.resources : new ArrayList(0);
            }
        }
    }

    public static class Filter
    extends BaseFilter<Filter> {
        private Filter() {
        }

        public Filter archived(Boolean archived) {
            this.add("archived", archived);
            return this;
        }
    }

    @XmlRootElement(name="page")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlSeeAlso(value={BasePage.class})
    public static class Page
    extends BasePage<ProjectJSON> {
        @XmlElement(name="projects")
        private List<ProjectJSON> projects;

        @NotNull
        public List<ProjectJSON> getProjects() {
            return this.getItems();
        }

        @Override
        @NotNull
        public List<ProjectJSON> getItems() {
            return this.projects != null ? this.projects : new ArrayList(0);
        }
    }
}

