/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.client.accounts;

import com.intellij.hub.auth.oauth2.consumer.TokenHolder;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import jetbrains.jetpass.client.BaseClient;
import jetbrains.jetpass.client.BaseFilter;
import jetbrains.jetpass.client.FieldPartial;
import jetbrains.jetpass.client.accounts.Partial;
import jetbrains.jetpass.rest.dto.ApprovedScopeJSON;
import jetbrains.jetpass.rest.dto.DetailsJSON;
import jetbrains.jetpass.rest.dto.EndUserAgreementConsentJSON;
import jetbrains.jetpass.rest.dto.LicenseJSON;
import jetbrains.jetpass.rest.dto.PermanentTokenJSON;
import jetbrains.jetpass.rest.dto.ProfileJSON;
import jetbrains.jetpass.rest.dto.ProjectJSON;
import jetbrains.jetpass.rest.dto.ProjectRoleJSON;
import jetbrains.jetpass.rest.dto.QueryAssistJSON;
import jetbrains.jetpass.rest.dto.RefreshTokenJSON;
import jetbrains.jetpass.rest.dto.SshPublicKeyJSON;
import jetbrains.jetpass.rest.dto.UserGroupJSON;
import jetbrains.jetpass.rest.dto.UserJSON;
import jetbrains.mps.webr.rpc.rest.json.common.runtime.BasePage;
import org.glassfish.jersey.uri.UriComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UserClient
extends BaseClient {
    public UserClient(@NotNull WebTarget rootResource) {
        this(rootResource, null);
    }

    public UserClient(@NotNull WebTarget rootResource, TokenHolder container) {
        super(rootResource.path("users"), container);
    }

    @NotNull
    public Page getUserPage(@Nullable BaseFilter filter2, @Nullable FieldPartial<Partial.User> partial) {
        return (Page)this.prepare(this.apply(partial, filter2)).get(Page.class);
    }

    @NotNull
    public UserJSON createUser(@NotNull UserJSON entity, @Nullable FieldPartial<Partial.User> partial) {
        return (UserJSON)this.prepare(this.apply(partial)).post(Entity.json((Object)entity), UserJSON.class);
    }

    @Nullable
    public UserJSON getUser(@NotNull String userId, @Nullable FieldPartial<Partial.User> partial) {
        return this.get(null, userId, partial);
    }

    @Nullable
    public UserJSON getUserByName(@NotNull String name, @Nullable FieldPartial<Partial.User> partial) {
        return this.get("byname", name, partial);
    }

    private UserJSON get(String byproperty, String key, @Nullable FieldPartial<Partial.User> partial) {
        WebTarget resource = this.apply(partial);
        if (byproperty != null) {
            resource = resource.path(byproperty);
        }
        resource = resource.path(UriComponent.encode((String)key, (UriComponent.Type)UriComponent.Type.PATH_SEGMENT));
        try {
            return (UserJSON)this.prepare(resource).get(UserJSON.class);
        }
        catch (WebApplicationException ex) {
            if (ex.getResponse().getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
                return null;
            }
            throw ex;
        }
    }

    public void deleteUser(@NotNull String userId, @Nullable String successor) {
        WebTarget path = this.path(userId);
        if (successor != null) {
            path = path.queryParam("successor", new Object[]{BaseClient.wrapObject(successor)});
        }
        this.prepare(path).delete(String.class);
    }

    public void updateUser(@NotNull String userId, @NotNull UserJSON entity) {
        this.prepare(this.path(userId)).post(Entity.json((Object)entity), String.class);
    }

    public List<UserJSON> invite(@Nullable List<String> email, @Nullable String group, @Nullable String baseUrl, @Nullable FieldPartial<Partial.User> partial) {
        WebTarget r = this.apply(partial);
        if (email != null) {
            for (String pValue : email) {
                r = r.queryParam("email", new Object[]{BaseClient.wrapObject(pValue)});
            }
        }
        if (group != null) {
            r = r.queryParam("group", new Object[]{BaseClient.wrapObject(group)});
        }
        if (baseUrl != null) {
            r = r.queryParam("baseUrl", new Object[]{BaseClient.wrapObject(baseUrl)});
        }
        return (List)this.prepare(r.path("invite")).method("POST", (GenericType)new GenericType<List<UserJSON>>(){});
    }

    public UserJSON me(@Nullable FieldPartial<Partial.User> partial) {
        return (UserJSON)this.prepare(this.apply(partial).path("me")).method("GET", UserJSON.class);
    }

    public List<List<String>> getPersonalData() {
        return (List)this.prepare(this.resource.path("me").path("data")).get((GenericType)new GenericType<List<List<String>>>(){});
    }

    public UserJSON guest(@Nullable FieldPartial<Partial.User> partial) {
        return (UserJSON)this.prepare(this.apply(partial).path("guest")).method("GET", UserJSON.class);
    }

    public QueryAssistJSON queryAssist(@Nullable String query2, @Nullable Integer caret, @Nullable FieldPartial<Partial.QueryAssist> partial) {
        WebTarget r = this.apply(partial);
        if (query2 != null) {
            r = r.queryParam("query", new Object[]{BaseClient.wrapObject(query2)});
        }
        if (caret != null) {
            r = r.queryParam("caret", new Object[]{BaseClient.wrapObject(caret)});
        }
        return (QueryAssistJSON)this.prepare(r.path("queryAssist")).method("GET", QueryAssistJSON.class);
    }

    public UserJSON merge(@Nullable String login2, @Nullable String name, @Nullable String email, @Nullable String jabber, @Nullable Boolean banned, @NotNull UserJSON[] entity, @Nullable FieldPartial<Partial.User> partial) {
        WebTarget r = this.apply(partial);
        if (login2 != null) {
            r = r.queryParam("login", new Object[]{BaseClient.wrapObject(login2)});
        }
        if (name != null) {
            r = r.queryParam("name", new Object[]{BaseClient.wrapObject(name)});
        }
        if (email != null) {
            r = r.queryParam("email", new Object[]{BaseClient.wrapObject(email)});
        }
        if (jabber != null) {
            r = r.queryParam("jabber", new Object[]{BaseClient.wrapObject(jabber)});
        }
        if (banned != null) {
            r = r.queryParam("banned", new Object[]{BaseClient.wrapObject(banned)});
        }
        return (UserJSON)this.prepare(r.path("merge")).method("POST", Entity.json((Object)entity), UserJSON.class);
    }

    public ProfileJSON verifyContact(@NotNull String userId, @NotNull ProfileJSON entity, @Nullable FieldPartial<Partial.Profile> partial) {
        return (ProfileJSON)this.prepare(this.apply(partial).path(userId).path("verifyContact")).method("POST", Entity.json((Object)entity), ProfileJSON.class);
    }

    public void removeLocale(@NotNull String userId) {
        WebTarget resource = this.apply(null).path(userId).path("removeLocale");
        this.prepare(resource).method("POST");
    }

    public EndUserAgreementConsentJSON acceptEndUserAgreement(@Nullable FieldPartial<Partial.EndUserAgreementConsent> partial) {
        WebTarget resource = this.apply(partial);
        return (EndUserAgreementConsentJSON)this.prepare(resource.path("endUserAgreementConsent")).method("POST", Entity.json((Object)new EndUserAgreementConsentJSON()), EndUserAgreementConsentJSON.class);
    }

    @NotNull
    public UserDetailClient getUserdetailsClient(@NotNull String userId) {
        return new UserDetailClient(this.path(userId), this.container);
    }

    @NotNull
    public ProjectRoleClient getProjectrolesClient(@NotNull String userId) {
        return new ProjectRoleClient(this.path(userId), this.container);
    }

    @NotNull
    public TransitiveProjectRoleClient getTransitiveprojectrolesClient(@NotNull String userId) {
        return new TransitiveProjectRoleClient(this.path(userId), this.container);
    }

    @NotNull
    public GroupClient getGroupsClient(@NotNull String userId) {
        return new GroupClient(this.path(userId), this.container);
    }

    @NotNull
    public SshPublicKeyClient getSshpublickeysClient(@NotNull String userId) {
        return new SshPublicKeyClient(this.path(userId), this.container);
    }

    @NotNull
    public LicenseClient getLicensesClient(@NotNull String userId) {
        return new LicenseClient(this.path(userId), this.container);
    }

    @NotNull
    public RefreshTokenClient getRefreshtokensClient(@NotNull String userId) {
        return new RefreshTokenClient(this.path(userId), this.container);
    }

    @NotNull
    public PermanentTokenClient getPermanenttokensClient(@NotNull String userId) {
        return new PermanentTokenClient(this.path(userId), this.container);
    }

    @NotNull
    public ApprovedScopeClient getApprovedscopesClient(@NotNull String userId) {
        return new ApprovedScopeClient(this.path(userId), this.container);
    }

    @NotNull
    public FavoriteProjectClient getFavoriteprojectsClient(@NotNull String userId) {
        return new FavoriteProjectClient(this.path(userId), this.container);
    }

    @NotNull
    public static Filter filter() {
        return new Filter();
    }

    public static class FavoriteProjectClient
    extends BaseClient {
        private FavoriteProjectClient(WebTarget idResource, TokenHolder container) {
            super(idResource.path("favoriteprojects"), container);
        }

        @NotNull
        public Page getFavoriteProjectPage(@Nullable Filter filter2, @Nullable FieldPartial<Partial.Project> partial) {
            return (Page)this.prepare(this.apply(partial, filter2)).get(Page.class);
        }

        @NotNull
        public ProjectJSON addFavoriteProject(@NotNull ProjectJSON entity, @Nullable FieldPartial<Partial.Project> partial) {
            return (ProjectJSON)this.prepare(this.apply(partial)).post(Entity.json((Object)entity), ProjectJSON.class);
        }

        @NotNull
        public ProjectJSON getFavoriteProject(@NotNull String id, @Nullable FieldPartial<Partial.Project> partial) {
            return (ProjectJSON)this.prepare(this.apply(partial).path(id)).get(ProjectJSON.class);
        }

        public void removeFavoriteProject(@NotNull String id) {
            this.prepare(this.path(id)).delete(ProjectJSON.class);
        }

        @NotNull
        public static Filter filter() {
            return new Filter();
        }

        public static class Filter
        extends BaseFilter<Filter> {
            private Filter() {
            }
        }

        @XmlRootElement(name="page")
        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlSeeAlso(value={BasePage.class})
        public static class Page
        extends BasePage<ProjectJSON> {
            @XmlElement(name="favoriteprojects")
            private List<ProjectJSON> favoriteprojects;

            @NotNull
            public List<ProjectJSON> getFavoriteprojects() {
                return this.getItems();
            }

            @Override
            @NotNull
            public List<ProjectJSON> getItems() {
                return this.favoriteprojects != null ? this.favoriteprojects : new ArrayList(0);
            }
        }
    }

    public static class ApprovedScopeClient
    extends BaseClient {
        private ApprovedScopeClient(WebTarget idResource, TokenHolder container) {
            super(idResource.path("approvedscopes"), container);
        }

        @NotNull
        public Page getApprovedScopePage(@Nullable Filter filter2, @Nullable FieldPartial<Partial.ApprovedScope> partial) {
            return (Page)this.prepare(this.apply(partial, filter2)).get(Page.class);
        }

        @NotNull
        public ApprovedScopeJSON getApprovedScope(@NotNull String id, @Nullable FieldPartial<Partial.ApprovedScope> partial) {
            return (ApprovedScopeJSON)this.prepare(this.apply(partial).path(id)).get(ApprovedScopeJSON.class);
        }

        public void removeApprovedScope(@NotNull String id) {
            this.prepare(this.path(id)).delete(ApprovedScopeJSON.class);
        }

        @NotNull
        public static Filter filter() {
            return new Filter();
        }

        public static class Filter
        extends BaseFilter<Filter> {
            private Filter() {
            }
        }

        @XmlRootElement(name="page")
        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlSeeAlso(value={BasePage.class})
        public static class Page
        extends BasePage<ApprovedScopeJSON> {
            @XmlElement(name="approvedscopes")
            private List<ApprovedScopeJSON> approvedscopes;

            @NotNull
            public List<ApprovedScopeJSON> getApprovedscopes() {
                return this.getItems();
            }

            @Override
            @NotNull
            public List<ApprovedScopeJSON> getItems() {
                return this.approvedscopes != null ? this.approvedscopes : new ArrayList(0);
            }
        }
    }

    public static class PermanentTokenClient
    extends BaseClient {
        private PermanentTokenClient(WebTarget idResource, TokenHolder container) {
            super(idResource.path("permanenttokens"), container);
        }

        @NotNull
        public Page getPermanentTokenPage(@Nullable Filter filter2, @Nullable FieldPartial<Partial.PermanentToken> partial) {
            return (Page)this.prepare(this.apply(partial, filter2)).get(Page.class);
        }

        @NotNull
        public PermanentTokenJSON addPermanentToken(@NotNull PermanentTokenJSON entity, @Nullable FieldPartial<Partial.PermanentToken> partial) {
            return (PermanentTokenJSON)this.prepare(this.apply(partial)).post(Entity.json((Object)entity), PermanentTokenJSON.class);
        }

        @NotNull
        public PermanentTokenJSON getPermanentToken(@NotNull String id, @Nullable FieldPartial<Partial.PermanentToken> partial) {
            return (PermanentTokenJSON)this.prepare(this.apply(partial).path(id)).get(PermanentTokenJSON.class);
        }

        public void removePermanentToken(@NotNull String id) {
            this.prepare(this.path(id)).delete(PermanentTokenJSON.class);
        }

        @NotNull
        public static Filter filter() {
            return new Filter();
        }

        public static class Filter
        extends BaseFilter<Filter> {
            private Filter() {
            }
        }

        @XmlRootElement(name="page")
        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlSeeAlso(value={BasePage.class})
        public static class Page
        extends BasePage<PermanentTokenJSON> {
            @XmlElement(name="permanenttokens")
            private List<PermanentTokenJSON> permanenttokens;

            @NotNull
            public List<PermanentTokenJSON> getPermanenttokens() {
                return this.getItems();
            }

            @Override
            @NotNull
            public List<PermanentTokenJSON> getItems() {
                return this.permanenttokens != null ? this.permanenttokens : new ArrayList(0);
            }
        }
    }

    public static class RefreshTokenClient
    extends BaseClient {
        private RefreshTokenClient(WebTarget idResource, TokenHolder container) {
            super(idResource.path("refreshtokens"), container);
        }

        @NotNull
        public Page getRefreshTokenPage(@Nullable Filter filter2, @Nullable FieldPartial<Partial.RefreshToken> partial) {
            return (Page)this.prepare(this.apply(partial, filter2)).get(Page.class);
        }

        @NotNull
        public RefreshTokenJSON getRefreshToken(@NotNull String id, @Nullable FieldPartial<Partial.RefreshToken> partial) {
            return (RefreshTokenJSON)this.prepare(this.apply(partial).path(id)).get(RefreshTokenJSON.class);
        }

        public void removeRefreshToken(@NotNull String id) {
            this.prepare(this.path(id)).delete(RefreshTokenJSON.class);
        }

        @NotNull
        public static Filter filter() {
            return new Filter();
        }

        public static class Filter
        extends BaseFilter<Filter> {
            private Filter() {
            }
        }

        @XmlRootElement(name="page")
        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlSeeAlso(value={BasePage.class})
        public static class Page
        extends BasePage<RefreshTokenJSON> {
            @XmlElement(name="refreshtokens")
            private List<RefreshTokenJSON> refreshtokens;

            @NotNull
            public List<RefreshTokenJSON> getRefreshtokens() {
                return this.getItems();
            }

            @Override
            @NotNull
            public List<RefreshTokenJSON> getItems() {
                return this.refreshtokens != null ? this.refreshtokens : new ArrayList(0);
            }
        }
    }

    public static class LicenseClient
    extends BaseClient {
        private LicenseClient(WebTarget idResource, TokenHolder container) {
            super(idResource.path("licenses"), container);
        }

        @NotNull
        public Page getLicensePage(@Nullable Filter filter2, @Nullable FieldPartial<Partial.License> partial) {
            return (Page)this.prepare(this.apply(partial, filter2)).get(Page.class);
        }

        @NotNull
        public LicenseJSON addLicense(@NotNull LicenseJSON entity, @Nullable FieldPartial<Partial.License> partial) {
            return (LicenseJSON)this.prepare(this.apply(partial)).post(Entity.json((Object)entity), LicenseJSON.class);
        }

        @NotNull
        public LicenseJSON getLicense(@NotNull String id, @Nullable FieldPartial<Partial.License> partial) {
            return (LicenseJSON)this.prepare(this.apply(partial).path(id)).get(LicenseJSON.class);
        }

        public void removeLicense(@NotNull String id) {
            this.prepare(this.path(id)).delete(LicenseJSON.class);
        }

        @NotNull
        public static Filter filter() {
            return new Filter();
        }

        public static class Filter
        extends BaseFilter<Filter> {
            private Filter() {
            }
        }

        @XmlRootElement(name="page")
        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlSeeAlso(value={BasePage.class})
        public static class Page
        extends BasePage<LicenseJSON> {
            @XmlElement(name="licenses")
            private List<LicenseJSON> licenses;

            @NotNull
            public List<LicenseJSON> getLicenses() {
                return this.getItems();
            }

            @Override
            @NotNull
            public List<LicenseJSON> getItems() {
                return this.licenses != null ? this.licenses : new ArrayList(0);
            }
        }
    }

    public static class SshPublicKeyClient
    extends BaseClient {
        private SshPublicKeyClient(WebTarget idResource, TokenHolder container) {
            super(idResource.path("sshpublickeys"), container);
        }

        @NotNull
        public Page getSshPublicKeyPage(@Nullable Filter filter2, @Nullable FieldPartial<Partial.SshPublicKey> partial) {
            return (Page)this.prepare(this.apply(partial, filter2)).get(Page.class);
        }

        @NotNull
        public SshPublicKeyJSON addSshPublicKey(@NotNull SshPublicKeyJSON entity, @Nullable FieldPartial<Partial.SshPublicKey> partial) {
            return (SshPublicKeyJSON)this.prepare(this.apply(partial)).post(Entity.json((Object)entity), SshPublicKeyJSON.class);
        }

        @NotNull
        public SshPublicKeyJSON getSshPublicKey(@NotNull String id, @Nullable FieldPartial<Partial.SshPublicKey> partial) {
            return (SshPublicKeyJSON)this.prepare(this.apply(partial).path(id)).get(SshPublicKeyJSON.class);
        }

        public void removeSshPublicKey(@NotNull String id) {
            this.prepare(this.path(id)).delete(SshPublicKeyJSON.class);
        }

        @NotNull
        public static Filter filter() {
            return new Filter();
        }

        public static class Filter
        extends BaseFilter<Filter> {
            private Filter() {
            }
        }

        @XmlRootElement(name="page")
        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlSeeAlso(value={BasePage.class})
        public static class Page
        extends BasePage<SshPublicKeyJSON> {
            @XmlElement(name="sshpublickeys")
            private List<SshPublicKeyJSON> sshpublickeys;

            @NotNull
            public List<SshPublicKeyJSON> getSshpublickeys() {
                return this.getItems();
            }

            @Override
            @NotNull
            public List<SshPublicKeyJSON> getItems() {
                return this.sshpublickeys != null ? this.sshpublickeys : new ArrayList(0);
            }
        }
    }

    public static class GroupClient
    extends BaseClient {
        private GroupClient(WebTarget idResource, TokenHolder container) {
            super(idResource.path("groups"), container);
        }

        @NotNull
        public Page getGroupPage(@Nullable Filter filter2, @Nullable FieldPartial<Partial.UserGroup> partial) {
            return (Page)this.prepare(this.apply(partial, filter2)).get(Page.class);
        }

        @NotNull
        public UserGroupJSON addGroup(@NotNull UserGroupJSON entity, @Nullable FieldPartial<Partial.UserGroup> partial) {
            return (UserGroupJSON)this.prepare(this.apply(partial)).post(Entity.json((Object)entity), UserGroupJSON.class);
        }

        @NotNull
        public UserGroupJSON getGroup(@NotNull String id, @Nullable FieldPartial<Partial.UserGroup> partial) {
            return (UserGroupJSON)this.prepare(this.apply(partial).path(id)).get(UserGroupJSON.class);
        }

        public void removeGroup(@NotNull String id) {
            this.prepare(this.path(id)).delete(UserGroupJSON.class);
        }

        @NotNull
        public static Filter filter() {
            return new Filter();
        }

        public static class Filter
        extends BaseFilter<Filter> {
            private Filter() {
            }
        }

        @XmlRootElement(name="page")
        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlSeeAlso(value={BasePage.class})
        public static class Page
        extends BasePage<UserGroupJSON> {
            @XmlElement(name="groups")
            private List<UserGroupJSON> groups;

            @NotNull
            public List<UserGroupJSON> getGroups() {
                return this.getItems();
            }

            @Override
            @NotNull
            public List<UserGroupJSON> getItems() {
                return this.groups != null ? this.groups : new ArrayList(0);
            }
        }
    }

    public static class TransitiveProjectRoleClient
    extends BaseClient {
        private TransitiveProjectRoleClient(WebTarget idResource, TokenHolder container) {
            super(idResource.path("transitiveprojectroles"), container);
        }

        @NotNull
        public Page getTransitiveProjectRolePage(@Nullable Filter filter2, @Nullable FieldPartial<Partial.ProjectRole> partial) {
            return (Page)this.prepare(this.apply(partial, filter2)).get(Page.class);
        }

        @NotNull
        public ProjectRoleJSON getTransitiveProjectRole(@NotNull String id, @Nullable FieldPartial<Partial.ProjectRole> partial) {
            return (ProjectRoleJSON)this.prepare(this.apply(partial).path(id)).get(ProjectRoleJSON.class);
        }

        @NotNull
        public static Filter filter() {
            return new Filter();
        }

        public static class Filter
        extends BaseFilter<Filter> {
            private Filter() {
            }
        }

        @XmlRootElement(name="page")
        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlSeeAlso(value={BasePage.class})
        public static class Page
        extends BasePage<ProjectRoleJSON> {
            @XmlElement(name="transitiveprojectroles")
            private List<ProjectRoleJSON> transitiveprojectroles;

            @NotNull
            public List<ProjectRoleJSON> getTransitiveprojectroles() {
                return this.getItems();
            }

            @Override
            @NotNull
            public List<ProjectRoleJSON> getItems() {
                return this.transitiveprojectroles != null ? this.transitiveprojectroles : new ArrayList(0);
            }
        }
    }

    public static class ProjectRoleClient
    extends BaseClient {
        private ProjectRoleClient(WebTarget idResource, TokenHolder container) {
            super(idResource.path("projectroles"), container);
        }

        @NotNull
        public Page getProjectRolePage(@Nullable Filter filter2, @Nullable FieldPartial<Partial.ProjectRole> partial) {
            return (Page)this.prepare(this.apply(partial, filter2)).get(Page.class);
        }

        @NotNull
        public ProjectRoleJSON addProjectRole(@NotNull ProjectRoleJSON entity, @Nullable FieldPartial<Partial.ProjectRole> partial) {
            return (ProjectRoleJSON)this.prepare(this.apply(partial)).post(Entity.json((Object)entity), ProjectRoleJSON.class);
        }

        @NotNull
        public ProjectRoleJSON getProjectRole(@NotNull String id, @Nullable FieldPartial<Partial.ProjectRole> partial) {
            return (ProjectRoleJSON)this.prepare(this.apply(partial).path(id)).get(ProjectRoleJSON.class);
        }

        public void removeProjectRole(@NotNull String id) {
            this.prepare(this.path(id)).delete(ProjectRoleJSON.class);
        }

        @NotNull
        public static Filter filter() {
            return new Filter();
        }

        public static class Filter
        extends BaseFilter<Filter> {
            private Filter() {
            }
        }

        @XmlRootElement(name="page")
        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlSeeAlso(value={BasePage.class})
        public static class Page
        extends BasePage<ProjectRoleJSON> {
            @XmlElement(name="projectroles")
            private List<ProjectRoleJSON> projectroles;

            @NotNull
            public List<ProjectRoleJSON> getProjectroles() {
                return this.getItems();
            }

            @Override
            @NotNull
            public List<ProjectRoleJSON> getItems() {
                return this.projectroles != null ? this.projectroles : new ArrayList(0);
            }
        }
    }

    public static class UserDetailClient
    extends BaseClient {
        private UserDetailClient(WebTarget idResource, TokenHolder container) {
            super(idResource.path("userdetails"), container);
        }

        @NotNull
        public Page getUserDetailPage(@Nullable Filter filter2, @Nullable FieldPartial<Partial.Details> partial) {
            return (Page)this.prepare(this.apply(partial, filter2)).get(Page.class);
        }

        @NotNull
        public DetailsJSON addUserDetail(@NotNull DetailsJSON entity, @Nullable FieldPartial<Partial.Details> partial) {
            return (DetailsJSON)this.prepare(this.apply(partial)).post(Entity.json((Object)entity), DetailsJSON.class);
        }

        @NotNull
        public DetailsJSON getUserDetail(@NotNull String id, @Nullable FieldPartial<Partial.Details> partial) {
            return (DetailsJSON)this.prepare(this.apply(partial).path(id)).get(DetailsJSON.class);
        }

        public void removeUserDetail(@NotNull String id) {
            this.prepare(this.path(id)).delete(DetailsJSON.class);
        }

        @NotNull
        public static Filter filter() {
            return new Filter();
        }

        public static class Filter
        extends BaseFilter<Filter> {
            private Filter() {
            }
        }

        @XmlRootElement(name="page")
        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlSeeAlso(value={BasePage.class})
        public static class Page
        extends BasePage<DetailsJSON> {
            @XmlElement(name="userdetails")
            private List<DetailsJSON> userdetails;

            @NotNull
            public List<DetailsJSON> getUserdetails() {
                return this.getItems();
            }

            @Override
            @NotNull
            public List<DetailsJSON> getItems() {
                return this.userdetails != null ? this.userdetails : new ArrayList(0);
            }
        }
    }

    public static class Filter
    extends BaseFilter<Filter> {
        private Filter() {
        }
    }

    @XmlRootElement(name="page")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlSeeAlso(value={BasePage.class})
    public static class Page
    extends BasePage<UserJSON> {
        @XmlElement(name="users")
        private List<UserJSON> users;

        @NotNull
        public List<UserJSON> getUsers() {
            return this.getItems();
        }

        @Override
        @NotNull
        public List<UserJSON> getItems() {
            return this.users != null ? this.users : new ArrayList(0);
        }
    }
}

