/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.client.accounts;

import com.intellij.hub.auth.oauth2.consumer.TokenHolder;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import jetbrains.jetpass.client.BaseClient;
import jetbrains.jetpass.client.BaseFilter;
import jetbrains.jetpass.client.FieldPartial;
import jetbrains.jetpass.client.accounts.Partial;
import jetbrains.jetpass.rest.dto.DetailsJSON;
import jetbrains.jetpass.rest.dto.QueryAssistJSON;
import jetbrains.mps.webr.rpc.rest.json.common.runtime.BasePage;
import org.glassfish.jersey.uri.UriComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UserDetailClient
extends BaseClient {
    public UserDetailClient(@NotNull WebTarget rootResource) {
        this(rootResource, null);
    }

    public UserDetailClient(@NotNull WebTarget rootResource, TokenHolder container) {
        super(rootResource.path("userdetails"), container);
    }

    @NotNull
    public Page getUserDetailPage(@Nullable BaseFilter filter2, @Nullable FieldPartial<Partial.Details> partial) {
        return (Page)this.prepare(this.apply(partial, filter2)).get(Page.class);
    }

    @NotNull
    public DetailsJSON createUserDetail(@NotNull DetailsJSON entity, @Nullable FieldPartial<Partial.Details> partial) {
        return (DetailsJSON)this.prepare(this.apply(partial)).post(Entity.json((Object)entity), DetailsJSON.class);
    }

    @Nullable
    public DetailsJSON getUserDetail(@NotNull String userDetailId, @Nullable FieldPartial<Partial.Details> partial) {
        return this.get(null, userDetailId, partial);
    }

    private DetailsJSON get(String byproperty, String key, @Nullable FieldPartial<Partial.Details> partial) {
        WebTarget resource = this.apply(partial);
        if (byproperty != null) {
            resource = resource.path(byproperty);
        }
        resource = resource.path(UriComponent.encode((String)key, (UriComponent.Type)UriComponent.Type.PATH_SEGMENT));
        try {
            return (DetailsJSON)this.prepare(resource).get(DetailsJSON.class);
        }
        catch (WebApplicationException ex) {
            if (ex.getResponse().getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
                return null;
            }
            throw ex;
        }
    }

    public void deleteUserDetail(@NotNull String userDetailId) {
        WebTarget path = this.path(userDetailId);
        this.prepare(path).delete(String.class);
    }

    public void updateUserDetail(@NotNull String userDetailId, @NotNull DetailsJSON entity) {
        this.prepare(this.path(userDetailId)).post(Entity.json((Object)entity), String.class);
    }

    public QueryAssistJSON queryAssist(@Nullable String query2, @Nullable Integer caret, @Nullable FieldPartial<Partial.QueryAssist> partial) {
        WebTarget resource;
        WebTarget r = resource = this.apply(partial);
        if (query2 != null) {
            r = r.queryParam("query", new Object[]{BaseClient.wrapObject(query2)});
        }
        if (caret != null) {
            r = r.queryParam("caret", new Object[]{BaseClient.wrapObject(caret)});
        }
        return (QueryAssistJSON)this.prepare(r.path("queryAssist")).method("GET", (GenericType)new GenericType<QueryAssistJSON>(){});
    }

    public void revoke(@NotNull String userDetailId) {
        WebTarget resource = this.apply(null);
        WebTarget r = resource.path(userDetailId);
        this.prepare(r.path("revoke")).method("POST");
    }

    @NotNull
    public static Filter filter() {
        return new Filter();
    }

    public static class Filter
    extends BaseFilter<Filter> {
        private Filter() {
        }
    }

    @XmlRootElement(name="page")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlSeeAlso(value={BasePage.class})
    public static class Page
    extends BasePage<DetailsJSON> {
        @XmlElement(name="userdetails")
        private List<DetailsJSON> userdetails;

        @NotNull
        public List<DetailsJSON> getUserdetails() {
            return this.getItems();
        }

        @Override
        @NotNull
        public List<DetailsJSON> getItems() {
            return this.userdetails != null ? this.userdetails : new ArrayList(0);
        }
    }
}

