/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.client.accounts;

import com.intellij.hub.auth.oauth2.consumer.TokenHolder;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import jetbrains.jetpass.client.BaseClient;
import jetbrains.jetpass.client.BaseFilter;
import jetbrains.jetpass.client.FieldPartial;
import jetbrains.jetpass.client.accounts.Partial;
import jetbrains.jetpass.rest.dto.ProjectRoleJSON;
import jetbrains.jetpass.rest.dto.QueryAssistJSON;
import jetbrains.jetpass.rest.dto.UserGroupJSON;
import jetbrains.jetpass.rest.dto.UserJSON;
import jetbrains.mps.webr.rpc.rest.json.common.runtime.BasePage;
import org.glassfish.jersey.uri.UriComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UserGroupClient
extends BaseClient {
    public UserGroupClient(@NotNull WebTarget rootResource) {
        this(rootResource, null);
    }

    public UserGroupClient(@NotNull WebTarget rootResource, TokenHolder container) {
        super(rootResource.path("usergroups"), container);
    }

    @NotNull
    public Page getUserGroupPage(@Nullable BaseFilter filter2, @Nullable FieldPartial<Partial.UserGroup> partial) {
        return (Page)this.prepare(this.apply(partial, filter2)).get(Page.class);
    }

    @NotNull
    public UserGroupJSON createUserGroup(@NotNull UserGroupJSON entity, @Nullable FieldPartial<Partial.UserGroup> partial) {
        return (UserGroupJSON)this.prepare(this.apply(partial)).post(Entity.json((Object)entity), UserGroupJSON.class);
    }

    @Nullable
    public UserGroupJSON getUserGroup(@NotNull String userGroupId, @Nullable FieldPartial<Partial.UserGroup> partial) {
        return this.get(null, userGroupId, partial);
    }

    @Nullable
    public UserGroupJSON getUserGroupByName(@NotNull String name, @Nullable FieldPartial<Partial.UserGroup> partial) {
        return this.get("byname", name, partial);
    }

    private UserGroupJSON get(String byproperty, String key, @Nullable FieldPartial<Partial.UserGroup> partial) {
        WebTarget resource = this.apply(partial);
        if (byproperty != null) {
            resource = resource.path(byproperty);
        }
        resource = resource.path(UriComponent.encode((String)key, (UriComponent.Type)UriComponent.Type.PATH_SEGMENT));
        try {
            return (UserGroupJSON)this.prepare(resource).get(UserGroupJSON.class);
        }
        catch (WebApplicationException ex) {
            if (ex.getResponse().getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
                return null;
            }
            throw ex;
        }
    }

    public void deleteUserGroup(@NotNull String userGroupId, @Nullable String successor) {
        WebTarget path = this.path(userGroupId);
        if (successor != null) {
            path = path.queryParam("successor", new Object[]{BaseClient.wrapObject(successor)});
        }
        this.prepare(path).delete(String.class);
    }

    public void updateUserGroup(@NotNull String userGroupId, @NotNull UserGroupJSON entity) {
        this.prepare(this.path(userGroupId)).post(Entity.json((Object)entity), String.class);
    }

    public QueryAssistJSON queryAssist(@Nullable String query2, @Nullable Integer caret, @Nullable FieldPartial<Partial.QueryAssist> partial) {
        WebTarget resource;
        WebTarget r = resource = this.apply(partial);
        if (query2 != null) {
            r = r.queryParam("query", new Object[]{BaseClient.wrapObject(query2)});
        }
        if (caret != null) {
            r = r.queryParam("caret", new Object[]{BaseClient.wrapObject(caret)});
        }
        return (QueryAssistJSON)this.prepare(r.path("queryAssist")).method("GET", (GenericType)new GenericType<QueryAssistJSON>(){});
    }

    public List<UserGroupJSON> forest(@Nullable FieldPartial<Partial.UserGroup> partial) {
        WebTarget resource;
        WebTarget r = resource = this.apply(partial);
        return (List)this.prepare(r.path("forest")).method("GET", (GenericType)new GenericType<List<UserGroupJSON>>(){});
    }

    public UserGroupJSON root(@Nullable FieldPartial<Partial.UserGroup> partial) {
        WebTarget resource;
        WebTarget r = resource = this.apply(partial);
        return (UserGroupJSON)this.prepare(r.path("root")).method("GET", (GenericType)new GenericType<UserGroupJSON>(){});
    }

    public UserGroupJSON merge(@Nullable String name, @Nullable String description, @Nullable Boolean authJoin, @Nullable String project, @Nullable String parentGroup, @NotNull UserGroupJSON[] entity, @Nullable FieldPartial<Partial.UserGroup> partial) {
        WebTarget resource;
        WebTarget r = resource = this.apply(partial);
        if (name != null) {
            r = r.queryParam("name", new Object[]{BaseClient.wrapObject(name)});
        }
        if (description != null) {
            r = r.queryParam("description", new Object[]{BaseClient.wrapObject(description)});
        }
        if (authJoin != null) {
            r = r.queryParam("authJoin", new Object[]{BaseClient.wrapObject(authJoin)});
        }
        if (project != null) {
            r = r.queryParam("project", new Object[]{BaseClient.wrapObject(project)});
        }
        if (parentGroup != null) {
            r = r.queryParam("parentGroup", new Object[]{BaseClient.wrapObject(parentGroup)});
        }
        return (UserGroupJSON)this.prepare(r.path("merge")).method("POST", Entity.json((Object)entity), (GenericType)new GenericType<UserGroupJSON>(){});
    }

    @NotNull
    public ProjectRoleClient getProjectrolesClient(@NotNull String userGroupId) {
        return new ProjectRoleClient(this.path(userGroupId), this.container);
    }

    @NotNull
    public TransitiveProjectRoleClient getTransitiveprojectrolesClient(@NotNull String userGroupId) {
        return new TransitiveProjectRoleClient(this.path(userGroupId), this.container);
    }

    @NotNull
    public SubgroupClient getSubgroupsClient(@NotNull String userGroupId) {
        return new SubgroupClient(this.path(userGroupId), this.container);
    }

    @NotNull
    public UserClient getUsersClient(@NotNull String userGroupId) {
        return new UserClient(this.path(userGroupId), this.container);
    }

    @NotNull
    public static Filter filter() {
        return new Filter();
    }

    public static class UserClient
    extends BaseClient {
        private UserClient(WebTarget idResource, TokenHolder container) {
            super(idResource.path("users"), container);
        }

        @NotNull
        public Page getUserPage(@Nullable Filter filter2, @Nullable FieldPartial<Partial.User> partial) {
            return (Page)this.prepare(this.apply(partial, filter2)).get(Page.class);
        }

        @NotNull
        public UserJSON addUser(@NotNull UserJSON entity, @Nullable FieldPartial<Partial.User> partial) {
            return (UserJSON)this.prepare(this.apply(partial)).post(Entity.json((Object)entity), UserJSON.class);
        }

        @NotNull
        public UserJSON getUser(@NotNull String id, @Nullable FieldPartial<Partial.User> partial) {
            return (UserJSON)this.prepare(this.apply(partial).path(id)).get(UserJSON.class);
        }

        public void removeUser(@NotNull String id) {
            this.prepare(this.path(id)).delete(UserJSON.class);
        }

        @NotNull
        public static Filter filter() {
            return new Filter();
        }

        public static class Filter
        extends BaseFilter<Filter> {
            private Filter() {
            }
        }

        @XmlRootElement(name="page")
        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlSeeAlso(value={BasePage.class})
        public static class Page
        extends BasePage<UserJSON> {
            @XmlElement(name="users")
            private List<UserJSON> users;

            @NotNull
            public List<UserJSON> getUsers() {
                return this.getItems();
            }

            @Override
            @NotNull
            public List<UserJSON> getItems() {
                return this.users != null ? this.users : new ArrayList(0);
            }
        }
    }

    public static class SubgroupClient
    extends BaseClient {
        private SubgroupClient(WebTarget idResource, TokenHolder container) {
            super(idResource.path("subgroups"), container);
        }

        @NotNull
        public Page getSubgroupPage(@Nullable Filter filter2, @Nullable FieldPartial<Partial.UserGroup> partial) {
            return (Page)this.prepare(this.apply(partial, filter2)).get(Page.class);
        }

        @NotNull
        public UserGroupJSON addSubgroup(@NotNull UserGroupJSON entity, @Nullable FieldPartial<Partial.UserGroup> partial) {
            return (UserGroupJSON)this.prepare(this.apply(partial)).post(Entity.json((Object)entity), UserGroupJSON.class);
        }

        @NotNull
        public UserGroupJSON getSubgroup(@NotNull String id, @Nullable FieldPartial<Partial.UserGroup> partial) {
            return (UserGroupJSON)this.prepare(this.apply(partial).path(id)).get(UserGroupJSON.class);
        }

        public void removeSubgroup(@NotNull String id) {
            this.prepare(this.path(id)).delete(UserGroupJSON.class);
        }

        @NotNull
        public static Filter filter() {
            return new Filter();
        }

        public static class Filter
        extends BaseFilter<Filter> {
            private Filter() {
            }
        }

        @XmlRootElement(name="page")
        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlSeeAlso(value={BasePage.class})
        public static class Page
        extends BasePage<UserGroupJSON> {
            @XmlElement(name="subgroups")
            private List<UserGroupJSON> subgroups;

            @NotNull
            public List<UserGroupJSON> getSubgroups() {
                return this.getItems();
            }

            @Override
            @NotNull
            public List<UserGroupJSON> getItems() {
                return this.subgroups != null ? this.subgroups : new ArrayList(0);
            }
        }
    }

    public static class TransitiveProjectRoleClient
    extends BaseClient {
        private TransitiveProjectRoleClient(WebTarget idResource, TokenHolder container) {
            super(idResource.path("transitiveprojectroles"), container);
        }

        @NotNull
        public Page getTransitiveProjectRolePage(@Nullable Filter filter2, @Nullable FieldPartial<Partial.ProjectRole> partial) {
            return (Page)this.prepare(this.apply(partial, filter2)).get(Page.class);
        }

        @NotNull
        public ProjectRoleJSON getTransitiveProjectRole(@NotNull String id, @Nullable FieldPartial<Partial.ProjectRole> partial) {
            return (ProjectRoleJSON)this.prepare(this.apply(partial).path(id)).get(ProjectRoleJSON.class);
        }

        @NotNull
        public static Filter filter() {
            return new Filter();
        }

        public static class Filter
        extends BaseFilter<Filter> {
            private Filter() {
            }
        }

        @XmlRootElement(name="page")
        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlSeeAlso(value={BasePage.class})
        public static class Page
        extends BasePage<ProjectRoleJSON> {
            @XmlElement(name="transitiveprojectroles")
            private List<ProjectRoleJSON> transitiveprojectroles;

            @NotNull
            public List<ProjectRoleJSON> getTransitiveprojectroles() {
                return this.getItems();
            }

            @Override
            @NotNull
            public List<ProjectRoleJSON> getItems() {
                return this.transitiveprojectroles != null ? this.transitiveprojectroles : new ArrayList(0);
            }
        }
    }

    public static class ProjectRoleClient
    extends BaseClient {
        private ProjectRoleClient(WebTarget idResource, TokenHolder container) {
            super(idResource.path("projectroles"), container);
        }

        @NotNull
        public Page getProjectRolePage(@Nullable Filter filter2, @Nullable FieldPartial<Partial.ProjectRole> partial) {
            return (Page)this.prepare(this.apply(partial, filter2)).get(Page.class);
        }

        @NotNull
        public ProjectRoleJSON addProjectRole(@NotNull ProjectRoleJSON entity, @Nullable FieldPartial<Partial.ProjectRole> partial) {
            return (ProjectRoleJSON)this.prepare(this.apply(partial)).post(Entity.json((Object)entity), ProjectRoleJSON.class);
        }

        @NotNull
        public ProjectRoleJSON getProjectRole(@NotNull String id, @Nullable FieldPartial<Partial.ProjectRole> partial) {
            return (ProjectRoleJSON)this.prepare(this.apply(partial).path(id)).get(ProjectRoleJSON.class);
        }

        public void removeProjectRole(@NotNull String id) {
            this.prepare(this.path(id)).delete(ProjectRoleJSON.class);
        }

        @NotNull
        public static Filter filter() {
            return new Filter();
        }

        public static class Filter
        extends BaseFilter<Filter> {
            private Filter() {
            }
        }

        @XmlRootElement(name="page")
        @XmlAccessorType(value=XmlAccessType.FIELD)
        @XmlSeeAlso(value={BasePage.class})
        public static class Page
        extends BasePage<ProjectRoleJSON> {
            @XmlElement(name="projectroles")
            private List<ProjectRoleJSON> projectroles;

            @NotNull
            public List<ProjectRoleJSON> getProjectroles() {
                return this.getItems();
            }

            @Override
            @NotNull
            public List<ProjectRoleJSON> getItems() {
                return this.projectroles != null ? this.projectroles : new ArrayList(0);
            }
        }
    }

    public static class Filter
    extends BaseFilter<Filter> {
        private Filter() {
        }
    }

    @XmlRootElement(name="page")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlSeeAlso(value={BasePage.class})
    public static class Page
    extends BasePage<UserGroupJSON> {
        @XmlElement(name="usergroups")
        private List<UserGroupJSON> usergroups;

        @NotNull
        public List<UserGroupJSON> getUsergroups() {
            return this.getItems();
        }

        @Override
        @NotNull
        public List<UserGroupJSON> getItems() {
            return this.usergroups != null ? this.usergroups : new ArrayList(0);
        }
    }
}

