/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.client.accounts;

import com.intellij.hub.auth.oauth2.consumer.TokenHolder;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import jetbrains.jetpass.client.BaseClient;
import jetbrains.jetpass.client.BaseFilter;
import jetbrains.jetpass.client.FieldPartial;
import jetbrains.jetpass.client.accounts.Partial;
import jetbrains.jetpass.rest.dto.QueryAssistJSON;
import jetbrains.jetpass.rest.dto.WidgetJSON;
import jetbrains.mps.webr.rpc.rest.json.common.runtime.BasePage;
import org.glassfish.jersey.uri.UriComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WidgetClient
extends BaseClient {
    public WidgetClient(@NotNull WebTarget rootResource) {
        this(rootResource, null);
    }

    public WidgetClient(@NotNull WebTarget rootResource, TokenHolder container) {
        super(rootResource.path("widgets"), container);
    }

    @NotNull
    public Page getWidgetPage(@Nullable BaseFilter filter2, @Nullable FieldPartial<Partial.Widget> partial) {
        return (Page)this.prepare(this.apply(partial, filter2)).get(Page.class);
    }

    @NotNull
    public WidgetJSON createWidget(@NotNull WidgetJSON entity, @Nullable FieldPartial<Partial.Widget> partial) {
        return (WidgetJSON)this.prepare(this.apply(partial)).post(Entity.json((Object)entity), WidgetJSON.class);
    }

    @Nullable
    public WidgetJSON getWidget(@NotNull String widgetId, @Nullable FieldPartial<Partial.Widget> partial) {
        return this.get(null, widgetId, partial);
    }

    private WidgetJSON get(String byproperty, String key, @Nullable FieldPartial<Partial.Widget> partial) {
        WebTarget resource = this.apply(partial);
        if (byproperty != null) {
            resource = resource.path(byproperty);
        }
        resource = resource.path(UriComponent.encode((String)key, (UriComponent.Type)UriComponent.Type.PATH_SEGMENT));
        try {
            return (WidgetJSON)this.prepare(resource).get(WidgetJSON.class);
        }
        catch (WebApplicationException ex) {
            if (ex.getResponse().getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
                return null;
            }
            throw ex;
        }
    }

    public void deleteWidget(@NotNull String widgetId, @Nullable String successor) {
        WebTarget path = this.path(widgetId);
        if (successor != null) {
            path = path.queryParam("successor", new Object[]{BaseClient.wrapObject(successor)});
        }
        this.prepare(path).delete(String.class);
    }

    public void updateWidget(@NotNull String widgetId, @NotNull WidgetJSON entity) {
        this.prepare(this.path(widgetId)).post(Entity.json((Object)entity), String.class);
    }

    public QueryAssistJSON queryAssist(@Nullable String query2, @Nullable Integer caret, @Nullable FieldPartial<Partial.QueryAssist> partial) {
        WebTarget resource;
        WebTarget r = resource = this.apply(partial);
        if (query2 != null) {
            r = r.queryParam("query", new Object[]{BaseClient.wrapObject(query2)});
        }
        if (caret != null) {
            r = r.queryParam("caret", new Object[]{BaseClient.wrapObject(caret)});
        }
        return (QueryAssistJSON)this.prepare(r.path("queryAssist")).method("GET", (GenericType)new GenericType<QueryAssistJSON>(){});
    }

    public WidgetJSON previewArchive(@NotNull InputStream archive, @Nullable FieldPartial<Partial.Widget> partial) {
        WebTarget resource = this.apply(partial);
        return (WidgetJSON)this.prepare(resource.path("preview")).method("POST", Entity.entity((Object)archive, (MediaType)MediaType.valueOf((String)"application/zip")), WidgetJSON.class);
    }

    @NotNull
    public InputStream getArchive(@NotNull String widgetId) {
        WebTarget resource = this.resource;
        return (InputStream)this.prepare(resource.path(widgetId).path("archive")).accept(new String[]{"application/zip"}).method("GET", InputStream.class);
    }

    @NotNull
    public InputStream getFileFromArchive(@NotNull String widgetId, @NotNull String filePath) {
        WebTarget resource = this.resource;
        return (InputStream)this.prepare(resource.path(widgetId).path("archive").path(filePath)).method("GET", InputStream.class);
    }

    @NotNull
    public static Filter filter() {
        return new Filter();
    }

    public static class Filter
    extends BaseFilter<Filter> {
        private Filter() {
        }
    }

    @XmlRootElement(name="page")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlSeeAlso(value={BasePage.class})
    public static class Page
    extends BasePage<WidgetJSON> {
        @XmlElement(name="widgets")
        private List<WidgetJSON> widgets;

        @NotNull
        public List<WidgetJSON> getWidgets() {
            return this.getItems();
        }

        @Override
        @NotNull
        public List<WidgetJSON> getItems() {
            return this.widgets != null ? this.widgets : new ArrayList(0);
        }
    }
}

