/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.client.oauth2;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.hub.auth.basic.BasicAuthToken;
import com.intellij.hub.auth.oauth2.consumer.OAuth2TokenLoadException;
import com.intellij.hub.auth.oauth2.consumer.TokenLoader;
import com.intellij.hub.auth.request.Header;
import java.net.URI;
import java.util.Map;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import jetbrains.jetpass.client.oauth2.OAuth2Flow;
import jetbrains.jetpass.client.oauth2.SimpleTokenLoader$WhenMappings;
import jetbrains.jetpass.client.oauth2.token.OAuth2TokenFlow;
import jetbrains.jetpass.rest.dto.AccessTokenJSON;
import jetbrains.jetpass.rest.dto.ErrorJSON;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ljetbrains/jetpass/client/oauth2/SimpleTokenLoader;", "Lcom/intellij/hub/auth/oauth2/consumer/TokenLoader;", "tokenResource", "Ljavax/ws/rs/client/WebTarget;", "params", "Ljavax/ws/rs/core/MultivaluedMap;", "", "clientAuth", "Ljetbrains/jetpass/client/oauth2/token/OAuth2TokenFlow$ClientAuth;", "(Ljavax/ws/rs/client/WebTarget;Ljavax/ws/rs/core/MultivaluedMap;Ljetbrains/jetpass/client/oauth2/token/OAuth2TokenFlow$ClientAuth;)V", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "loadAccessToken", "Lcom/intellij/hub/auth/oauth2/consumer/TokenLoader$TokenData;", "auth", "Lcom/intellij/hub/auth/basic/BasicAuthToken;", "jetbrains.jetpass.client.oauth2"})
public final class SimpleTokenLoader
implements TokenLoader {
    private final ObjectMapper objectMapper;
    private final WebTarget tokenResource;
    private final MultivaluedMap<String, String> params;
    private final OAuth2TokenFlow.ClientAuth clientAuth;

    @Override
    @NotNull
    public TokenLoader.TokenData loadAccessToken(@NotNull BasicAuthToken auth) throws OAuth2TokenLoadException {
        AccessTokenJSON token;
        Intrinsics.checkParameterIsNotNull((Object)auth, (String)"auth");
        Invocation.Builder request = this.tokenResource.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        switch (SimpleTokenLoader$WhenMappings.$EnumSwitchMapping$0[this.clientAuth.ordinal()]) {
            case 1: {
                Header basicAuthHeader;
                Header header = basicAuthHeader = Header.authorization(auth);
                Intrinsics.checkExpressionValueIsNotNull((Object)header, (String)"basicAuthHeader");
                request.header(header.getName(), (Object)basicAuthHeader.getValue());
                break;
            }
            case 2: {
                this.params.putSingle((Object)"client_id", (Object)auth.getUsername());
                this.params.putSingle((Object)"client_secret", (Object)auth.getPassword());
            }
        }
        URI uRI = this.tokenResource.getUri();
        Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"tokenResource.uri");
        OAuth2Flow.Companion.logRequest(uRI, (Map)this.params);
        long now = System.currentTimeMillis();
        Response response = request.post(Entity.form(this.params));
        String body = (String)response.readEntity(String.class);
        int n = Response.Status.OK.getStatusCode();
        Response response2 = response;
        Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"response");
        if (n != response2.getStatus()) {
            ErrorJSON error;
            ErrorJSON errorJSON;
            try {
                errorJSON = (ErrorJSON)this.objectMapper.readValue(body, ErrorJSON.class);
            }
            catch (Exception e) {
                throw (Throwable)new OAuth2TokenLoadException("unknown_error", response.getStatus(), e.getMessage(), null, e);
            }
            ErrorJSON errorJSON2 = error = errorJSON;
            Intrinsics.checkExpressionValueIsNotNull((Object)errorJSON2, (String)"error");
            throw (Throwable)new OAuth2TokenLoadException(errorJSON2.getError(), response.getStatus(), error.getError_description(), error.getError_uri());
        }
        AccessTokenJSON accessTokenJSON = token = (AccessTokenJSON)this.objectMapper.readValue(body, AccessTokenJSON.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)accessTokenJSON, (String)"token");
        String string = accessTokenJSON.getAccess_token();
        String string2 = token.getRefresh_token();
        Integer n2 = token.getExpires_in();
        if (n2 == null) {
            n2 = 3600;
        }
        return new TokenLoader.TokenData(string, string2, (long)(n2 * 1000) + now);
    }

    public SimpleTokenLoader(@NotNull WebTarget tokenResource, @NotNull MultivaluedMap<String, String> params, @NotNull OAuth2TokenFlow.ClientAuth clientAuth) {
        ObjectMapper objectMapper;
        Intrinsics.checkParameterIsNotNull((Object)tokenResource, (String)"tokenResource");
        Intrinsics.checkParameterIsNotNull(params, (String)"params");
        Intrinsics.checkParameterIsNotNull((Object)((Object)clientAuth), (String)"clientAuth");
        this.tokenResource = tokenResource;
        this.params = params;
        this.clientAuth = clientAuth;
        ObjectMapper objectMapper2 = new ObjectMapper();
        SimpleTokenLoader simpleTokenLoader = this;
        ObjectMapper $receiver = objectMapper2;
        $receiver.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        simpleTokenLoader.objectMapper = objectMapper = objectMapper2;
    }
}

