/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.client.oauth2.token;

import com.intellij.hub.auth.oauth2.consumer.OAuth2TokenLoadException;
import com.intellij.hub.auth.oauth2.consumer.TokenLoader;
import com.intellij.hub.auth.oauth2.error.OAuthTokenErrorCode;
import java.net.URI;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import jetbrains.jetpass.client.oauth2.OAuth2Flow;
import jetbrains.jetpass.client.oauth2.token.OAuth2RefreshTokenFlow;
import jetbrains.jetpass.client.oauth2.token.OAuth2TokenFlow;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u0018B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0012H\u0014J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0006H\u0002J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0014H\u0014R\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00068\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019"}, d2={"Ljetbrains/jetpass/client/oauth2/token/OAuth2CodeResponseFlow;", "Ljetbrains/jetpass/client/oauth2/token/OAuth2TokenFlow;", "builder", "Ljetbrains/jetpass/client/oauth2/token/OAuth2CodeResponseFlow$Builder;", "(Ljetbrains/jetpass/client/oauth2/token/OAuth2CodeResponseFlow$Builder;)V", "_refreshToken", "", "code", "redirectUri", "Ljava/net/URI;", "refreshToken", "getRefreshToken", "()Ljava/lang/String;", "refreshTokenFlow", "Ljetbrains/jetpass/client/oauth2/token/OAuth2RefreshTokenFlow;", "getRefreshTokenFlow", "()Ljetbrains/jetpass/client/oauth2/token/OAuth2RefreshTokenFlow;", "buildParams", "Ljavax/ws/rs/core/MultivaluedHashMap;", "currentData", "Lcom/intellij/hub/auth/oauth2/consumer/TokenLoader$TokenData;", "token", "refresh", "data", "Builder", "jetbrains.jetpass.client.oauth2"})
public final class OAuth2CodeResponseFlow
extends OAuth2TokenFlow {
    private final String code;
    private final URI redirectUri;
    private volatile String _refreshToken;

    @Nullable
    public final OAuth2RefreshTokenFlow getRefreshTokenFlow() {
        return this.getRefreshTokenFlow(this.getRefreshToken());
    }

    @Nullable
    public final String getRefreshToken() {
        return this.getRefreshToken(this.getTokenData());
    }

    @NotNull
    protected MultivaluedHashMap<String, String> buildParams() {
        MultivaluedHashMap multivaluedHashMap;
        MultivaluedHashMap $receiver = multivaluedHashMap = new MultivaluedHashMap();
        OAuth2Flow.Companion.param$jetbrains_jetpass_client_oauth2((MultivaluedMap<String, String>)((MultivaluedMap)$receiver), "grant_type", "authorization_code");
        OAuth2Flow.Companion.param$jetbrains_jetpass_client_oauth2((MultivaluedMap<String, String>)((MultivaluedMap)$receiver), "code", this.code);
        URI uRI = this.redirectUri;
        OAuth2Flow.Companion.param$jetbrains_jetpass_client_oauth2((MultivaluedMap<String, String>)((MultivaluedMap)$receiver), "redirect_uri", uRI != null ? uRI.toASCIIString() : null);
        OAuth2Flow.Companion.scope$jetbrains_jetpass_client_oauth2((MultivaluedMap<String, String>)((MultivaluedMap)$receiver), "scope", this.getScope(), this.getEncodedScope());
        return multivaluedHashMap;
    }

    @Override
    @NotNull
    protected TokenLoader.TokenData refresh(@NotNull TokenLoader.TokenData data) {
        Object object;
        block5: {
            block4: {
                String string;
                String it;
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                object = data.getRefreshToken();
                if (object == null) break block4;
                this._refreshToken = it = (string = object);
                OAuth2RefreshTokenFlow oAuth2RefreshTokenFlow = this.getRefreshTokenFlow(it);
                if (oAuth2RefreshTokenFlow == null) {
                    Intrinsics.throwNpe();
                }
                if ((object = oAuth2RefreshTokenFlow.getTokenData()) != null) break block5;
            }
            throw (Throwable)new OAuth2TokenLoadException(OAuthTokenErrorCode.INVALID_GRANT.createError("Unable to refresh expired token"));
        }
        return object;
    }

    private final String getRefreshToken(TokenLoader.TokenData currentData) {
        String currentRefreshToken = this._refreshToken;
        if (currentRefreshToken == null && (currentRefreshToken = currentData.getRefreshToken()) != null) {
            this._refreshToken = currentRefreshToken;
        }
        return currentRefreshToken;
    }

    private final OAuth2RefreshTokenFlow getRefreshTokenFlow(String token) {
        return token != null ? ((OAuth2RefreshTokenFlow.Builder)this.appendSecret((OAuth2TokenFlow.Builder)new OAuth2RefreshTokenFlow.Builder(this.getClient(), this.getTokenURI()).clientId(this.getClientServiceId()))).token(token).build() : null;
    }

    private OAuth2CodeResponseFlow(Builder builder) {
        super(builder);
        this.code = builder.getCode$jetbrains_jetpass_client_oauth2();
        this.redirectUri = builder.getRedirectUri$jetbrains_jetpass_client_oauth2();
    }

    public /* synthetic */ OAuth2CodeResponseFlow(@NotNull Builder builder, DefaultConstructorMarker $constructor_marker) {
        this(builder);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0013\u001a\u00020\u0002H\u0016J\u0010\u0010\b\u001a\u00020\u00002\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u0010\u0010\u000e\u001a\u00020\u00002\b\u0010\u000e\u001a\u0004\u0018\u00010\u0006J\u0010\u0010\u000e\u001a\u00020\u00002\b\u0010\u000e\u001a\u0004\u0018\u00010\tR\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0014"}, d2={"Ljetbrains/jetpass/client/oauth2/token/OAuth2CodeResponseFlow$Builder;", "Ljetbrains/jetpass/client/oauth2/token/OAuth2TokenFlow$Builder;", "Ljetbrains/jetpass/client/oauth2/token/OAuth2CodeResponseFlow;", "client", "Ljavax/ws/rs/client/Client;", "tokenURI", "Ljava/net/URI;", "(Ljavax/ws/rs/client/Client;Ljava/net/URI;)V", "code", "", "getCode$jetbrains_jetpass_client_oauth2", "()Ljava/lang/String;", "setCode$jetbrains_jetpass_client_oauth2", "(Ljava/lang/String;)V", "redirectUri", "getRedirectUri$jetbrains_jetpass_client_oauth2", "()Ljava/net/URI;", "setRedirectUri$jetbrains_jetpass_client_oauth2", "(Ljava/net/URI;)V", "build", "jetbrains.jetpass.client.oauth2"})
    public static final class Builder
    extends OAuth2TokenFlow.Builder<Builder, OAuth2CodeResponseFlow> {
        @Nullable
        private String code;
        @Nullable
        private URI redirectUri;

        @Nullable
        public final String getCode$jetbrains_jetpass_client_oauth2() {
            return this.code;
        }

        public final void setCode$jetbrains_jetpass_client_oauth2(@Nullable String string) {
            this.code = string;
        }

        @Nullable
        public final URI getRedirectUri$jetbrains_jetpass_client_oauth2() {
            return this.redirectUri;
        }

        public final void setRedirectUri$jetbrains_jetpass_client_oauth2(@Nullable URI uRI) {
            this.redirectUri = uRI;
        }

        @NotNull
        public final Builder code(@Nullable String code) {
            Builder this_$iv;
            Builder builder = this_$iv = this;
            OAuth2Flow.Builder $receiver$iv = builder;
            this.code = code;
            Builder builder2 = builder;
            if (builder2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type T");
            }
            return (Builder)((OAuth2Flow.Builder)builder2);
        }

        @NotNull
        public final Builder redirectUri(@Nullable URI redirectUri) {
            Builder this_$iv;
            Builder builder = this_$iv = this;
            OAuth2Flow.Builder $receiver$iv = builder;
            this.redirectUri = redirectUri;
            Builder builder2 = builder;
            if (builder2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type T");
            }
            return (Builder)((OAuth2Flow.Builder)builder2);
        }

        @NotNull
        public final Builder redirectUri(@Nullable String redirectUri) {
            URI uRI;
            Builder this_$iv;
            Builder builder = this_$iv = this;
            OAuth2Flow.Builder $receiver$iv = builder;
            Builder builder2 = this;
            String string = redirectUri;
            if (string != null) {
                String string2 = string;
                Builder builder3 = builder2;
                String it = string2;
                URI uRI2 = URI.create(it);
                builder2 = builder3;
                uRI = uRI2;
            } else {
                uRI = null;
            }
            builder2.redirectUri = uRI;
            Builder builder4 = builder;
            if (builder4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type T");
            }
            return (Builder)((OAuth2Flow.Builder)builder4);
        }

        @Override
        @NotNull
        public OAuth2CodeResponseFlow build() {
            return new OAuth2CodeResponseFlow(this, null);
        }

        public Builder(@NotNull Client client, @NotNull URI tokenURI) {
            Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
            Intrinsics.checkParameterIsNotNull((Object)tokenURI, (String)"tokenURI");
            super(client, tokenURI);
        }
    }
}

