/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.client.resource;

import com.intellij.hub.core.Error;
import java.net.URI;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import jetbrains.jetpass.rest.dto.ErrorJSON;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0007\bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\t"}, d2={"Ljetbrains/jetpass/client/resource/ErrorHelper;", "", "()V", "readError", "Lcom/intellij/hub/core/Error;", "ex", "Ljavax/ws/rs/WebApplicationException;", "BasicAPIError", "JSONAPIError", "jetbrains.jetpass.client.accounts"})
public final class ErrorHelper {
    public static final ErrorHelper INSTANCE;

    @NotNull
    public final Error readError(@NotNull WebApplicationException ex) {
        Error error;
        Intrinsics.checkParameterIsNotNull((Object)((Object)ex), (String)"ex");
        Response response = ex.getResponse();
        try {
            ErrorJSON json;
            ErrorJSON errorJSON = json = (ErrorJSON)response.readEntity(ErrorJSON.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)errorJSON, (String)"json");
            error = new JSONAPIError(errorJSON);
        }
        catch (Throwable t) {
            Response response2 = response;
            Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"response");
            Response.StatusType statusType = response2.getStatusInfo();
            Intrinsics.checkExpressionValueIsNotNull((Object)statusType, (String)"response.statusInfo");
            String string = ex.getMessage();
            if (string == null) {
                String string2 = ((Object)((Object)ex)).getClass().getName();
                string = string2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"ex.javaClass.name");
            }
            error = new BasicAPIError(statusType, string);
        }
        return error;
    }

    private ErrorHelper() {
    }

    static {
        ErrorHelper errorHelper;
        INSTANCE = errorHelper = new ErrorHelper();
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\n\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010\t\u001a\u00020\u0005H\u0016J\n\u0010\n\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010\u000b\u001a\u00020\u0005H\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Ljetbrains/jetpass/client/resource/ErrorHelper$BasicAPIError;", "Lcom/intellij/hub/core/Error;", "type", "Ljavax/ws/rs/core/Response$StatusType;", "message", "", "(Ljavax/ws/rs/core/Response$StatusType;Ljava/lang/String;)V", "getDeveloperMessage", "", "getError", "getField", "getMessage", "getStatusCode", "", "getURI", "jetbrains.jetpass.client.accounts"})
    private static final class BasicAPIError
    implements Error {
        private final Response.StatusType type;
        private final String message;

        @Override
        @NotNull
        public String getError() {
            String string = this.type.getReasonPhrase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"type.reasonPhrase");
            return string;
        }

        @Override
        public int getStatusCode() {
            return this.type.getStatusCode();
        }

        @Override
        @NotNull
        public String getMessage() {
            return this.message;
        }

        @Nullable
        public Void getDeveloperMessage() {
            return null;
        }

        @Nullable
        public Void getURI() {
            return null;
        }

        @Nullable
        public Void getField() {
            return null;
        }

        public BasicAPIError(@NotNull Response.StatusType type, @NotNull String message) {
            Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            this.type = type;
            this.message = message;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\n\u0010\b\u001a\u0004\u0018\u00010\u0006H\u0016J\b\u0010\t\u001a\u00020\u0006H\u0016J\r\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\n\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Ljetbrains/jetpass/client/resource/ErrorHelper$JSONAPIError;", "Lcom/intellij/hub/core/Error;", "json", "Ljetbrains/jetpass/rest/dto/ErrorJSON;", "(Ljetbrains/jetpass/rest/dto/ErrorJSON;)V", "getDeveloperMessage", "", "getError", "getField", "getMessage", "getStatusCode", "", "()Ljava/lang/Integer;", "getURI", "Ljava/net/URI;", "jetbrains.jetpass.client.accounts"})
    private static final class JSONAPIError
    implements Error {
        private final ErrorJSON json;

        @Override
        @NotNull
        public String getError() {
            String string = this.json.getError();
            if (string == null) {
                string = "";
            }
            return string;
        }

        @NotNull
        public Integer getStatusCode() {
            Integer n = this.json.getError_code();
            if (n == null) {
                n = -1;
            }
            return n;
        }

        @Override
        @NotNull
        public String getMessage() {
            String string = this.json.getError_description();
            if (string == null) {
                string = "";
            }
            return string;
        }

        @Override
        @Nullable
        public String getDeveloperMessage() {
            return this.json.getError_developer_message();
        }

        @Override
        @Nullable
        public URI getURI() {
            URI uRI;
            String string = this.json.getError_uri();
            if (string != null) {
                String string2;
                String it = string2 = string;
                uRI = URI.create(it);
            } else {
                uRI = null;
            }
            return uRI;
        }

        @Override
        @Nullable
        public String getField() {
            return this.json.getError_field();
        }

        public JSONAPIError(@NotNull ErrorJSON json) {
            Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
            this.json = json;
        }
    }
}

