/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.dao.remote.api;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import jetbrains.jetpass.api.IdItem;
import jetbrains.jetpass.dao.remote.api.util.DataStore;
import jetbrains.jetpass.dao.remote.api.util.packed.PackedID;
import jetbrains.jetpass.sequence.impl.IterableSequence;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000 !*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001!B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0015\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0016\u001a\u00020\rH\u0096\u0002\u00a2\u0006\u0002\u0010\u0017J\u0014\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\rJ\u001e\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010 R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR*\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00028\u00000\fj\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00028\u0000`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\""}, d2={"Ljetbrains/jetpass/dao/remote/api/RemoteDataStore;", "I", "Ljetbrains/jetpass/api/IdItem;", "Ljetbrains/jetpass/dao/remote/api/util/DataStore;", "()V", "_version", "Ljava/util/concurrent/atomic/AtomicLong;", "allData", "Ljetbrains/jetpass/sequence/Sequence;", "getAllData", "()Ljetbrains/jetpass/sequence/Sequence;", "data", "Ljava/util/HashMap;", "Ljetbrains/jetpass/dao/remote/api/util/packed/PackedID;", "Lkotlin/collections/HashMap;", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "version", "", "getVersion", "()J", "get", "id", "(Ljetbrains/jetpass/dao/remote/api/util/packed/PackedID;)Ljetbrains/jetpass/api/IdItem;", "merge", "", "that", "remove", "", "itemId", "set", "item", "(Ljetbrains/jetpass/dao/remote/api/util/packed/PackedID;Ljetbrains/jetpass/api/IdItem;)Z", "Companion", "jetbrains.jetpass.dao.remote"})
public final class RemoteDataStore<I extends IdItem>
implements DataStore<I> {
    private final AtomicLong _version = new AtomicLong(0L);
    private final HashMap<PackedID, I> data;
    private final ReentrantReadWriteLock lock;
    public static final Companion Companion = new Companion(null);

    @Override
    public long getVersion() {
        return this._version.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final jetbrains.jetpass.sequence.Sequence<I> getAllData() {
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            long version = this.getVersion();
            Set<PackedID> set = this.data.keySet();
            Intrinsics.checkExpressionValueIsNotNull(set, (String)"data.keys");
            List copy = CollectionsKt.toList((Iterable)set);
            jetbrains.jetpass.sequence.Sequence sequence = new IterableSequence(SequencesKt.asIterable((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)copy), (Function1)new Function1<PackedID, I>(version, this){
                final /* synthetic */ long $version;
                final /* synthetic */ RemoteDataStore this$0;
                {
                    this.$version = l;
                    this.this$0 = remoteDataStore;
                    super(1);
                }

                @Nullable
                public final I invoke(@NotNull PackedID id) {
                    Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
                    if (this.this$0.getVersion() > this.$version) {
                        RemoteDataStore.Companion.getLogger().debug((Function0)new Function0<String>(id){
                            final /* synthetic */ PackedID $id;
                            {
                                this.$id = packedID;
                                super(0);
                            }

                            @NotNull
                            public final String invoke() {
                                return "Version changed for item with id: " + this.$id;
                            }
                        });
                    }
                    return (I)this.this$0.get(id);
                }
            })));
            return sequence;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public I get(@NotNull PackedID id) {
        IdItem idItem;
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        readLock.lock();
        try {
            idItem = (IdItem)this.data.get(id);
        }
        finally {
            readLock.unlock();
        }
        return (I)idItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean remove(@NotNull PackedID itemId) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)itemId, (String)"itemId");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n2 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        int n3 = 0;
        int n4 = n2 - 1;
        if (n3 <= n4) {
            do {
                n = ++n3;
                readLock.unlock();
            } while (n3 != n4);
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            int isRemoved;
            int n5 = isRemoved = this.data.remove(itemId) != null ? 1 : 0;
            if (isRemoved != 0) {
                this._version.incrementAndGet();
            }
            n4 = isRemoved;
        }
        finally {
            n = 0;
            int n6 = n2 - 1;
            if (n <= n6) {
                do {
                    int n7 = ++n;
                    readLock.lock();
                } while (n != n6);
            }
            writeLock.unlock();
        }
        return n4 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean set(@NotNull PackedID itemId, @NotNull I item2) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)itemId, (String)"itemId");
        Intrinsics.checkParameterIsNotNull(item2, (String)"item");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n2 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        int n3 = 0;
        int n4 = n2 - 1;
        if (n3 <= n4) {
            do {
                n = ++n3;
                readLock.unlock();
            } while (n3 != n4);
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            int isAdded;
            int n5 = isAdded = this.data.put(itemId, item2) != null ? 1 : 0;
            if (isAdded != 0) {
                this._version.incrementAndGet();
            }
            n4 = isAdded;
        }
        finally {
            n = 0;
            int n6 = n2 - 1;
            if (n <= n6) {
                do {
                    int n7 = ++n;
                    readLock.lock();
                } while (n != n6);
            }
            writeLock.unlock();
        }
        return n4 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void merge(@NotNull RemoteDataStore<I> that) {
        int n;
        Intrinsics.checkParameterIsNotNull(that, (String)"that");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n2 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        int n3 = 0;
        int n4 = n2 - 1;
        if (n3 <= n4) {
            do {
                n = ++n3;
                readLock.unlock();
            } while (n3 != n4);
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            int n5;
            ReentrantReadWriteLock reentrantReadWriteLock2 = that.lock;
            ReentrantReadWriteLock.ReadLock readLock2 = reentrantReadWriteLock2.readLock();
            int n6 = reentrantReadWriteLock2.getWriteHoldCount() == 0 ? reentrantReadWriteLock2.getReadHoldCount() : 0;
            int n7 = 0;
            int n8 = n6 - 1;
            if (n7 <= n8) {
                do {
                    n5 = ++n7;
                    readLock2.unlock();
                } while (n7 != n8);
            }
            ReentrantReadWriteLock.WriteLock writeLock2 = reentrantReadWriteLock2.writeLock();
            writeLock2.lock();
            try {
                this._version.incrementAndGet();
                this.data.clear();
                this.data.putAll((Map)that.data);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                n5 = 0;
                int n9 = n6 - 1;
                if (n5 <= n9) {
                    do {
                        int n10 = ++n5;
                        readLock2.lock();
                    } while (n5 != n9);
                }
                writeLock2.unlock();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            n = 0;
            int n11 = n2 - 1;
            if (n <= n11) {
                do {
                    int n12 = ++n;
                    readLock.lock();
                } while (n != n11);
            }
            writeLock.unlock();
        }
    }

    public RemoteDataStore() {
        RemoteDataStore remoteDataStore = this;
        HashMap hashMap = new HashMap();
        remoteDataStore.data = hashMap;
        this.lock = new ReentrantReadWriteLock();
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/jetpass/dao/remote/api/RemoteDataStore$Companion;", "Lmu/KLogging;", "()V", "jetbrains.jetpass.dao.remote"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

