/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.pojo.api.authority.profile;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoginUtils {
    private static final char[] SUBSTITUTION_TABLE;
    private static final char DEFAULT_SUBSTITUTION_CHAR = '_';
    private static final int ASCII_TABLE_SIZE = 128;
    private static final int LOGIN_MIN_LENGTH = 2;
    private static final int LOGIN_MAX_LENGTH = 40;
    private static final char DOT = '.';
    private static final String EMPTY_LOGIN_ERROR = "Empty";
    private static final Pattern INCREMENTED_LOGIN;

    @Nullable
    public static String getLoginFromEmail(String email) {
        if (email == null || email.length() == 0) {
            return null;
        }
        int indexOfAt = email.indexOf("@");
        return indexOfAt > 0 ? email.substring(0, indexOfAt) : null;
    }

    @NotNull
    public static String getBestMatchingLogin(String username, String firstName, String lastName) {
        if (username == null || username.length() == 0) {
            return null;
        }
        int indexOfAt = username.indexOf("@");
        return indexOfAt > 0 ? username.substring(0, indexOfAt) : null;
    }

    @Nullable
    public static String loginFromFirstLastName(@Nullable String firstName, @Nullable String lastName) {
        if (firstName == null || firstName.length() == 0) {
            return lastName;
        }
        if (lastName == null || lastName.length() == 0) {
            return firstName;
        }
        return firstName + "." + lastName;
    }

    public static boolean isValidLogin(@Nullable String login2) {
        if (login2 == null) {
            return false;
        }
        int sz = login2.length();
        if (sz < 2 || sz > 40) {
            return false;
        }
        for (int i = 0; i < sz; ++i) {
            char chr = login2.charAt(i);
            if (!(chr >= '\u0080' ? !Character.isLetterOrDigit(chr) : SUBSTITUTION_TABLE[chr] != chr)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static String getErrorReason(@Nullable String login2) {
        if (login2 == null || login2.length() == 0) {
            return EMPTY_LOGIN_ERROR;
        }
        int sz = login2.length();
        if (sz < 2 || sz > 40) {
            return sz < 2 ? "Too short" : "Too long";
        }
        for (int i = 0; i < sz; ++i) {
            char chr = login2.charAt(i);
            if (chr >= '\u0080') {
                if (Character.isLetterOrDigit(chr)) continue;
                return "Is not unicode letter or digit [" + chr + "]";
            }
            if (SUBSTITUTION_TABLE[chr] == chr) continue;
            return "Deprecated character [" + chr + "]";
        }
        return null;
    }

    @NotNull
    public static String generate() {
        return LoginUtils.generate("");
    }

    @NotNull
    public static String generate(@NotNull String prefix) {
        return LoginUtils.fix(prefix + Long.toHexString(Double.doubleToLongBits(Math.random())));
    }

    @Nullable
    public static String fix(@Nullable String login2) {
        if (login2 == null || login2.length() == 0) {
            return null;
        }
        int originalSize = login2.length();
        int resultSize = originalSize < 2 ? 2 : (originalSize > 40 ? 40 : originalSize);
        char[] buffer = new char[resultSize];
        for (int i = 0; i < resultSize; ++i) {
            int chr;
            chr = i >= originalSize ? 95 : ((chr = (int)login2.charAt(i)) >= 128 ? (Character.isLetterOrDigit((char)chr) ? chr : 95) : SUBSTITUTION_TABLE[chr]);
            buffer[i] = chr;
        }
        return new String(buffer);
    }

    public static String cutLoginCounter(@NotNull String login2) {
        Matcher matcher = INCREMENTED_LOGIN.matcher(login2);
        if (matcher.matches()) {
            login2 = matcher.group(1);
        }
        return login2;
    }

    @NotNull
    public static String increment(@NotNull String login2, int inc) {
        String suffix;
        int ext;
        if (inc < 0) {
            throw new IllegalArgumentException("Can't increment on negative value");
        }
        if (login2 == null || login2.length() == 0) {
            throw new IllegalArgumentException("Can't increment empty string");
        }
        int sz = (login2 = LoginUtils.cutLoginCounter(login2)).length();
        int resSz = sz + (ext = (suffix = Integer.toString(inc)).length() + 1);
        if (resSz > 40) {
            resSz = 40;
        } else if (resSz < 2) {
            resSz = 2;
        }
        int strLength = resSz - ext;
        char[] buffer = new char[strLength];
        for (int i = 0; i < strLength; ++i) {
            int chr = 95;
            if (i < sz) {
                chr = login2.charAt(i);
            }
            buffer[i] = chr;
        }
        return new StringBuilder(resSz).append(buffer).append('.').append(suffix).toString();
    }

    public static String tryStripFromUri(String uri) {
        if (uri == null || uri.length() == 0) {
            return uri;
        }
        try {
            int len = uri.length();
            StringBuilder res = new StringBuilder(len);
            URI u = new URI(uri.endsWith("/") ? uri.substring(0, len - 1) : uri).parseServerAuthority();
            boolean empty = false;
            if (LoginUtils.isNotEmpty_1yfm2c_a0e0c0k(u.getUserInfo())) {
                res.append(u.getUserInfo());
            } else if (LoginUtils.isNotEmpty_1yfm2c_a0a4a2a01(u.getHost())) {
                res.append(u.getHost());
            } else {
                empty = true;
            }
            if (LoginUtils.isNotEmpty_1yfm2c_a0f0c0k(u.getPath())) {
                empty = false;
                res.append(u.getPath());
            }
            if (!empty) {
                uri = res.toString();
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return uri;
    }

    public static boolean isNotEmpty_1yfm2c_a0e0c0k(String str) {
        return str != null && str.length() > 0;
    }

    public static boolean isNotEmpty_1yfm2c_a0a4a2a01(String str) {
        return str != null && str.length() > 0;
    }

    public static boolean isNotEmpty_1yfm2c_a0f0c0k(String str) {
        return str != null && str.length() > 0;
    }

    static {
        INCREMENTED_LOGIN = Pattern.compile("(.+)\\.\\d+");
        SUBSTITUTION_TABLE = new char[128];
        for (int i = 0; i < SUBSTITUTION_TABLE.length; ++i) {
            LoginUtils.SUBSTITUTION_TABLE[i] = (char)(Character.isLetterOrDigit(i) ? i : 95);
        }
        LoginUtils.SUBSTITUTION_TABLE[36] = 36;
        LoginUtils.SUBSTITUTION_TABLE[43] = 43;
        LoginUtils.SUBSTITUTION_TABLE[46] = 46;
        LoginUtils.SUBSTITUTION_TABLE[45] = 45;
        LoginUtils.SUBSTITUTION_TABLE[61] = 61;
        LoginUtils.SUBSTITUTION_TABLE[124] = 124;
        LoginUtils.SUBSTITUTION_TABLE[64] = 64;
        LoginUtils.SUBSTITUTION_TABLE[92] = 46;
        LoginUtils.SUBSTITUTION_TABLE[47] = 46;
        LoginUtils.SUBSTITUTION_TABLE[123] = 46;
        LoginUtils.SUBSTITUTION_TABLE[125] = 46;
        LoginUtils.SUBSTITUTION_TABLE[40] = 46;
        LoginUtils.SUBSTITUTION_TABLE[41] = 46;
    }
}

