/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.dto;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import jetbrains.jetpass.api.settings.BlockedAddress;
import jetbrains.jetpass.api.settings.BlockedAddresses;
import jetbrains.jetpass.rest.dto.BlockedAddressJSON;
import jetbrains.jetpass.rest.dto.utils.JsonUtils;
import org.jetbrains.annotations.NotNull;

@XmlRootElement(name="blockedAddresses")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class BlockedAddressesJSON
implements BlockedAddresses {
    @XmlElement(name="items")
    private List<BlockedAddressJSON> items;
    @XmlElement(name="timeUntilNextCooldown")
    private Long timeUntilNextCooldown;

    public BlockedAddressesJSON() {
    }

    public BlockedAddressesJSON(@NotNull BlockedAddresses that) {
        this.setTimeUntilNextCooldown(that.getTimeUntilNextCooldown());
        if (that.getItems() != null) {
            ArrayList<BlockedAddressJSON> items = new ArrayList<BlockedAddressJSON>();
            for (BlockedAddress blockedAddress : that.getItems()) {
                items.add(new BlockedAddressJSON(blockedAddress));
            }
            this.setItems(items);
        }
    }

    public Iterable<BlockedAddressJSON> getItems() {
        return this.items;
    }

    public void setItems(Iterable<BlockedAddressJSON> items) {
        this.items = JsonUtils.iterableToList(items);
    }

    @Override
    public Long getTimeUntilNextCooldown() {
        return this.timeUntilNextCooldown;
    }

    public void setTimeUntilNextCooldown(Long timeUntilNextCooldown) {
        this.timeUntilNextCooldown = timeUntilNextCooldown;
    }

    @NotNull
    public static BlockedAddressesJSON wrap(BlockedAddresses that) {
        if (that instanceof BlockedAddressesJSON) {
            return (BlockedAddressesJSON)that;
        }
        return new BlockedAddressesJSON(that);
    }
}

