/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.dto;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import jetbrains.jetpass.api.Alias;
import jetbrains.jetpass.api.settings.InternalSettings;
import jetbrains.jetpass.rest.dto.AliasJSON;
import jetbrains.jetpass.rest.dto.SettingsJSON;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="internalSettings")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonTypeName(value="internal")
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", defaultImpl=InternalSettingsJSON.class)
public class InternalSettingsJSON
extends SettingsJSON
implements InternalSettings {
    @XmlElement(name="sessionInterval")
    private Integer sessionInterval;
    @XmlElement(name="rememberMeInterval")
    private Integer rememberMeInterval;

    public InternalSettingsJSON() {
    }

    public InternalSettingsJSON(@NotNull InternalSettings that) {
        this.setId(that.getId());
        this.setAliasIds(that.getAliasIds());
        if (that.getAliases() != null) {
            ArrayList<AliasJSON> aggregated = new ArrayList<AliasJSON>();
            for (Alias alias : that.getAliases()) {
                aggregated.add(new AliasJSON(alias));
            }
            this.setAliases(aggregated);
        }
        this.setSessionInterval(that.getSessionInterval());
        this.setRememberMeInterval(that.getRememberMeInterval());
    }

    @Override
    @Nullable
    public Integer getSessionInterval() {
        return this.sessionInterval;
    }

    @Override
    @Nullable
    public Integer getRememberMeInterval() {
        return this.rememberMeInterval;
    }

    @XmlTransient
    public void setSessionInterval(@Nullable Integer sessionInterval) {
        this.sessionInterval = sessionInterval;
    }

    @XmlTransient
    public void setRememberMeInterval(@Nullable Integer rememberMeInterval) {
        this.rememberMeInterval = rememberMeInterval;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InternalSettings)) {
            return false;
        }
        InternalSettings that = (InternalSettings)o;
        return this.getId() != null && this.getId().equals(that.getId());
    }

    @Override
    public int hashCode() {
        if (this.getId() == null) {
            return System.identityHashCode(this);
        }
        int result = 0;
        result = result * 31 + this.getId().hashCode();
        return result;
    }

    @NotNull
    public static InternalSettingsJSON wrap(@NotNull InternalSettings that) {
        if (that instanceof InternalSettingsJSON) {
            return (InternalSettingsJSON)that;
        }
        return new InternalSettingsJSON(that);
    }
}

