/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.dto;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import jetbrains.jetpass.api.Alias;
import jetbrains.jetpass.api.settings.Migration;
import jetbrains.jetpass.rest.dto.AliasJSON;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="migrations")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class MigrationsJSON
implements Migration {
    @XmlElement(name="id")
    private String id;
    @XmlElement(name="aliasIds")
    private List<String> aliasIds;
    @XmlElement(name="aliases")
    private List<AliasJSON> aliases;
    @XmlElement(name="applied")
    private Boolean applied;

    public MigrationsJSON() {
    }

    public MigrationsJSON(@NotNull Migration that) {
        this.setId(that.getId());
        this.setAliasIds(that.getAliasIds());
        if (that.getAliases() != null) {
            ArrayList<AliasJSON> aggregated = new ArrayList<AliasJSON>();
            for (Alias alias : that.getAliases()) {
                aggregated.add(new AliasJSON(alias));
            }
            this.setAliases(aggregated);
        }
        this.setApplied(that.isApplied());
    }

    @Override
    @Nullable
    public String getId() {
        return this.id;
    }

    @Override
    @Nullable
    public Iterable<String> getAliasIds() {
        return this.aliasIds;
    }

    @Nullable
    public Iterable<AliasJSON> getAliases() {
        return this.aliases;
    }

    @Override
    @Nullable
    public Boolean isApplied() {
        return this.applied;
    }

    @XmlTransient
    public void setId(@Nullable String id) {
        this.id = id;
    }

    @XmlTransient
    public void setAliasIds(@Nullable Iterable<String> aliasIds) {
        this.aliasIds = new ArrayList<String>();
        if (aliasIds != null) {
            for (String it : aliasIds) {
                this.aliasIds.add(it);
            }
        }
    }

    @XmlTransient
    public void setAliases(@Nullable Iterable<AliasJSON> aliases) {
        this.aliases = new ArrayList<AliasJSON>();
        if (aliases != null) {
            for (AliasJSON it : aliases) {
                this.aliases.add(it);
            }
        }
    }

    @XmlTransient
    public void setApplied(@Nullable Boolean applied) {
        this.applied = applied;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Migration)) {
            return false;
        }
        Migration that = (Migration)o;
        return this.getId() != null && this.getId().equals(that.getId());
    }

    public int hashCode() {
        if (this.getId() == null) {
            return System.identityHashCode(this);
        }
        int result = 0;
        result = result * 31 + this.getId().hashCode();
        return result;
    }

    @NotNull
    public static MigrationsJSON wrap(@NotNull Migration that) {
        if (that instanceof MigrationsJSON) {
            return (MigrationsJSON)that;
        }
        return new MigrationsJSON(that);
    }
}

