/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.rest.dto;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import jetbrains.jetpass.api.Alias;
import jetbrains.jetpass.api.settings.ThrottlingSettings;
import jetbrains.jetpass.rest.dto.AliasJSON;
import jetbrains.jetpass.rest.dto.BlockedAddressesJSON;
import jetbrains.jetpass.rest.dto.SettingsJSON;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="throttlingSettings")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", defaultImpl=ThrottlingSettingsJSON.class)
public class ThrottlingSettingsJSON
extends SettingsJSON
implements ThrottlingSettings {
    @XmlElement(name="enabled")
    private Boolean enabled;
    @XmlElement(name="whiteList")
    private List<String> whiteList;
    @XmlElement(name="maxTrackingAddresses")
    private Integer maxTrackingAddresses;
    @XmlElement(name="maxFailuresPerAddress")
    private Integer maxFailuresPerAddress;
    @XmlElement(name="cooldownValue")
    private Integer cooldownValue;
    @XmlElement(name="cooldownPeriodSec")
    private Long cooldownPeriodSec;
    @XmlElement(name="suggestedAddress")
    private String suggestedAddress;
    @XmlElement(name="blockedAddresses")
    private BlockedAddressesJSON blockedAddresses;

    public ThrottlingSettingsJSON() {
    }

    public ThrottlingSettingsJSON(@NotNull ThrottlingSettings that) {
        this.setId(that.getId());
        this.setAliasIds(that.getAliasIds());
        if (that.getAliases() != null) {
            ArrayList<AliasJSON> aggregated = new ArrayList<AliasJSON>();
            for (Alias alias : that.getAliases()) {
                aggregated.add(new AliasJSON(alias));
            }
            this.setAliases(aggregated);
        }
        this.setEnabled(that.isEnabled());
        this.setWhiteList(that.getWhiteList());
        this.setMaxTrackingAddresses(that.getMaxTrackingAddresses());
        this.setMaxFailuresPerAddress(that.getMaxFailuresPerAddress());
        this.setCooldownValue(that.getCooldownValue());
        this.setCooldownPeriodSec(that.getCooldownPeriodSec());
        this.setSuggestedAddress(that.getSuggestedAddress());
        this.setBlockedAddresses(BlockedAddressesJSON.wrap(that.getBlockedAddresses()));
    }

    @Override
    @Nullable
    public Boolean isEnabled() {
        return this.enabled;
    }

    @Override
    @Nullable
    public Iterable<String> getWhiteList() {
        return this.whiteList;
    }

    @Override
    @Nullable
    public Integer getMaxTrackingAddresses() {
        return this.maxTrackingAddresses;
    }

    @Override
    @Nullable
    public Integer getMaxFailuresPerAddress() {
        return this.maxFailuresPerAddress;
    }

    @Override
    @Nullable
    public Integer getCooldownValue() {
        return this.cooldownValue;
    }

    @Override
    @Nullable
    public Long getCooldownPeriodSec() {
        return this.cooldownPeriodSec;
    }

    @Override
    @Nullable
    public String getSuggestedAddress() {
        return this.suggestedAddress;
    }

    @XmlTransient
    public void setEnabled(@Nullable Boolean enabled) {
        this.enabled = enabled;
    }

    @XmlTransient
    public void setWhiteList(@Nullable Iterable<String> whiteList) {
        this.whiteList = this.toList(whiteList);
    }

    @XmlTransient
    public void setMaxTrackingAddresses(@Nullable Integer maxTrackingAddresses) {
        this.maxTrackingAddresses = maxTrackingAddresses;
    }

    @XmlTransient
    public void setMaxFailuresPerAddress(@Nullable Integer maxFailuresPerAddress) {
        this.maxFailuresPerAddress = maxFailuresPerAddress;
    }

    @XmlTransient
    public void setCooldownValue(@Nullable Integer cooldownValue) {
        this.cooldownValue = cooldownValue;
    }

    @XmlTransient
    public void setCooldownPeriodSec(@Nullable Long cooldownPeriodSec) {
        this.cooldownPeriodSec = cooldownPeriodSec;
    }

    @XmlTransient
    public void setSuggestedAddress(@Nullable String suggestedAddress) {
        this.suggestedAddress = suggestedAddress;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ThrottlingSettings)) {
            return false;
        }
        ThrottlingSettings that = (ThrottlingSettings)o;
        return this.getId() != null && this.getId().equals(that.getId());
    }

    @Override
    public int hashCode() {
        if (this.getId() == null) {
            return System.identityHashCode(this);
        }
        int result = 0;
        result = result * 31 + this.getId().hashCode();
        return result;
    }

    @NotNull
    public static ThrottlingSettingsJSON wrap(@NotNull ThrottlingSettings that) {
        if (that instanceof ThrottlingSettingsJSON) {
            return (ThrottlingSettingsJSON)that;
        }
        return new ThrottlingSettingsJSON(that);
    }

    @Override
    public BlockedAddressesJSON getBlockedAddresses() {
        return this.blockedAddresses;
    }

    @XmlTransient
    public void setBlockedAddresses(@Nullable BlockedAddressesJSON value) {
        this.blockedAddresses = value;
    }

    private <T> List<T> toList(Iterable<T> source) {
        ArrayList<T> target = new ArrayList<T>();
        if (source != null) {
            for (T item2 : source) {
                target.add(item2);
            }
        }
        return target;
    }
}

