/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.imageTool.tool;

import java.io.IOException;
import jetbrains.charisma.commonUI.StaticResource;
import jetbrains.mps.webr.javascript.runtime.jsDependencies.ClasspathUrlGetter;
import jetbrains.springframework.configuration.runtime.MyPathMatchingResourcePatternResolver;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class ClassPathUtil {
    public static final String FOLDER = "scripts/";

    public static ClasspathUrlGetter resourceGetter(String pattern) throws RuntimeException {
        try {
            String resourcePath = FOLDER + ClassPathUtil.findResource(pattern).getFilename();
            ClasspathUrlGetter result = new ClasspathUrlGetter();
            result.setResourcePath(resourcePath);
            return result;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static StaticResource staticResource(String pattern) throws RuntimeException {
        try {
            String resourcePath = FOLDER + ClassPathUtil.findResource(pattern).getFilename();
            return new StaticResource(resourcePath);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static Resource findResource(String pattern) throws IOException {
        Resource[] resources;
        MyPathMatchingResourcePatternResolver resourcePatternResolver = new MyPathMatchingResourcePatternResolver((ResourceLoader)new DefaultResourceLoader());
        String path = "classpath*:scripts/**/*.js";
        for (Resource resource : resources = resourcePatternResolver.getResources(path)) {
            if (!resource.getFilename().contains(pattern)) continue;
            return resource;
        }
        throw new IllegalStateException("Resource not found " + pattern);
    }
}

