/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.imageTool.tool;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jetbrains.charisma.misc.DocumentationLink;
import jetbrains.charisma.persistence.security.UserGroupImpl;
import jetbrains.charisma.persistence.security.VisibilityOptionsProviderFactory;
import jetbrains.charisma.smartui.panel.attachment.AttachmentUtils;
import jetbrains.charisma.smartui.persistent.Context;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.ISequence;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.mps.webr.htmlComponent.runtime.IKeyContainer;
import jetbrains.mps.webr.htmlComponent.runtime.IKeyStroke;
import jetbrains.mps.webr.javascript.runtime.escape.JsStringUtil;
import jetbrains.mps.webr.runtime.util.UserAgentUtil;
import jetbrains.mps.webr.runtime.util.UserOS;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;

public class ImageToolUtils {
    private static List<String> imageToolL10nKeys = null;
    private static List<IKeyStroke> imageToolShortcuts = null;

    public String permittedGroupNames(Entity project) {
        return this.permittedGroupNames(QueryOperations.singleton((Entity)project));
    }

    public String permittedGroupNames(Iterable<Entity> projects) {
        Context context = new Context();
        context.setSelectedProjects(projects);
        return this.joinNames(((VisibilityOptionsProviderFactory)ServiceLocator.getBean((String)"visibilityOptionsProviderFactory")).getProvider().getSortedGroupsForVisibility(context, null));
    }

    private String joinNames(Iterable<Entity> groups) {
        ISequence names = Sequence.fromIterable(groups).select((_FunctionTypes._return_P1_E0)new ISelector<Entity, String>(){

            public String select(Entity it) {
                return (String)PrimitiveAssociationSemantics.get((Entity)it, (String)"name", String.class, (Object)UserGroupImpl.getAllUsersGroupNameInLocale());
            }
        });
        if (Sequence.fromIterable(groups).all((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

            public boolean accept(Entity it) {
                return (Boolean)PrimitiveAssociationSemantics.get((Entity)it, (String)"allUsersGroup", Boolean.class, null) == false;
            }
        })) {
            names = Sequence.fromIterable((Iterable)Sequence.singleton((Object)UserGroupImpl.getAllUsersGroupNameInLocale())).union(Sequence.fromIterable((Iterable)names));
        }
        return Sequence.fromIterable((Iterable)names).select((_FunctionTypes._return_P1_E0)new ISelector<String, String>(){

            public String select(String it) {
                return '\"' + JsStringUtil.stringLiteral((Object)it) + '\"';
            }
        }).toListSequence().toString();
    }

    public String getLinkToDocumentation() {
        return DocumentationLink.IMAGE_EDITOR.getUrl();
    }

    public String systemScreenshotHotKey() {
        UserOS userOS = UserAgentUtil.getUserOS();
        if (userOS == UserOS.MACINTOSH) {
            StringBuilder builder = new StringBuilder();
            builder.append('\u2318');
            String plus = " + ";
            builder.append(plus);
            if (((AttachmentUtils)ServiceLocator.getBean((String)"attachmentUtils")).webkitPasteSupport()) {
                builder.append("Ctrl");
                builder.append(plus);
            }
            builder.append("Shift");
            builder.append(plus);
            builder.append('4');
            return builder.toString();
        }
        if (userOS == UserOS.WINDOWS || userOS == UserOS.LINUX) {
            return "PrtScr";
        }
        return "";
    }

    public String getSerializedImageToolVocabulary() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String item : ListSequence.fromList(ImageToolUtils.getImageTooll10nKeys())) {
            map.put(item, ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg(item, new Object[0]));
        }
        return ImageToolUtils.serializeMap(map);
    }

    public String getSerializedImageToolShortcuts() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (IKeyStroke item : ListSequence.fromList(ImageToolUtils.getImageToolShortcuts())) {
            map.put(item.getName(), item.getPresentation());
        }
        return ImageToolUtils.serializeMap(map);
    }

    private static List<String> getImageTooll10nKeys() {
        if (imageToolL10nKeys == null) {
            imageToolL10nKeys = ListSequence.fromListAndArray(new ArrayList(), (Object[])new String[]{"image-tool.attach", "image-tool.undo", "image-tool.redo", "image-tool.brush", "image-tool.crop", "image-tool.highlight", "image-tool.blur", "image-tool.text", "image-tool.move-image", "image-tool.save", "image-tool.visible-to", "image-tool.clear"});
        }
        return imageToolL10nKeys;
    }

    private static List<IKeyStroke> getImageToolShortcuts() {
        if (imageToolShortcuts == null) {
            imageToolShortcuts = ListSequence.fromListAndArray(new ArrayList(), (Object[])new IKeyStroke[]{ImageToolUtils.as_isexz3_a1a0a0a0b(((IKeyContainer)ServiceLocator.getBean((String)"keyContainer")).getKeyStroke("ImageTool_Crop"), IKeyStroke.class), ImageToolUtils.as_isexz3_a2a0a0a0b(((IKeyContainer)ServiceLocator.getBean((String)"keyContainer")).getKeyStroke("ImageTool_Blur"), IKeyStroke.class), ImageToolUtils.as_isexz3_a3a0a0a0b(((IKeyContainer)ServiceLocator.getBean((String)"keyContainer")).getKeyStroke("ImageTool_Brush"), IKeyStroke.class), ImageToolUtils.as_isexz3_a4a0a0a0b(((IKeyContainer)ServiceLocator.getBean((String)"keyContainer")).getKeyStroke("ImageTool_Text"), IKeyStroke.class), ImageToolUtils.as_isexz3_a5a0a0a0b(((IKeyContainer)ServiceLocator.getBean((String)"keyContainer")).getKeyStroke("ImageTool_Clear"), IKeyStroke.class), ImageToolUtils.as_isexz3_a6a0a0a0b(((IKeyContainer)ServiceLocator.getBean((String)"keyContainer")).getKeyStroke("ImageTool_Highlighting"), IKeyStroke.class), ImageToolUtils.as_isexz3_a7a0a0a0b(((IKeyContainer)ServiceLocator.getBean((String)"keyContainer")).getKeyStroke("ImageTool_Undo"), IKeyStroke.class), ImageToolUtils.as_isexz3_a8a0a0a0b(((IKeyContainer)ServiceLocator.getBean((String)"keyContainer")).getKeyStroke("ImageTool_Redo"), IKeyStroke.class), ImageToolUtils.as_isexz3_a9a0a0a0b(((IKeyContainer)ServiceLocator.getBean((String)"keyContainer")).getKeyStroke("ImageTool_Scrolling"), IKeyStroke.class), ImageToolUtils.as_isexz3_a01a0a0a0b(((IKeyContainer)ServiceLocator.getBean((String)"keyContainer")).getKeyStroke("Submit"), IKeyStroke.class)});
        }
        return imageToolShortcuts;
    }

    private static String serializeMap(Map<String, String> map) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString(map);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static <T> T as_isexz3_a1a0a0a0b(Object o, Class<T> type) {
        return (T)(type.isInstance(o) ? o : null);
    }

    private static <T> T as_isexz3_a2a0a0a0b(Object o, Class<T> type) {
        return (T)(type.isInstance(o) ? o : null);
    }

    private static <T> T as_isexz3_a3a0a0a0b(Object o, Class<T> type) {
        return (T)(type.isInstance(o) ? o : null);
    }

    private static <T> T as_isexz3_a4a0a0a0b(Object o, Class<T> type) {
        return (T)(type.isInstance(o) ? o : null);
    }

    private static <T> T as_isexz3_a5a0a0a0b(Object o, Class<T> type) {
        return (T)(type.isInstance(o) ? o : null);
    }

    private static <T> T as_isexz3_a6a0a0a0b(Object o, Class<T> type) {
        return (T)(type.isInstance(o) ? o : null);
    }

    private static <T> T as_isexz3_a7a0a0a0b(Object o, Class<T> type) {
        return (T)(type.isInstance(o) ? o : null);
    }

    private static <T> T as_isexz3_a8a0a0a0b(Object o, Class<T> type) {
        return (T)(type.isInstance(o) ? o : null);
    }

    private static <T> T as_isexz3_a9a0a0a0b(Object o, Class<T> type) {
        return (T)(type.isInstance(o) ? o : null);
    }

    private static <T> T as_isexz3_a01a0a0a0b(Object o, Class<T> type) {
        return (T)(type.isInstance(o) ? o : null);
    }
}

