/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.auth.module.openid.dnq.persistence;

import java.net.URI;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import jetbrains.jetpass.auth.module.dnq.authentication.AuthUrl;
import jetbrains.jetpass.auth.module.dnq.authentication.AuthenticationException;
import jetbrains.jetpass.auth.module.dnq.authentication.FederatedAuthenticationHandler;
import jetbrains.jetpass.auth.module.dnq.authentication.ServletRequestCredentials;
import jetbrains.jetpass.auth.module.dnq.authentication.State;
import jetbrains.jetpass.auth.module.openid.dnq.persistence.OpenIDFederatedAuthenticationHandler;
import jetbrains.jetpass.auth.module.openid.dnq.ui.login.OpenIDAuthenticationException;
import jetbrains.jetpass.auth.module.openid.dnq.ui.login.OpenIdConsumer;
import jetbrains.jetpass.auth.module.openid.dnq.xd.XdOpenIDAuthModule;
import jetbrains.jetpass.auth.module.openid.rest.client.api.OpenIDUserDetails;
import jetbrains.jetpass.dao.dnq.api.JetPassDAOContainer;
import jetbrains.jetpass.dao.dnq.api.URLBuilderUtilKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference2;
import kotlin.jvm.internal.MutablePropertyReference2Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openid4java.discovery.DiscoveryInformation;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001fB\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J5\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0019\u0010\u0015\u001a\u0015\u0012\u0004\u0012\u00020\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u0017\u00a2\u0006\u0002\b\u0019H\u0016J(\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u000e\u0010\u001e\u001a\u0004\u0018\u00010\u0018*\u00020\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Ljetbrains/jetpass/auth/module/openid/dnq/persistence/OpenIDFederatedAuthenticationHandler;", "Ljetbrains/jetpass/auth/module/dnq/authentication/FederatedAuthenticationHandler;", "Ljetbrains/jetpass/auth/module/openid/rest/client/api/OpenIDUserDetails;", "authModule", "Ljetbrains/jetpass/auth/module/openid/dnq/xd/XdOpenIDAuthModule;", "consumer", "Ljetbrains/jetpass/auth/module/openid/dnq/ui/login/OpenIdConsumer;", "container", "Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;", "(Ljetbrains/jetpass/auth/module/openid/dnq/xd/XdOpenIDAuthModule;Ljetbrains/jetpass/auth/module/openid/dnq/ui/login/OpenIdConsumer;Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;)V", "authenticate", "credentials", "Ljetbrains/jetpass/auth/module/dnq/authentication/ServletRequestCredentials;", "getReturnUri", "Ljava/net/URI;", "authUrl", "Ljetbrains/jetpass/auth/module/dnq/authentication/AuthUrl;", "isOpenIDMessage", "", "request", "Ljavax/servlet/http/HttpServletRequest;", "restoreState", "Ljetbrains/jetpass/auth/module/dnq/authentication/State;", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "start", "Ljavax/ws/rs/core/Response;", "state", "stateId", "getState", "Companion", "jetbrains.jetpass.auth.module.openid.dnq"})
public final class OpenIDFederatedAuthenticationHandler
implements FederatedAuthenticationHandler<OpenIDUserDetails> {
    private final XdOpenIDAuthModule authModule;
    private final OpenIdConsumer consumer;
    private final JetPassDAOContainer container;
    @NotNull
    private static final State.Attribute discovered$delegate;
    @NotNull
    private static final String STATE = "openIDState";
    public static final Companion Companion;

    @NotNull
    public Response start(@NotNull HttpServletRequest request, @NotNull State state, @NotNull String stateId, @NotNull AuthUrl authUrl) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)stateId, (String)"stateId");
        Intrinsics.checkParameterIsNotNull((Object)authUrl, (String)"authUrl");
        DiscoveryInformation discovered2 = this.consumer.discover(this.authModule);
        Companion.setDiscovered(state, discovered2);
        String string = URLBuilderUtilKt.appendQueryParameter((URI)state.getLandingUri(), (String)STATE, (String)stateId).toASCIIString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"state.landingUri.appendQ\u2026 stateId).toASCIIString()");
        String openIDRequestURI = this.consumer.buildRequest(discovered2, this.authModule, string);
        URI startURI = URI.create(openIDRequestURI);
        Response response = Response.seeOther((URI)startURI).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.seeOther(startURI).build()");
        return response;
    }

    @NotNull
    public OpenIDUserDetails authenticate(@NotNull ServletRequestCredentials credentials) throws AuthenticationException {
        Intrinsics.checkParameterIsNotNull((Object)credentials, (String)"credentials");
        HttpServletRequest request = credentials.getRequest();
        State state = credentials.getState();
        DiscoveryInformation discovered2 = Companion.getDiscovered(state);
        URI requestURL = URLBuilderUtilKt.appendQueryParameter((URI)state.getLandingUri(), (String)STATE, (String)this.getState(request));
        String string = requestURL.toASCIIString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"requestURL.toASCIIString()");
        Map map = request.getParameterMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"request.parameterMap");
        return this.consumer.verifyResponse(discovered2, this.authModule, string, map, this.container);
    }

    @NotNull
    public URI getReturnUri(@NotNull AuthUrl authUrl) {
        Intrinsics.checkParameterIsNotNull((Object)authUrl, (String)"authUrl");
        URI uRI = URI.create(authUrl.getFederatedReturnURL(this.authModule.getUuid()));
        Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"URI.create(authUrl.getFe\u2026turnURL(authModule.uuid))");
        return uRI;
    }

    private final String getState(@NotNull HttpServletRequest $receiver) {
        if (!this.isOpenIDMessage($receiver)) {
            throw (Throwable)((Object)OpenIDAuthenticationException.Companion.nonOpenIDMessage());
        }
        return $receiver.getParameter(STATE);
    }

    @Nullable
    public State restoreState(@NotNull HttpServletRequest request, @NotNull AuthUrl authUrl, @NotNull Function1<? super String, ? extends State> restoreState) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)authUrl, (String)"authUrl");
        Intrinsics.checkParameterIsNotNull(restoreState, (String)"restoreState");
        String string = this.getState(request);
        return string != null ? (State)restoreState.invoke((Object)string) : null;
    }

    private final boolean isOpenIDMessage(HttpServletRequest request) {
        return request.getParameter("openid.mode") != null;
    }

    public OpenIDFederatedAuthenticationHandler(@NotNull XdOpenIDAuthModule authModule, @NotNull OpenIdConsumer consumer, @NotNull JetPassDAOContainer container) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)authModule), (String)"authModule");
        Intrinsics.checkParameterIsNotNull((Object)consumer, (String)"consumer");
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        this.authModule = authModule;
        this.consumer = consumer;
        this.container = container;
    }

    static {
        Companion = new Companion(null);
        discovered$delegate = new State.Attribute((Function0)Companion.discovered.2.INSTANCE);
        STATE = STATE;
    }

    public static final /* synthetic */ void access$setDiscovered$cp(@NotNull State.Attribute attribute) {
        discovered$delegate = attribute;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R/\u0010\t\u001a\u00020\b*\u00020\n2\u0006\u0010\u0007\u001a\u00020\b8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0011"}, d2={"Ljetbrains/jetpass/auth/module/openid/dnq/persistence/OpenIDFederatedAuthenticationHandler$Companion;", "", "()V", "STATE", "", "getSTATE", "()Ljava/lang/String;", "<set-?>", "Lorg/openid4java/discovery/DiscoveryInformation;", "discovered", "Ljetbrains/jetpass/auth/module/dnq/authentication/State;", "getDiscovered", "(Ljetbrains/jetpass/auth/module/dnq/authentication/State;)Lorg/openid4java/discovery/DiscoveryInformation;", "setDiscovered", "(Ljetbrains/jetpass/auth/module/dnq/authentication/State;Lorg/openid4java/discovery/DiscoveryInformation;)V", "discovered$delegate", "Ljetbrains/jetpass/auth/module/dnq/authentication/State$Attribute;", "jetbrains.jetpass.auth.module.openid.dnq"})
    public static final class Companion {
        static final /* synthetic */ KProperty[] $$delegatedProperties;

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty2((MutablePropertyReference2)new MutablePropertyReference2Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class), "discovered", "getDiscovered(Ljetbrains/jetpass/auth/module/dnq/authentication/State;)Lorg/openid4java/discovery/DiscoveryInformation;"))};
        }

        @NotNull
        public final DiscoveryInformation getDiscovered(@NotNull State $receiver) {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            return (DiscoveryInformation)discovered$delegate.getValue($receiver, $$delegatedProperties[0]);
        }

        public final void setDiscovered(@NotNull State $receiver, @NotNull DiscoveryInformation discoveryInformation) {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            Intrinsics.checkParameterIsNotNull((Object)discoveryInformation, (String)"<set-?>");
            discovered$delegate.setValue($receiver, $$delegatedProperties[0], (Object)discoveryInformation);
        }

        @NotNull
        public final String getSTATE() {
            return STATE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

