/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.auth.module.openid.dnq.ui.login;

import jetbrains.jetpass.auth.module.dnq.authentication.AuthenticationException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openid4java.OpenIDException;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0003\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\n"}, d2={"Ljetbrains/jetpass/auth/module/openid/dnq/ui/login/OpenIDAuthenticationException;", "Ljetbrains/jetpass/auth/module/dnq/authentication/AuthenticationException;", "code", "", "message", "(Ljava/lang/String;Ljava/lang/String;)V", "cause", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Throwable;)V", "Companion", "jetbrains.jetpass.auth.module.openid.dnq"})
public final class OpenIDAuthenticationException
extends AuthenticationException {
    @NotNull
    private static final String AUTH_FAILED = "openid-auth-failed";
    @NotNull
    private static final String AUTH_DENIED = "openid-auth-denied";
    @NotNull
    private static final String USER_FETCH_FAILED = "openid-user-fetch";
    public static final Companion Companion = new Companion(null);

    public OpenIDAuthenticationException(@NotNull String code, @Nullable String message) {
        Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
        super(code, message, null, 4, null);
    }

    public OpenIDAuthenticationException(@NotNull String code, @Nullable String message, @NotNull Throwable cause) {
        Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
        Intrinsics.checkParameterIsNotNull((Object)cause, (String)"cause");
        super(code, message, cause, null, 8, null);
    }

    static {
        AUTH_FAILED = AUTH_FAILED;
        AUTH_DENIED = AUTH_DENIED;
        USER_FETCH_FAILED = USER_FETCH_FAILED;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000b\u001a\u00020\fJ\u0012\u0010\r\u001a\u00020\f2\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010J\u000e\u0010\u0011\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\fJ\u0006\u0010\u0014\u001a\u00020\fR\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u0015"}, d2={"Ljetbrains/jetpass/auth/module/openid/dnq/ui/login/OpenIDAuthenticationException$Companion;", "", "()V", "AUTH_DENIED", "", "getAUTH_DENIED", "()Ljava/lang/String;", "AUTH_FAILED", "getAUTH_FAILED", "USER_FETCH_FAILED", "getUSER_FETCH_FAILED", "authDenied", "Ljetbrains/jetpass/auth/module/openid/dnq/ui/login/OpenIDAuthenticationException;", "authFailed", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "cantGetUser", "Lorg/openid4java/OpenIDException;", "nonOpenIDMessage", "responseUnverified", "jetbrains.jetpass.auth.module.openid.dnq"})
    public static final class Companion {
        @NotNull
        public final String getAUTH_FAILED() {
            return AUTH_FAILED;
        }

        @NotNull
        public final String getAUTH_DENIED() {
            return AUTH_DENIED;
        }

        @NotNull
        public final String getUSER_FETCH_FAILED() {
            return USER_FETCH_FAILED;
        }

        @NotNull
        public final OpenIDAuthenticationException authFailed(@NotNull Exception e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            return new OpenIDAuthenticationException(this.getAUTH_FAILED(), e.getMessage(), e);
        }

        @NotNull
        public final OpenIDAuthenticationException authDenied() {
            return new OpenIDAuthenticationException(this.getAUTH_DENIED(), "Authorization denied");
        }

        @NotNull
        public final OpenIDAuthenticationException nonOpenIDMessage() {
            return new OpenIDAuthenticationException(this.getAUTH_FAILED(), "Response is not an OpenId message");
        }

        @NotNull
        public final OpenIDAuthenticationException responseUnverified() {
            return new OpenIDAuthenticationException(this.getAUTH_FAILED(), "OpenId response data verification failed");
        }

        @NotNull
        public final OpenIDAuthenticationException cantGetUser(@NotNull OpenIDException e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            return new OpenIDAuthenticationException(this.getUSER_FETCH_FAILED(), "Cannot get OpenID user data: " + e.getMessage(), (Throwable)e);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

