/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.auth.module.openid.dnq.ui.login;

import java.util.List;
import java.util.Map;
import jetbrains.jetpass.api.authority.profile.EmailContact;
import jetbrains.jetpass.auth.module.openid.api.user.details.OpenIDUserDetailsImpl;
import jetbrains.jetpass.auth.module.openid.dnq.ui.login.OpenIDAuthenticationException;
import jetbrains.jetpass.auth.module.openid.dnq.ui.login.OpenIdConsumer$Companion$getValue$;
import jetbrains.jetpass.auth.module.openid.dnq.ui.login.OpenIdConsumerKt;
import jetbrains.jetpass.auth.module.openid.dnq.xd.XdOpenIDAuthModule;
import jetbrains.jetpass.auth.module.openid.rest.client.api.OpenIDUserDetails;
import jetbrains.jetpass.dao.dnq.api.JetPassDAOContainer;
import jetbrains.jetpass.pojo.api.authority.profile.EmailContactImpl;
import jetbrains.jetpass.pojo.api.authority.profile.EmailUtils;
import jetbrains.jetpass.userManagement.persistence.dnq.module.XdAuthModule;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openid4java.OpenIDException;
import org.openid4java.consumer.ConsumerAssociationStore;
import org.openid4java.consumer.ConsumerManager;
import org.openid4java.consumer.NonceVerifier;
import org.openid4java.consumer.VerificationResult;
import org.openid4java.discovery.DiscoveryInformation;
import org.openid4java.discovery.Identifier;
import org.openid4java.message.AuthRequest;
import org.openid4java.message.AuthSuccess;
import org.openid4java.message.Message;
import org.openid4java.message.MessageExtension;
import org.openid4java.message.ParameterList;
import org.openid4java.message.ax.FetchRequest;
import org.openid4java.message.ax.FetchResponse;
import org.openid4java.message.sreg.SRegResponse;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bJ\u000e\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ@\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000b2\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u0019R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001b"}, d2={"Ljetbrains/jetpass/auth/module/openid/dnq/ui/login/OpenIdConsumer;", "", "connectionTimeout", "", "readTimeout", "(II)V", "manager", "Lorg/openid4java/consumer/ConsumerManager;", "getManager", "()Lorg/openid4java/consumer/ConsumerManager;", "buildRequest", "", "discovered", "Lorg/openid4java/discovery/DiscoveryInformation;", "module", "Ljetbrains/jetpass/auth/module/openid/dnq/xd/XdOpenIDAuthModule;", "returnURL", "discover", "verifyResponse", "Ljetbrains/jetpass/auth/module/openid/rest/client/api/OpenIDUserDetails;", "receivingURL", "parameterMap", "", "", "container", "Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;", "Companion", "jetbrains.jetpass.auth.module.openid.dnq"})
public class OpenIdConsumer {
    @NotNull
    private final ConsumerManager manager;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final ConsumerManager getManager() {
        return this.manager;
    }

    @NotNull
    public final DiscoveryInformation discover(@NotNull XdOpenIDAuthModule module) throws OpenIDException {
        DiscoveryInformation discovered2;
        Intrinsics.checkParameterIsNotNull((Object)((Object)module), (String)"module");
        List discoveries = this.manager.discover(module.getUrl());
        DiscoveryInformation discoveryInformation = discovered2 = this.manager.associate(discoveries);
        Intrinsics.checkExpressionValueIsNotNull((Object)discoveryInformation, (String)"discovered");
        return discoveryInformation;
    }

    @NotNull
    public final String buildRequest(@NotNull DiscoveryInformation discovered2, @NotNull XdOpenIDAuthModule module, @NotNull String returnURL) throws OpenIDException {
        FetchRequest fetchRequest;
        Intrinsics.checkParameterIsNotNull((Object)discovered2, (String)"discovered");
        Intrinsics.checkParameterIsNotNull((Object)((Object)module), (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)returnURL, (String)"returnURL");
        AuthRequest authRequest = this.manager.authenticate(discovered2, returnURL);
        FetchRequest $receiver = fetchRequest = FetchRequest.createFetchRequest();
        CharSequence charSequence = module.getEmailSchema();
        if (!(charSequence == null || charSequence.length() == 0)) {
            $receiver.addAttribute("Email", module.getEmailSchema(), true);
        }
        if (!((charSequence = (CharSequence)module.getFirstNameSchema()) == null || charSequence.length() == 0)) {
            $receiver.addAttribute("FirstName", module.getFirstNameSchema(), true);
        }
        if (!((charSequence = (CharSequence)module.getLastNameSchema()) == null || charSequence.length() == 0)) {
            $receiver.addAttribute("LastName", module.getLastNameSchema(), true);
        }
        if (!((charSequence = (CharSequence)module.getFullNameSchema()) == null || charSequence.length() == 0)) {
            $receiver.addAttribute("FullName", module.getFullNameSchema(), true);
        }
        if (!((charSequence = (CharSequence)module.getAvatarSchema()) == null || charSequence.length() == 0)) {
            $receiver.addAttribute("Avatar", module.getAvatarSchema(), true);
        }
        FetchRequest fetchRequest2 = fetchRequest;
        authRequest.addExtension((MessageExtension)fetchRequest2);
        String string = authRequest.getDestinationUrl(true);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"authRequest.getDestinationUrl(true)");
        return string;
    }

    @NotNull
    public final OpenIDUserDetails verifyResponse(@NotNull DiscoveryInformation discovered2, @NotNull XdOpenIDAuthModule module, @NotNull String receivingURL, @NotNull Map<String, String[]> parameterMap, @NotNull JetPassDAOContainer container) throws OpenIDAuthenticationException {
        OpenIDUserDetailsImpl openIDUserDetailsImpl;
        MessageExtension extension;
        VerificationResult verification;
        Intrinsics.checkParameterIsNotNull((Object)discovered2, (String)"discovered");
        Intrinsics.checkParameterIsNotNull((Object)((Object)module), (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)receivingURL, (String)"receivingURL");
        Intrinsics.checkParameterIsNotNull(parameterMap, (String)"parameterMap");
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        ParameterList openidResp = new ParameterList(parameterMap);
        try {
            VerificationResult verificationResult = this.manager.verify(receivingURL, openidResp, discovered2);
            Intrinsics.checkExpressionValueIsNotNull((Object)verificationResult, (String)"manager.verify(receiving\u2026, openidResp, discovered)");
            verification = verificationResult;
        }
        catch (Exception e) {
            throw (Throwable)((Object)OpenIDAuthenticationException.Companion.authFailed(e));
        }
        Message message = verification.getAuthResponse();
        if (!(message instanceof AuthSuccess)) {
            message = null;
        }
        AuthSuccess authSuccess = (AuthSuccess)message;
        if (authSuccess == null) {
            throw (Throwable)((Object)OpenIDAuthenticationException.Companion.authDenied());
        }
        AuthSuccess authResponse = authSuccess;
        Identifier identifier = verification.getVerifiedId();
        if (identifier == null) {
            throw (Throwable)((Object)OpenIDAuthenticationException.Companion.responseUnverified());
        }
        Identifier verified = identifier;
        String identifier2 = verified.getIdentifier();
        String email = null;
        String firstName = null;
        String lastName = null;
        String fullName = null;
        String avatar = null;
        if (authResponse.hasExtension("http://openid.net/srv/ax/1.0")) {
            try {
                extension = authResponse.getExtension("http://openid.net/srv/ax/1.0");
                if (extension instanceof FetchResponse) {
                    email = OpenIdConsumer.Companion.getValue((FetchResponse)extension, module.getEmailSchema());
                    firstName = OpenIdConsumer.Companion.getValue((FetchResponse)extension, module.getFirstNameSchema());
                    lastName = OpenIdConsumer.Companion.getValue((FetchResponse)extension, module.getLastNameSchema());
                    fullName = OpenIdConsumer.Companion.getValue((FetchResponse)extension, module.getFullNameSchema());
                    avatar = OpenIdConsumer.Companion.getValue((FetchResponse)extension, module.getAvatarSchema());
                }
            }
            catch (OpenIDException e) {
                throw (Throwable)((Object)OpenIDAuthenticationException.Companion.cantGetUser(e));
            }
        }
        if (authResponse.hasExtension("http://openid.net/sreg/1.0")) {
            try {
                extension = authResponse.getExtension("http://openid.net/sreg/1.0");
                if (extension instanceof SRegResponse) {
                    email = ((SRegResponse)extension).getAttributeValue("Email");
                    firstName = ((SRegResponse)extension).getAttributeValue("FirstName");
                    lastName = ((SRegResponse)extension).getAttributeValue("LastName");
                    fullName = ((SRegResponse)extension).getAttributeValue("FullName");
                    avatar = ((SRegResponse)extension).getAttributeValue("Avatar");
                }
            }
            catch (OpenIDException e) {
                throw (Throwable)((Object)OpenIDAuthenticationException.Companion.cantGetUser(e));
            }
        }
        OpenIDUserDetailsImpl $receiver = openIDUserDetailsImpl = new OpenIDUserDetailsImpl();
        $receiver.setAuthModule(container.getJetPassAuthModuleDAO().wrapEntity((XdAuthModule)module));
        $receiver.setIdentifier(identifier2);
        if (email != null) {
            $receiver.setEmail((EmailContact)new EmailContactImpl(email, module.isEmailVerified()));
        }
        String string = identifier2;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"identifier");
        $receiver.setFullName(Companion.resolveFullName(string, email, firstName, lastName, fullName));
        $receiver.setAvatar(avatar);
        return (OpenIDUserDetails)openIDUserDetailsImpl;
    }

    public OpenIdConsumer(int connectionTimeout, int readTimeout) {
        ConsumerManager consumerManager;
        ConsumerManager consumerManager2 = new ConsumerManager();
        OpenIdConsumer openIdConsumer = this;
        ConsumerManager it = consumerManager2;
        it.setAssociations((ConsumerAssociationStore)OpenIdConsumerKt.access$getAssociations$p());
        it.setNonceVerifier((NonceVerifier)OpenIdConsumerKt.access$getNonceVerifier$p());
        it.setPrivateAssociationStore((ConsumerAssociationStore)OpenIdConsumerKt.access$getPrivateAssociationStore$p());
        it.setSocketTimeout(readTimeout);
        it.setConnectTimeout(connectionTimeout);
        openIdConsumer.manager = consumerManager = consumerManager2;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u00042\b\u0010\b\u001a\u0004\u0018\u00010\u00042\b\u0010\t\u001a\u0004\u0018\u00010\u0004J\u0018\u0010\n\u001a\u0004\u0018\u00010\u0004*\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0004H\u0002\u00a8\u0006\r"}, d2={"Ljetbrains/jetpass/auth/module/openid/dnq/ui/login/OpenIdConsumer$Companion;", "", "()V", "resolveFullName", "", "identifier", "email", "firstName", "lastName", "fullName", "getValue", "Lorg/openid4java/message/ax/FetchResponse;", "schema", "jetbrains.jetpass.auth.module.openid.dnq"})
    public static final class Companion {
        @NotNull
        public final String resolveFullName(@NotNull String identifier, @Nullable String email, @Nullable String firstName, @Nullable String lastName, @Nullable String fullName) {
            String string;
            CharSequence charSequence;
            Intrinsics.checkParameterIsNotNull((Object)identifier, (String)"identifier");
            if (fullName != null && (charSequence = (CharSequence)fullName).length() > 0) {
                string = fullName;
            } else if (firstName != null && (charSequence = (CharSequence)firstName).length() > 0 && lastName != null && (charSequence = (CharSequence)lastName).length() > 0) {
                string = firstName + ' ' + lastName;
            } else if (firstName != null && (charSequence = (CharSequence)firstName).length() > 0) {
                string = firstName;
            } else if (lastName != null && (charSequence = (CharSequence)lastName).length() > 0) {
                string = lastName;
            } else if (email != null && (charSequence = (CharSequence)email).length() > 0) {
                String string2 = EmailUtils.trimDomain((String)email);
                string = string2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"EmailUtils.trimDomain(email)");
            } else {
                string = identifier;
            }
            return string;
        }

        private final String getValue(@NotNull FetchResponse $receiver, String schema) {
            String string;
            CharSequence charSequence;
            if (schema != null && (charSequence = (CharSequence)schema).length() > 0) {
                Object v2;
                block4: {
                    List list = $receiver.getAttributeValues($receiver.getAttributeAlias(schema));
                    Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"getAttributeValues(getAttributeAlias(schema))");
                    Sequence $receiver$iv = CollectionsKt.asSequence((Iterable)list);
                    Sequence sequence = SequencesKt.filter((Sequence)$receiver$iv, (Function1)Companion$getValue$$inlined$filterIsInstance$1.INSTANCE);
                    if (sequence == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
                    }
                    $receiver$iv = SequencesKt.filterNotNull((Sequence)sequence);
                    for (Object element$iv : $receiver$iv) {
                        String it = (String)element$iv;
                        CharSequence charSequence2 = it;
                        if (!(charSequence2.length() > 0)) continue;
                        v2 = element$iv;
                        break block4;
                    }
                    v2 = null;
                }
                string = v2;
            } else {
                string = null;
            }
            return string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

