/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.parser.impl;

import java.util.List;
import jetbrains.youtrack.parser.api.IWord;
import jetbrains.youtrack.parser.api.WordStringUtil;
import jetbrains.youtrack.parser.impl.Lexer;
import jetbrains.youtrack.parser.impl.Tokenizer;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service(value="wordStringUtil")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u0004H\u0016J\u001e\u0010\t\u001a\u00020\n2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u000b\u001a\u00020\u0004H\u0016J(\u0010\t\u001a\u00020\n2\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0016J0\u0010\t\u001a\u00020\n2\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0004H\u0016J7\u0010\u000e\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\n\u0018\u00010\u000f2\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010\u0012J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0014\u001a\u00020\nH\u0016J(\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\u0010\u0014\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016\u00a8\u0006\u0018"}, d2={"Ljetbrains/youtrack/parser/impl/WordStringUtilImpl;", "Ljetbrains/youtrack/parser/api/WordStringUtil;", "()V", "getStartOffset", "", "words", "", "Ljetbrains/youtrack/parser/api/IWord;", "wordIndex", "toString", "", "startIndex", "endIndex", "endOffset", "toStrings", "", "startToken", "endToken", "(Ljava/util/List;II)[Ljava/lang/String;", "toWords", "s", "trim", "", "lineBreakAsSpace", "youtrack-parser"})
public class WordStringUtilImpl
implements WordStringUtil {
    @NotNull
    public String toString(@NotNull List<? extends IWord> words, int startIndex) {
        Intrinsics.checkParameterIsNotNull(words, (String)"words");
        return this.toString(words, startIndex, words.size() - 1);
    }

    @NotNull
    public String toString(@Nullable List<? extends IWord> words, int startIndex, int endIndex) {
        if (words == null) {
            return "";
        }
        if (startIndex > endIndex) {
            return "";
        }
        return endIndex < 0 || words.size() <= endIndex ? "" : this.toString(words, startIndex, endIndex, words.get(endIndex).getEndOffset() - words.get(endIndex).getStartOffset());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String toString(@Nullable List<? extends IWord> words, int startIndex, int endIndex, int endOffset) {
        String word;
        if (words == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int n = startIndex;
        int n2 = endIndex;
        while (n < n2) {
            void i;
            sb.append(words.get((int)i).getWord());
            ++i;
        }
        String string = words.get(endIndex).getWord();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"words[endIndex].word");
        String string2 = word = string;
        int n3 = 0;
        int n4 = Math.min(endOffset, word.length());
        StringBuilder stringBuilder = sb;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.substring(n3, n4);
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String string5 = string4;
        stringBuilder.append(string5);
        String string6 = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"sb.toString()");
        return string6;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public String[] toStrings(@Nullable List<? extends IWord> words, int startToken, int endToken) {
        if (words == null) {
            return null;
        }
        String[] res = new String[endToken - startToken + 1];
        int n = startToken;
        int n2 = endToken;
        if (n <= n2) {
            while (true) {
                void i;
                res[i - startToken] = words.get((int)i).getWord();
                if (i == n2) break;
                ++i;
            }
        }
        return res;
    }

    public int getStartOffset(@NotNull List<? extends IWord> words, int wordIndex) {
        Intrinsics.checkParameterIsNotNull(words, (String)"words");
        return words.isEmpty() ? 0 : (wordIndex >= words.size() ? words.get(words.size() - 1).getEndOffset() : words.get(wordIndex).getStartOffset());
    }

    @Override
    @NotNull
    public List<IWord> toWords(@NotNull String s) {
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        return this.toWords(s, false, false);
    }

    @Override
    @NotNull
    public List<IWord> toWords(@Nullable String s, boolean trim, boolean lineBreakAsSpace) {
        String string;
        Tokenizer tokenizer = new Tokenizer();
        if (trim) {
            String string2 = s;
            if (string2 != null) {
                String string3;
                String string4 = string3 = string2;
                if (string4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                string = ((Object)StringsKt.trim((CharSequence)string4)).toString();
            } else {
                string = null;
            }
        } else {
            string = s;
        }
        String trimmed = string;
        Lexer l = new Lexer(trimmed, tokenizer);
        l.setLineBreakAsSpace(lineBreakAsSpace);
        l.parse();
        return tokenizer.getResult$youtrack_parser();
    }
}

