/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.imports.persistent;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jetbrains.youtrack.scripts.persistence.ScriptingContextFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.Context;

public class ContextHolder {
    protected static Log log = LogFactory.getLog(ContextHolder.class);
    private Map<String, ScriptingContextFactory.TimedContext> contexts = new ConcurrentHashMap<String, ScriptingContextFactory.TimedContext>();

    public void setContext(String name, Context context) {
        if (context == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Removing " + name + " from ContextHolder"));
            }
            this.contexts.remove(name);
        } else if (!(context instanceof ScriptingContextFactory.TimedContext)) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"Something unexpected happened: script context is not an instance of ScriptingContextFactory.TimedContext");
            }
        } else {
            if (log.isInfoEnabled()) {
                log.info((Object)("Storing " + name + " in ContextHolder"));
            }
            this.contexts.put(name, (ScriptingContextFactory.TimedContext)context);
        }
    }

    public void stop(String name) {
        ScriptingContextFactory.TimedContext ctx = this.contexts.get(name);
        if (ctx != null) {
            ctx.stop();
        } else if (log.isInfoEnabled()) {
            log.info((Object)("The script " + name + " was not running when there was an attempt to stop it."));
        }
    }
}

