/*
 * Decompiled with CFR 0.152.
 */
package com.ackbox.totp;

import com.ackbox.totp.TOTPSecretKey;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.http.client.utils.URIBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J'\u0010\u0005\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\nJ \u0010\u000b\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\"\u0010\f\u001a\n \r*\u0004\u0018\u00010\u00040\u00042\u0006\u0010\u000e\u001a\u00020\u00042\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0002J\u001a\u0010\u0011\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/ackbox/totp/QRCodeFactory;", "", "()V", "QR_GENERATOR_URI_FORMAT", "", "createOTPURL", "issuer", "accountName", "secretKey", "Lcom/ackbox/totp/TOTPSecretKey;", "createOTPURL$ackbox_totp", "createQRCodeURL", "encode", "kotlin.jvm.PlatformType", "decoded", "charset", "Ljava/nio/charset/Charset;", "formatLabel", "ackbox-totp"})
public final class QRCodeFactory {
    private static final String QR_GENERATOR_URI_FORMAT = "https://chart.googleapis.com/chart?chs=200x200&chld=M%%7C0&cht=qr&chl=%s";
    public static final QRCodeFactory INSTANCE;

    @NotNull
    public final String createQRCodeURL(@Nullable String issuer, @NotNull String accountName, @NotNull TOTPSecretKey secretKey) {
        Intrinsics.checkParameterIsNotNull((Object)accountName, (String)"accountName");
        Intrinsics.checkParameterIsNotNull((Object)secretKey, (String)"secretKey");
        String url = this.createOTPURL$ackbox_totp(issuer, accountName, secretKey);
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = QR_GENERATOR_URI_FORMAT;
        Object[] objectArray = new Object[]{QRCodeFactory.encode$default(this, url, null, 2, null)};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
        return string2;
    }

    @NotNull
    public final String createOTPURL$ackbox_totp(@Nullable String issuer, @NotNull String accountName, @NotNull TOTPSecretKey secretKey) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)accountName, (String)"accountName");
        Intrinsics.checkParameterIsNotNull((Object)secretKey, (String)"secretKey");
        CharSequence charSequence = accountName;
        boolean bl2 = bl = !StringsKt.isBlank((CharSequence)charSequence);
        if (!bl) {
            String string = "Account name must not be not null or empty.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        String string = issuer;
        if (string != null) {
            boolean bl3;
            String string2;
            String it = string2 = string;
            boolean bl4 = bl3 = !StringsKt.contains$default((CharSequence)issuer, (CharSequence)":", (boolean)false, (int)2, null);
            if (!bl3) {
                String string3 = "Issuer cannot contain the ':' character.";
                throw (Throwable)new IllegalArgumentException(string3.toString());
            }
        }
        URIBuilder builder = new URIBuilder().setScheme("otpauth").setHost("totp").setPath("/" + this.formatLabel(issuer, accountName)).setParameter("secret", secretKey.to(TOTPSecretKey.KeyRepresentation.BASE32));
        String string4 = issuer;
        if (string4 != null) {
            String string5;
            String it = string5 = string4;
            builder.setParameter("issuer", issuer);
        }
        String string6 = builder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"builder.toString()");
        return string6;
    }

    private final String formatLabel(String issuer, String accountName) {
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])new String[]{issuer, accountName}), (CharSequence)":", null, null, (int)0, null, null, (int)62, null);
    }

    private final String encode(String decoded, Charset charset) {
        return URLEncoder.encode(decoded, charset.name());
    }

    static /* bridge */ /* synthetic */ String encode$default(QRCodeFactory qRCodeFactory, String string, Charset charset, int n, Object object) {
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        return qRCodeFactory.encode(string, charset);
    }

    private QRCodeFactory() {
    }

    static {
        QRCodeFactory qRCodeFactory;
        INSTANCE = qRCodeFactory = new QRCodeFactory();
    }
}

