/*
 * Decompiled with CFR 0.152.
 */
package com.ackbox.totp.google;

import com.ackbox.totp.ReseedingSecureRandom;
import com.ackbox.totp.TOTPAuthenticator;
import com.ackbox.totp.TOTPException;
import com.ackbox.totp.TOTPSecretKey;
import com.ackbox.totp.google.GoogleAuthenticatorConfig;
import com.ackbox.totp.google.GoogleTOTPCredentials;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 $2\u00020\u0001:\u0001$B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0011H\u0002J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\f0\u00172\u0006\u0010\u0018\u001a\u00020\u0011H\u0002J\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J(\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\fH\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010 \u001a\u00020\fH\u0002J\u0010\u0010!\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\"\u001a\u00020\b2\u0006\u0010#\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/ackbox/totp/google/GoogleAuthenticator;", "Lcom/ackbox/totp/TOTPAuthenticator;", "config", "Lcom/ackbox/totp/google/GoogleAuthenticatorConfig;", "(Lcom/ackbox/totp/google/GoogleAuthenticatorConfig;)V", "secureRandom", "Lcom/ackbox/totp/ReseedingSecureRandom;", "authorize", "", "secretKey", "Lcom/ackbox/totp/TOTPSecretKey;", "totp", "", "time", "Ljava/time/Instant;", "calculateCode", "key", "", "timestamp", "", "calculateScratchCode", "scratchCodeBuffer", "calculateScratchCodes", "", "buffer", "calculateValidationCode", "checkCode", "code", "window", "createCredentials", "Lcom/ackbox/totp/google/GoogleTOTPCredentials;", "createOneTimePassword", "generateScratchCode", "getTimeWindowFromTime", "validateScratchCode", "scratchCode", "Companion", "ackbox-totp"})
public final class GoogleAuthenticator
implements TOTPAuthenticator {
    private final ReseedingSecureRandom secureRandom;
    private final GoogleAuthenticatorConfig config;
    private static final int SECRET_BITS = 80;
    private static final int SCRATCH_CODES = 5;
    private static final int SCRATCH_CODE_LENGTH = 8;
    private static final int SCRATCH_CODE_MODULUS;
    private static final int SCRATCH_CODE_INVALID = -1;
    private static final int BYTES_PER_SCRATCH_CODE = 4;
    private static final String HMAC_HASH_FUNCTION = "HmacSHA1";
    public static final Companion Companion;

    @Override
    @NotNull
    public GoogleTOTPCredentials createCredentials() {
        byte[] buffer = new byte[SECRET_BITS / 8 + SCRATCH_CODES * BYTES_PER_SCRATCH_CODE];
        this.secureRandom.nextBytes(buffer);
        byte[] key = Arrays.copyOf(buffer, SECRET_BITS / 8);
        Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"key");
        int validationCode = this.calculateValidationCode(key);
        List<Integer> scratchCodes = this.calculateScratchCodes(buffer);
        return new GoogleTOTPCredentials(new TOTPSecretKey(key), validationCode, scratchCodes);
    }

    @Override
    public boolean authorize(@NotNull TOTPSecretKey secretKey, int totp, @NotNull Instant time) {
        Intrinsics.checkParameterIsNotNull((Object)secretKey, (String)"secretKey");
        Intrinsics.checkParameterIsNotNull((Object)time, (String)"time");
        if (totp <= 0 || (long)totp >= this.config.getKeyModulus()) {
            return false;
        }
        return this.checkCode(secretKey.getValue(), totp, time, this.config.getWindowSize());
    }

    @Override
    public int createOneTimePassword(@NotNull TOTPSecretKey secretKey, @NotNull Instant time) {
        Intrinsics.checkParameterIsNotNull((Object)secretKey, (String)"secretKey");
        Intrinsics.checkParameterIsNotNull((Object)time, (String)"time");
        return this.calculateCode(secretKey.getValue(), this.getTimeWindowFromTime(time));
    }

    /*
     * WARNING - void declaration
     */
    private final int calculateCode(byte[] key, long timestamp) {
        byte[] bigEndianTimestamp = new byte[8];
        long value = timestamp;
        int n = 8;
        while (n-- > 0) {
            bigEndianTimestamp[n] = (byte)value;
            value >>>= 8;
        }
        SecretKeySpec signKey = new SecretKeySpec(key, HMAC_HASH_FUNCTION);
        try {
            Mac mac = Mac.getInstance(HMAC_HASH_FUNCTION);
            mac.init(signKey);
            byte[] hash = mac.doFinal(bigEndianTimestamp);
            byte by = hash[hash.length - 1];
            int n2 = 15;
            byte offset = (byte)(by & n2);
            long truncatedHash = 0L;
            int n3 = 0;
            int n4 = 3;
            while (n3 <= n4) {
                void i;
                truncatedHash <<= 8;
                truncatedHash |= (long)(hash[offset + i] & 0xFF);
                ++i;
            }
            truncatedHash &= Integer.MAX_VALUE;
            return (int)(truncatedHash %= this.config.getKeyModulus());
        }
        catch (NoSuchAlgorithmException e) {
            throw (Throwable)new TOTPException("The operation cannot be performed now.", e);
        }
        catch (InvalidKeyException e) {
            throw (Throwable)new TOTPException("The operation cannot be performed now.", e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkCode(byte[] key, int code, Instant timestamp, int window) {
        long timeWindow = this.getTimeWindowFromTime(timestamp);
        int start = -((window - 1) / 2);
        int n = start;
        int end = window / 2;
        int n2 = end;
        if (n <= n2) {
            while (true) {
                void i;
                int hash;
                if ((hash = this.calculateCode(key, timeWindow + (long)i)) == code) {
                    return true;
                }
                if (i == n2) break;
                ++i;
            }
        }
        return false;
    }

    private final int calculateValidationCode(byte[] key) {
        return this.calculateCode(key, 0L);
    }

    private final long getTimeWindowFromTime(Instant time) {
        return time.toEpochMilli() / this.config.getTimeStepSize().toMillis();
    }

    private final List<Integer> calculateScratchCodes(byte[] buffer) {
        ArrayList<Integer> scratchCodes = new ArrayList<Integer>();
        while (scratchCodes.size() < SCRATCH_CODES) {
            byte[] scratchCodeBuffer = Arrays.copyOfRange(buffer, SECRET_BITS / 8 + BYTES_PER_SCRATCH_CODE * scratchCodes.size(), SECRET_BITS / 8 + BYTES_PER_SCRATCH_CODE * scratchCodes.size() + BYTES_PER_SCRATCH_CODE);
            Intrinsics.checkExpressionValueIsNotNull((Object)scratchCodeBuffer, (String)"scratchCodeBuffer");
            int scratchCode = this.calculateScratchCode(scratchCodeBuffer);
            if (scratchCode != SCRATCH_CODE_INVALID) {
                scratchCodes.add(scratchCode);
                continue;
            }
            scratchCodes.add(this.generateScratchCode());
        }
        return scratchCodes;
    }

    private final int generateScratchCode() {
        byte[] scratchCodeBuffer;
        int scratchCode;
        do {
            scratchCodeBuffer = new byte[BYTES_PER_SCRATCH_CODE];
            this.secureRandom.nextBytes(scratchCodeBuffer);
        } while ((scratchCode = this.calculateScratchCode(scratchCodeBuffer)) == SCRATCH_CODE_INVALID);
        return scratchCode;
    }

    /*
     * WARNING - void declaration
     */
    private final int calculateScratchCode(byte[] scratchCodeBuffer) {
        if (scratchCodeBuffer.length < BYTES_PER_SCRATCH_CODE) {
            throw (Throwable)new IllegalArgumentException("The provided random byte buffer is too small " + scratchCodeBuffer.length + '.');
        }
        int scratchCode = 0;
        int n = 0;
        int n2 = BYTES_PER_SCRATCH_CODE - 1;
        if (n <= n2) {
            while (true) {
                void i;
                byte by = scratchCodeBuffer[i];
                byte by2 = (byte)255;
                int n3 = scratchCode << 8;
                byte by3 = (byte)(by & by2);
                scratchCode = n3 + by3;
                if (i == n2) break;
                ++i;
            }
        }
        if (this.validateScratchCode(scratchCode = (scratchCode & Integer.MAX_VALUE) % SCRATCH_CODE_MODULUS)) {
            return scratchCode;
        }
        return SCRATCH_CODE_INVALID;
    }

    private final boolean validateScratchCode(int scratchCode) {
        return scratchCode >= SCRATCH_CODE_MODULUS / 10;
    }

    public GoogleAuthenticator(@NotNull GoogleAuthenticatorConfig config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        this.config = config;
        this.secureRandom = new ReseedingSecureRandom();
    }

    public /* synthetic */ GoogleAuthenticator(GoogleAuthenticatorConfig googleAuthenticatorConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            googleAuthenticatorConfig = new GoogleAuthenticatorConfig(null, 0, 0, 0L, 15, null);
        }
        this(googleAuthenticatorConfig);
    }

    public GoogleAuthenticator() {
        this(null, 1, null);
    }

    static {
        Companion = new Companion(null);
        SECRET_BITS = 80;
        SCRATCH_CODES = 5;
        SCRATCH_CODE_LENGTH = 8;
        SCRATCH_CODE_MODULUS = (int)Math.pow(10.0, SCRATCH_CODE_LENGTH);
        SCRATCH_CODE_INVALID = -1;
        BYTES_PER_SCRATCH_CODE = 4;
        HMAC_HASH_FUNCTION = HMAC_HASH_FUNCTION;
    }

    @Override
    @NotNull
    public String createQRCode(@Nullable String issuer, @NotNull String accountName, @NotNull TOTPSecretKey secretKey) {
        Intrinsics.checkParameterIsNotNull((Object)accountName, (String)"accountName");
        Intrinsics.checkParameterIsNotNull((Object)secretKey, (String)"secretKey");
        return TOTPAuthenticator.DefaultImpls.createQRCode(this, issuer, accountName, secretKey);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/ackbox/totp/google/GoogleAuthenticator$Companion;", "", "()V", "BYTES_PER_SCRATCH_CODE", "", "HMAC_HASH_FUNCTION", "", "SCRATCH_CODES", "SCRATCH_CODE_INVALID", "SCRATCH_CODE_LENGTH", "SCRATCH_CODE_MODULUS", "SECRET_BITS", "ackbox-totp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

